// 
// viewstatic() - version 1.0
// 
// Allows for viewing of the values which are stored in the Memvar Table
// end of DGROUP, where Clipper static variables and ITEMs stored through 
// ITEM.API are actually stored.
// 
// Copyright(C) 1993, Robert G. Montgomery.  All Rights Reserved.
//
// You are hereby granted rights to include this function in your application
// programs, free of charge, and if deemed necessary, you may also distribute
// the source for the function with the source for any applications which use
// them, free of charge.
//
// This program is useful for debugging applications which call functions
// which allocate ITEMs through ITEM.API and forget to release them.  Such
// buggy routines will cause the number of Memvar Table values to increase
// each time the buggy routine is executed.  Only routines written in C or
// ASM can allocate items, which includes most third party libraries.  This 
// function allows you to see what values are being lost, which can be very 
// useful in determining what is losing them, and where.
// 
// viewstatic() takes no parameters, and returns NIL when completed.  It 
// calls the functions DG_statics() and DG_stathex() to get the Memvar 
// Table information to be displayed, and it calls achoice() without a user
// function, so default achoice() keystroke behavior is used.  Therefore,
// press <Esc> or <Enter> when finished viewing the list.
//
// Note that DG_statics() and DG_stathex() are C functions included with
// DGROUP.ZIP which access UNDOCUMENTED internals in CLIPPER.LIB.  I only
// know that they work with Clipper 5.2c, and I assume that they work with
// Clipper 5.0 - 5.2c.  They probably will not work with some future version
// of Clipper, so do not write programs which depend on them.  Use them with
// caution.
//

procedure viewstatic
  local values := DG_statics()
  local hexdumps := DG_stathex()
  local ii_end, ttmp
  local view_array := {}
  local ss := savescreen()
  local counter := 1, disp_count
  ii_end := len(values)
  clear screen
  @ 0, 1 say "Memvar Table, listing Clipper static variables and allocated ITEMs."
  @ 1, 0, 24, 79 box B_SINGLE
  @ 1,  6 say "VALUE in Hex. "
  @ 1, 37 say "Stored Value "
  for ii := 1 to ii_end
    if hexdumps[ii]==nil
      ttmp := str(counter++,4)+'XXXXXXXXXXXXXXXXXXXXXXXXXXXX'+valtype(values[ii])+''
    else
      ttmp := str(counter++,4)+''+hexdumps[ii]+''+valtype(values[ii])+''
    endif
    if valtype(values[ii])=='C'
      ttmp+=left(values[ii],40)
    elseif valtype(values[ii])=='B'
      ttmp+='{|| ... }'
    elseif valtype(values[ii])=='A'
      ttmp+='{ ... }'
    elseif valtype(values[ii])=='N'
      ttmp+=str(values[ii])
    elseif valtype(values[ii])=='L'
      ttmp+=iif(values[ii],'.T.','.F.')
    elseif valtype(values[ii])=='D'
      ttmp+=dtoc(values[ii])
    endif
    aadd(view_array,ttmp)
  next
  ttmp := disp_count := dispcount()
  do while (ttmp--)>0
    dispend()
  enddo
  achoice(2,1,23,78,view_array)
  do while (disp_count--)>0
    dispbegin()
  enddo
  restscreen(,,,,ss)
  return
