//.............................................................................
//
//   Program Name: NTXREC.C          Copyright: RCM Software Pty. Ltd.
//   Date Created: 03/05/91           Language: Microsoft C 5.1
//   Time Created: 13:21:00             Author: Graham D. McKechnie
//
//   Returns dbf record number from index position
//   eg.
//   nNtxPos   := 677
//   nDbfRecNo := NtxRec( "contact", nNtxPos )
//.............................................................................


#include "extend.h"


#define open  _topen                // Use Clipper's internals
#define close _tclose               // Don't have to link LLIBCA
#define lseek _tlseek
#define read  _tread

extern int  _topen( char*, int);
extern int  _tclose( int );
extern long _tlseek( int, long, int);
extern int  _tread( int, char*, int);


#define BUFF_SIZE   1024
#define ERROR       -1
#define MAX_KEY     256
#define O_RDONLY    0x0000  // open for reading only
#define O_BINARY    0x8000  // file mode is binary (untranslated)

//
// DJF: This is a bit of a hack, but it works. These constants were 
//      gleaned from <share.h>, one of MSC 5.1's include headers
//      It may be prudent for you to rename them at some point so
//      Microsoft's lawyers don't hunt you down like a wild dog....
//

#define SH_COMPAT   0x00    /* compatibility mode */
#define SH_DENYRW   0x10    /* deny read/write mode */
#define SH_DENYWR   0x20    /* deny write mode */
#define SH_DENYRD   0x30    /* deny read mode */
#define SH_DENYNO   0x40    /* deny none mode */


// Index structures
typedef struct
{
   unsigned  uSign;
   unsigned  uVersion;
   long      lRoot;
   long      lNextPage;
   unsigned  uItemSize;
   unsigned  uKeySize;
   unsigned  uKeyDec;
   unsigned  uMaxItem;
   unsigned  uHalfPage;
   char      cKeyExpr[MAX_KEY];
   Boolean   bUnique;
} NTXHEADER;


typedef struct
{
   long lPage;
   long lRecNo;
   char cKey;
} ITEM;


typedef struct
{
   unsigned uCount;
   unsigned uRef;
} BUFFER;





static Boolean bError = FALSE;
static Boolean bFound = FALSE;

static long lRetVal;            // Return value
static long lNtxPos;            // Index position
static int  nNtxHandle;         // Index file handle



CLIPPER ntxrec()

{

   long lNtxRecNo;
   char *cNtxName;

   NTXHEADER NtxHeader;


   // Check the parameters passed from Clipper
   if ( PCOUNT != 2 )
   {
      _retni(-1);
      return;
   }

   if ( ! (ISCHAR(1) && ISNUM(2) ) )
   {
      _retni(-1);
      return;
   }


   cNtxName  = _parc(1);     // Index file we are searching
   lNtxRecNo = _parnl(2);    // RECNO() we are looking for

   lRetVal   = 0L;           // Set these each time
   lNtxPos   = 0L;
   bFound    = FALSE;

   // DJF:
   // Make sure we include Shared Deny None as an open mode on the ORing...
   // Otherwise Windows will Deny you the right to run DEMO.EXE...

   nNtxHandle = open( cNtxName, O_BINARY|O_RDONLY|SH_DENYWR);
   if ( nNtxHandle == -1 )
      goto ERROR_EXIT;


   // read the header
   if ( read ( nNtxHandle, (char *) &NtxHeader, sizeof(NtxHeader) )
                  != sizeof(NtxHeader) )
      goto ERROR_EXIT;

   // start the traversal from root
   DumpPage1( NtxHeader.lRoot, lNtxRecNo );

   if (bError)
   {
      ERROR_EXIT:
      bError = TRUE;
   }

   close( nNtxHandle );
   _retnl( lRetVal );


}



DumpPage1(long lPageOffSet, long lNtxRecNo)

{
   char     *cPage;
   ITEM     *item;
   BUFFER   *buffer;
   unsigned i;
   unsigned *uItemRef;

   /* allocate page */
   cPage = _xalloc(BUFF_SIZE);

   /* move to this position in the file */
   if( lseek( nNtxHandle, lPageOffSet, 0 ) != (long)lPageOffSet )
      goto DUMP_EXIT;

   /* read the page */
   if( read( nNtxHandle, cPage, BUFF_SIZE) != BUFF_SIZE )
      goto DUMP_EXIT;


   buffer   = (BUFFER *) cPage;
   uItemRef = &buffer -> uRef;


   for (i = 0; i < buffer -> uCount; i++)
   {
      item = (ITEM *) &cPage[ uItemRef[ i ] ];

      if ( ! bFound )
      {
         if ( item -> lPage )
            DumpPage1( item -> lPage, lNtxRecNo );

         if (bFound)
         {
            _xfree( cPage );
            return;
         }
         lNtxPos++;
      }

      if ( lNtxPos == lNtxRecNo )
      {

         lRetVal = item->lRecNo;
         bFound = TRUE;
         break;
      }
   }

   if ( ! bFound )    // Wasn't finding Williams properly
   {
      /* handle extra right pointer */
      item = (ITEM *) &cPage[ uItemRef[ buffer -> uCount ] ];
      if ( item -> lPage )
         DumpPage1(item -> lPage, lNtxRecNo );
   }

   _xfree( cPage );

   if ( bError )
   {
      DUMP_EXIT:
      _xfree( cPage );
      bError = TRUE;
   }
}

