/***
*  MENU.PRG
*  Clipper 5.01
*  Generic menu program
*
*  Copyright (c) 1991 Nantucket Corp.  All rights reserved.
*       Written by Roy Corneloues on 06/07/91 at 04:46:51
*
*  Notes: This module relies on MENU.LIB and for the CUA menu
*         SAMPLE.LIB
*
*         To compile th different menu options, use the following
*         syntax:
*
*            RMAKE Menu.rmk /F /Dmenu:<menuId>
*
*         where <menuId> can be:
*
*            DBNUM   - Create a vertical numeric selection style menu
*
*            DBCHR   - Create a vertical alphabetic selection style menu
*
*            CUA     - Create a CUA menu using OMenu()
*
*            ACHOICE - Create an ACHOICE() menu
*
*            MENUTO  - Create a MENU TO menu
*
*         If not specified, <menuId> defaults to DBNUM
*         <menuId> must be entered in upper case
*
*/

#ifdef  DBNUM
#include 'Dbase.ch'
#endif

#ifdef  DBCHR
#include 'Dbasechr.ch'
#endif

#ifdef  CUA
#include 'Cuamenu.ch'
#endif

#ifdef  ACHOICE
#include 'Array.ch'
#endif

#ifdef  MENUTO
#include 'Menuto.ch'
#endif


FUNCTION Main
   LOCAL aMenu
   LOCAL nChoice
   LOCAL cLastColor := SETCOLOR("+W/B, +W/R")

   CREATE MENU aMenu TITLE "Main Menu"

   ADD OPTION "Add" TO aMenu
   ADD OPTION "Edit" TO aMenu
   ADD OPTION "Delete" TO aMenu
   ADD OPTION "Search" TO aMenu
   ADD OPTION "Quit" TO aMenu

   CLS
   ACTIVATE MENU aMenu TO nChoice

   CLS
   @ 12, 0 SAY "You Chose Option: " + STR(nChoice, 3)
   INKEY(0)

   SETCOLOR(cLastColor)
   CLS

   RETURN (nChoice)

// End of Menu.prg
