* Program..: DEVELOP.PRG
* Author...: John C. White (Variations on a progrm by Tom Rettig)
* Date.....: 02/18/86
* Version..: dBASE III Plus
* Notes....: This program sets up the header information and creates
*            initialization, REPLACE and STORE records if a datafile
*            is given.  If you have any questions you can reach me on
*            Compuserve(76555,711) or The Source(NAN775)
*            or call (602)869-9644.
*
* Set up environment...
SET TALK OFF
* Set up screen...
CLEAR
@  1, 0 SAY 'NEW PROGRAM OUTLINE'
@  1,72 SAY date()
@  2, 0 SAY REPLICATE(CHR(205),80)
@ 12,10 SAY 'Please enter new program name...'

DO WHILE .T.
  Mprogram = SPACE(8)
  @ 12,43 GET Mprogram PICTURE '!!!!!!!!'
  READ
  Mcmd = '?'
  @ 14,10 SAY 'Is this correct?(Y/N)...'
  DO WHILE .NOT. Mcmd$'YN'
    Mcmd = '?'
    @ 14,35 GET Mcmd PICTURE '!'
    READ
  ENDDO [Mcmd]
  @ 14, 0
  IF Mcmd = 'Y'
    EXIT
  ELSE
    LOOP
  ENDIF
ENDDO [T]

IF Mprogram = ' '
  Mword = 'Program name cannot be blank.'
  Mcol = INT((80-LEN(Mword))/2)
  @ 22, 0 CLEAR
  @ 22,Mcol SAY Mword
  @ 23,26 SAY 'Press ANY KEY to END...'
  SET CONSOLE OFF
  WAIT
  SET CONSOLE ON
  CLEAR
  RETURN
ENDIF [Mprogram]

SET CONSOLE OFF
Mprogram = TRIM(Mprogram) + '.PRG'
SET ALTERNATE TO &Mprogram
SET ALTERNATE ON
?? '* Program..: ' + Mprogram
? '* Author...: <put your name here>
? '* Date.....: '+DTOC(date())
? '* Version..: dBASE III Plus'
? '* Notes....: '
?
?
? '** [EOF ' + Mprogram +']'
SET CONSOLE ON

Mcmd = '?'
@ 14,10 SAY 'Do you want a file included?(Y/N)...'
DO WHILE .NOT. Mcmd$'YN'
  Mcmd = '?'
  @ 14,47 GET Mcmd PICTURE '!'
  READ
ENDDO [Mcmd]
@ 14, 0
IF Mcmd = 'Y'
  @ 14,10 SAY 'Enter <data file name> with no extension --'+ CHR(16)
  DO WHILE .T.
    Mdatafile = SPACE(8)
    @ 14,55 GET Mdatafile PICTURE '!!!!!!!!'
    READ
    Mcmd = '?'
    @ 16,10 SAY 'Is this correct?(Y/N)...'
    DO WHILE .NOT. Mcmd$'YN'
      Mcmd = '?'
      @ 16,35 GET Mcmd PICTURE '!'
      READ
    ENDDO [Mcmd]
    @ 16, 0
    IF Mcmd = 'Y'
      EXIT
    ELSE
      LOOP
    ENDIF
  ENDDO [T]
  
  STORE TRIM(Mdatafile)+'.DBF' TO Mdatafile
  * Open the file if it exists, otherwise exit...
  IF FILE(Mdatafile)
    USE &Mdatafile
  ELSE
    * Close the textfile...
    SET ALTERNATE OFF
    CLOSE ALTERNATE

    Mword = Mdatafile+" does not exist where I'm looking for it."
    Mcol = INT((80-LEN(Mword))/2)
    @ 22, 0 CLEAR
    @ 22,Mcol SAY Mword
    @ 23,26 SAY 'Press ANY KEY to END...'
    SET CONSOLE OFF
    WAIT
    SET CONSOLE ON
    SET TALK ON
    CLEAR
    RETURN
  ENDIF

  * Copy to a structure extended file to access the fieldnames...
  COPY TO TEMP STRUCTURE EXTENDED
  USE TEMP

  * Convert field names to lower case...
  REPLACE ALL field_name WITH LOWER(field_name)

  SET CONSOLE OFF
  ?
  ?
  ? '*** Initialization, STORE and REPLACE statements...'
  ?
  * Output the initialization statements...
  zeros = '00000000000000000000'
  GO TOP
  DO WHILE .NOT. EOF()
    DO CASE
       CASE field_type = 'C'
         ? 'M'+SUBSTR(field_name,1,9)+' = SPACE('+;
  	     STR(field_len,2)+')'
       CASE field_type = 'N' .AND. field_dec=0
         ? 'M'+SUBSTR(field_name,1,9)+' = '+;
  	     SUBSTR(zeros,1,field_len-field_dec)
       CASE field_type = 'N' .AND. field_dec>0
         ? 'M'+SUBSTR(field_name,1,9)+' = '+;
  	     SUBSTR(zeros,1,field_len-field_dec-1)+'.'+;
  	     SUBSTR(zeros,1,field_dec)
       CASE field_type = 'L'
         ? 'M'+SUBSTR(field_name,1,9)+' = .F.'
       CASE field_type = 'D'
         ? 'M'+SUBSTR(field_name,1,9)+" = CTOD('  /  /  ')"
    ENDCASE
    SKIP
  ENDDO

  * Output the STORE statements...
  ?
  GO TOP
  DO WHILE .NOT. EOF()
    ? 'M'+SUBSTR(field_name,1,9)+' = '+ TRIM(field_name)
    SKIP
  ENDDO

  * Output the REPLACE statements
  ?
  GO TOP
  DO WHILE .NOT. EOF()
    ? 'REPLACE '+field_name+'WITH M'+ TRIM(SUBSTR(field_name,1,9))
    SKIP
  ENDDO

  SET CONSOLE ON
  * Do the housekeeping...
  CLOSE DATABASES
  ERASE TEMP.DBF
ENDIF [Mcmd = Y]

* Close the textfile...
SET ALTERNATE OFF
CLOSE ALTERNATE
SET TALK ON
CLEAR
RETURN
** [EOF DEVELOP.PRG]

                                                                    