(*
 * Program : DELNULLS.EXE
 * Author  : Bill Mullen (ATTBS ->BIG5)
 * Language: Turbo Pascal 6.0
 *
 * Syntax  : DELNULLS <filename.ext>
 *
 * Notes   : Hope it helps someone.  Kinda paying back for the help I've
 *           received.
 *)

{$m $400,0,0}
program remove_nulls;

uses
   dos;


const
   OldChar = #0;    (* Change this to any character you want converted       *)
   NewChar = #32;   (* This character will replace all occurences of OLDCHAR *)


type
   Buffer   = Array [1..1024] of byte;


var
   FileName  : String;
   FileHndl  : File;
   Buf       : Buffer;
   BufCntr   : Word;
   NumRead   : Word;
   CurrPos   : LongInt;
   ExitSafe  : Pointer;
   FileOpen  : Boolean;
   SR        : SearchRec;


{$f+}
procedure SafeExit; Far;
begin
   ExitProc := ExitSafe;
   if FileOpen then
      Close(FileHndl);
end;



begin
   (* Set up exit routine *)
   ExitSafe := ExitProc;
   ExitProc := @SafeExit;
   FileOpen := False;

   (* Was a file passed to the program *)
   if ParamCount = 0 then
      Halt(1);

   (* Save the parameter to a variable *)
   FileName := paramstr(1);

   (* Now see if the file exist... *)
   FindFirst(FileName,AnyFile,SR);
   if DosError <> 0 then
      halt(2);

   (* Open the file for READ/WRITE *)
   Assign (FileHndl,FileName);
   Reset  (FileHndl,1);
   FileOpen := True;

   (*
    * Read from the file 1 buffer at a time, replacing all OLDCHAR's with
    * NEWCHAR's and write the buffer back to the file.
    *)

    repeat
       CurrPos := FilePos(FileHndl);
       blockread(FileHndl,Buf,SizeOf(Buf),NumRead);
       for BufCntr := 1 to NumRead do
          if Buf[BufCntr] = ord(OldChar) then
             Buf[BufCntr] := ord(NewChar);
       Seek(FileHndl,Currpos);
       BlockWrite(FileHndl,Buf,NumRead);
    until (NumRead = 0);

    (* Close the file *)
    Close(FileHndl);
    FileOpen := False;
    Halt(0);
end.
