*:*********************************************************************
*:
*:        Program: DED341.PRG
*:
*:         System: Local Library Procedures & Functions
*:         Author: Don Doyle
*:      Copyright (c) 1990, Don Doyle
*:  Last modified: 03/26/90     13:34
*:
*:  Procs & Fncts: O_ASIZE()
*:
*:     Documented: 03/26/90 at 13:39                SNAP! version 3.10
*:*********************************************************************

*  This is a clone of STRALEY's O_ASIZE function using buffered file i/o.
*  The buffering produces acceptable performance.

********************

FUNCTION o_asize

PARAMETERS _ofile, _array

PRIVATE _cnt, _fh, _line, _buf, _end, _sp, _x

IF PCOUNT() > 1               && check array parm
   IF TYPE("_array") != "A"
      RETURN(0)
   ENDIF
ENDIF
IF PCOUNT() > 0               && check file parm
   IF !FILE(_ofile)
      RETURN(0)
   ENDIF
ELSE
   RETURN(0)                  && no parms, exit
ENDIF


_fh = FOPEN(_ofile)           && try to open file
IF _fh < 0
   RETURN(0)                  && exit if error
ENDIF

_buf = SPACE(1024)            && init buffer
_line = ''                    && init line buffer
_cnt = 0                      && init line count
_end = 1                      && set buff end and buff ptr to force
_sp = 2                       && a buffer read.

DO WHILE _end # 0
   DO WHILE .T.                               && start getline loop
      IF _sp > _end                           && if buffer empty
         _end = FREAD(_fh, @_buf, len(_buf))  && read up to 1K bytes
         IF _end <= 0                         && if nothing to read
            EXIT                              && exit
         ENDIF
         _sp = 1              && point to beginning of buffer
      ENDIF

      _x = AT(CHR(10),SUBSTR(_buf, _sp,1+_end-_sp))  && find new line char
      IF _x = 0                           && if none in buffer
         _line = _line + SUBSTR(_buf, _sp,1+_end-_sp)
         _sp = _end + 1
         LOOP
      ENDIF

      IF _x > 1                           && found a line
         _line = _line + SUBSTR(_buf, _sp, _x-2)
      ELSE
         _line = SUBSTR(_line, 1, LEN(_line)-1) && remove CHR(13)
      ENDIF
      _sp = _sp + _x
      EXIT
   ENDDO

   _line = LTRIM(TRIM(_line))
   IF !EMPTY(_line)
      IF !SUBSTR(_line,1,1) == "*"
         _cnt = _cnt + 1
         IF PCOUNT() = 2
            _array[_cnt] = _line
         ENDIF
      ENDIF
      _line = ""
   ENDIF
ENDDO
FCLOSE(_fh)
RETURN(_cnt)

*: EOF: DED341.PRG

