/***********************************************************************

Program....: DDS
Author.....: Chuck Thompson [CompuServe: 72311,2063]
Date.......: November, 1990
Purpose....: Display .DBF structures

***********************************************************************/
#include <conio.h>           /* Turbo C 2.0 */
#include <dir.h>
#include <stdio.h>
#include <string.h>

#define  TITLE               "DDS-Display DBF Structure, v1.00, C. Thompson\n"
#define  USAGE               "Usage:  DDS [dr:][path]filename[.DBF]"
#define  MEMORY              "Internal Error: Unable to allocate memory"
#define  NO_FILE             "%s not found..."
#define  NO_DBF              "%s is not a dBASE file or the header is corrupt...\n"

#define  DBF                 ".DBF"
#define  DBF_STAMP           0x03      /* stamp for database file */
#define  DBT_STAMP           0x83      /* stamp for DBF with memos */

#define  PRT1                "Structure displayed for %s\n"
#define  PRT2                " Date of last update is %02d/%02d/%02d\n"
#define  PRT3                "   Number of records is %d\n"
#define  PRT4                "\nFld  Name        Type       Len  Dec\n"
#define  PRT5                "%3d  %-10s  %-9s  %3d  %3d\n"
#define  PRT6                "                          -----"
#define  PRT7                "** Total **                 %3d\n"
#define  MORE                "More..."

#define  TRUE                1
#define  FALSE               0

typedef  unsigned char  byte;
typedef  unsigned int   word;
typedef  long int       dword;

struct   DBF_HEADER
{
   byte  signature;                    /* 03 = dbf, 83 dbf+dbt */
   byte  ymd[3];                       /* y+1900 m d */
   dword rec_cnt;                      /* number of data records */
   word  offset;                       /* offset to data records */
   word  rec_size;                     /* size of data records */
   byte  pad[20];                      /* filler */
};

struct   DBF_FDESC
{
   byte  desc[10];                     /* field description */
   byte  pad1;                         /* filler */
   byte  type;                         /* field type */
   byte  pad2[4];                      /* filler */
   byte  len;                          /* field length */
   byte  dec;                          /* field decimals */
   byte  pad3[14];                     /* filler */
};

/*
   Function Declarations
*/
void  main(int argc, char *argv[]);    /* main driver */
char  getname(char *test);             /* pass test name return complete */
void  TermPgm(char *msg);              /* exit with message */
void  PauseScreen(void);               /* full screen pause */

/**********************************************************************/
void  main(int argc, char *argv[])     /* main driver */
/**********************************************************************/
{
   struct   DBF_HEADER *hdr;           /* pointer to header structure */
   struct   DBF_FDESC  *rec;           /* pointer to description structure */
   char     chkext[MAXEXT];            /* extension */
   char     dbfname[MAXPATH];          /* fully qualified name */
   char     msg[80];                   /* message buffer */
   char     more;                      /* process control switch */
   int      chkflag=0;                 /* flags */
   int      fcnt=0;                    /* field count */
   int      lines=7;                   /* line counter (lines before detail) */
   FILE     *dbf;                      /* DBF handle */

   puts(TITLE);                        /* program name */
   if(argc==2)                         /* must have a file to use */
   {
      strcpy(dbfname,argv[1]);         /* copy user input file */
      chkflag=fnsplit(dbfname,0,0,0,chkext);
      if(chkflag & EXTENSION)          /* check for extension */
      {                                /* found, verify extension */
         if(strcmp(strupr(chkext),DBF)!=0)
            TermPgm(USAGE);            /* no .DBF extension */
      }
      else                             /* not found */
         strcat(dbfname,DBF);          /* add proper extension */
      getname(dbfname);                /* qualify the name */
   }
   else
      TermPgm(USAGE);                  /* errors, exit with message */

   if((dbf=fopen(dbfname,"rb"))==NULL) /* open file, check for errors */
   {
      sprintf(msg,NO_FILE,dbfname);    /* complete the string */
      TermPgm(msg);                    /* exit on errors */
   }
                                       /* allocate space for structs */
   if((hdr=(struct DBF_HEADER *)malloc(sizeof(struct DBF_HEADER)))==NULL)
      TermPgm(MEMORY);                 /* exit on errors */
   if((rec=(struct DBF_FDESC *)malloc(sizeof(struct DBF_FDESC)))==NULL)
      TermPgm(MEMORY);                 /* exit on errors */
                                       /* read the DBF header */
   fread(hdr,sizeof(struct DBF_HEADER),1,dbf);
   if((hdr->signature==DBF_STAMP) ||
      (hdr->signature==DBT_STAMP))     /* check stamp on file */
   {                                   /* good file */
      printf(PRT1,dbfname);            /* print specifics */
      printf(PRT2,hdr->ymd[1],hdr->ymd[2],hdr->ymd[0]);
      printf(PRT3,hdr->rec_cnt);
      printf(PRT4);                    /* headings */

      more=TRUE;                       /* process control switch */
      while(more)                      /* loop through descriptions */
      {                                /* read the field description */
         fread(rec,sizeof(struct DBF_FDESC),1,dbf);
         if((rec->desc[0]==0x0d) ||
            feof(dbf))                 /* no more descriptions or EOF */
            more=FALSE;                /* complete processing */
         else
         {                             /* process current description */
            fcnt++;                    /* increment field count */
            switch(rec->type)          /* check the type */
            {                          /* create string for display */
               case 'C':               /* character */
                  strcpy(msg,"Character");
                  break;
               case 'N':               /* numeric */
                  strcpy(msg,"Numeric");
                  break;
               case 'L':               /* logical */
                  strcpy(msg,"Logical");
                  break;
               case 'D':               /* date */
                  strcpy(msg,"Date");
                  break;
               case 'M':               /* memo */
                  strcpy(msg,"Memo");
                  break;
               default:                /* error condition */
                  strcpy(msg,"Unknown");
            }                          /* print the current description */
            printf(PRT5,fcnt,rec->desc,msg,rec->len,rec->dec);
            if(lines++>24)             /* increment and check lines */
            {
               PauseScreen();          /* pause display */
               lines=0;                /* reset counter */
            }
         }
      }
      puts(PRT6);                      /* seperator */
      printf(PRT7,hdr->rec_size);      /* data record size */
   }
   else
      printf(NO_DBF,dbfname);          /* complete the string */

   free(rec);                          /* release memory */
   free(hdr);
   fclose(dbf);                        /* release handle */
}

/**********************************************************************/
void  TermPgm(char *msg)               /* exit with message */
/**********************************************************************/
{
   puts(msg);
   exit(1);
}

/**********************************************************************/
void  PauseScreen(void)                /* full screen pause */
/**********************************************************************/
{
   register i;                         /* loop counter */

   printf(MORE);                       /* display message */
   getch();                            /* wait for keystroke */
   for(i=0;i<strlen(MORE);i++)         /* remove message */
   {
      putchar('\b');
      putchar(' ');
      putchar('\b');
   }
}

