* Program ......: Alphanum.PRG
* Author .......: Michael B. Carlisle
* Date .........: February 1, 1988
* Version ......: dBASE III PLUS
* Notes ........: Program to build sort key for alphanumeric
*                 index.
*
*                 DO Alph_num WITH fl_name, sort_fld, key_fld
*
*                      fl_name  = Name of database file to index.
*                      sort_fld = Name of field to build
*                                 new sort key from.
*                      key_fld  = Name of field to place
*                                 new sort key in.
*
PARAMETERS fl_name, sort_fld, key_fld
*
SET TALK OFF
*
sortlist = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"
USE &fl_name
GO TOP
DO WHILE .NOT. EOF()
   * ---Initialize variables.
   cntr = 1
   code = ""
   key  = UPPER(TRIM(&sort_fld))
   * ---Continue looping until all positions
   * ---in sort_fld have been assigned a value.
   DO WHILE cntr <= LEN(key)
      * ---Assign a value to current position of
      * ---sort_fld and concatenate with values
      * ---assigned to the previous positions.
      IF SUBSTR(key, cntr, 1) $ sortlist
         code = code + CHR(AT(SUBSTR(key, cntr, 1), sortlist) +
31)
      ENDIF
      * ---Increment counter for next position.
      cntr = cntr + 1
   ENDDO
   * ---Save newly created key to Key_fld.
   REPLACE &key_fld WITH code
   ? &sort_fld, code
   SKIP
ENDDO
RETURN
* EOP Alphanum.PRG
