/*Ŀ
 ݳ Program Name: ARG1.C            Copyright: Public Domain             
 ݳ     Language: Microsoft C                                            
 ݳ       Author: Kevin S Gallagher                                      
 Ĵ
 ݳ Comments:                                                            
 ݳ These two routines are for use in CA-Clipper 5.nn that allow you to  
 ݳ get the programs path and program name, and also all command-line    
 ݳ parameters, any place in a program.                                  
 
            */

#include <extend.h>
#include <string.h>
#include <stdio.h>

extern int __argc;
extern unsigned char**  __argv;


/*
* This routine returns the number of command line arguments from any place
* in your Clipper program.
*
* EXAMPLE:
* --------
* function main
*     cls
*     DataEntry()
* return nil
*
* function DataEntry()
*     ?"Params passed to this program ",getargc()
* return
*/
CLIPPER getargc( void )
{
    _retni( __argc - 1 );
}


/*
* This will return all parameters passed from DOS, any place within a
* Clipper program. Also GetArgv( 0 ) returns Path\program_name
*
*
* EXAMPLE:
* --------
* function main
*     cls
*     DataEntry()
* return nil
*
* function DataEntry()
*     local jj := 0
*
*     for jj := 1 to getargc()
*         ?"Param ", str(jj,2)," is ", getargv(jj)
*     next
*
* return
*/

CLIPPER getargv( void )
{
    int argnum;

    if (PCOUNT && ISNUM(1))
        argnum = _parni( 1 );
    else
        argnum = 0;
    if (argnum >= ( __argc ))  
        _retc("");
    else
        _retclen( __argv[argnum], strlen( __argv[argnum]) );

}

