/*
    05/30/91 at 22:45 - Catalog.exe

    This is in response to several expressions of interest
    in a program that would create a "catalog" of the various
    database and indexe files that make up a "project".

    By entering the command "catalog" at the DOS prompt,
    two databases will be created in the current directory:

       1.  database.dbf
       2.  indexes.dbf
    
    The "database" database will have the following 
    structure, and will contain a record for each
    field contained in each database found.
    
    FILENAME   C   10  0        /* database name where field is used */
    FIELDNAME  C   10  0        /* field name in that database */
    FIELDTYPE  C    1  0        /* field type in that database */ 
    FIELDWIDTH N    3  0        /* field width that database */ 
    DECIMALS   N   12  3        /* number of decimals for field */ 
    
    The "indexes" database will have the following 
    structure, and will contain a record for each
    each index file found. (Both FOX and DBASE index
    files will be processed.)
    
    FILETYPE C 10 0         /* "FOXBASE" for FOX, and "DBASE" for dBASE */
    FILENAME C 10 0         /* index file name */
    EXPRESSION C 220 0      /* index expression used to create that index */
*/
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <errno.h>

#define DB3MAIN			/* forces include of function definitions, */
/* so it must be before #include "db3.h"   */

#include    "catalog.h"
#include    "db3.h"

FOXANCHOR      *foxiopen();
DBANCHOR       *dbiopen();

main(argc, argv)
	int             argc;
	char          **argv;
{
	doidx();
    loadidx();
    
	dodbf();
    loaddb();
}

doidx()
{
	char           *p;
    int             foxrec = 0, dbaserec = 0, type = 0;
	FOXANCHOR      *foxptr;
	DBANCHOR       *dbptr;
    FILE           *indexes;
	struct find_t   files;

	if (_dos_findfirst("*.*", _A_NORMAL, &files) != 0) {
		perror("find_first");
		exit(0);
	}
    
    indexes= fopen("INDEXES.$$$", "w");
    if (indexes== NULL) {
        fprintf(stderr, "** ERROR: could not open \"INDEXES.$$$\"\n");
        exit(9);
    }
    
	while (_dos_findnext(&files) == 0) {
		if (p = (char *) strchr(files.name, '.')) {
			if (!strcmp(p, ".NDX")) {
				dbptr = dbiopen(files.name, O_RDONLY);
                fprintf(indexes, "DBASE|%-s|%-s\n", files.name, dbptr->keyexpr);
                ++dbaserec;
			} else if (!strcmp(p, ".IDX")) {
				foxptr = foxiopen(files.name, O_RDONLY);
                fprintf(indexes, "FOXBASE|%-s|%-s\n", files.name, foxptr->keyexpr);
                ++foxrec;
			}
		}
	}
    fclose(indexes);
    fprintf(stderr, "** FOXBASE INDEXES PROCESSED: %d\n", foxrec);
    fprintf(stderr, "**   DBASE INDEXES PROCESSED: %d\n", dbaserec);
    return(0);
}

loadidx()
{
    DBAREA  *area;
    FILE    *fd;
    char    c, *p, *tmpfile = "loadidx.$$$", buffer[81];
    char    filetype[20], filename[20], expression[221];
    int      retcode, records = 0;
    
    fd = fopen(tmpfile, "w");
    if (fd == NULL) {
        fprintf(stderr, "** ERROR: could not open \"loadidx.$$$\"\n");
        exit(9);
    }
    fprintf(fd, "FILETYPE C 10 0\n");
    fprintf(fd, "FILENAME C 10 0\n");
    fprintf(fd, "EXPRESSION C 220 0\n");
    fclose(fd);
    retcode = dcreat("INDEXES.DBF", tmpfile);
    if (retcode == 0)
        fprintf(stderr, "** FILE \"INDEXES.DBF\" CREATED\n");
    chmod ("INDEXES.DBF", S_IREAD|S_IWRITE);
    
    fd = fopen("INDEXES.$$$", "r");
    if (fd == NULL) {
        fprintf(stderr, "** ERROR: could not open \"indexes.$$$\"\n");
        exit(9);
    }
    
    /* open database file */
    area = dopen("INDEXES.DBF", O_RDWR | O_BINARY);

    /* open failed completely */
    if (area == NULL) {
        fprintf(stderr, "** ERROR: could not open \"indexes.dbf\"\n");
        exit(1);
    }
    
    while (fgets(buffer, 80, fd)) {
        sscanf(buffer, "%[^|]%c%[^|]%c%[^\n]", filetype, &c,filename, &c, expression);
        retcode = dappend(area);
        if (retcode) {
            fprintf(stderr, "** ERROR: LOADIDX DAPPEND ERROR: retcode=%d\n", retcode);
            exit(8);
        } else {
            p = (char *)strchr(filename, '.');
            if (p)
                *p = '\0';
            if (retcode = dputfld(area, "filetype", filetype))
                fprintf(stderr, "** ERROR: LOADIDX DPUTFLD ERROR: %s %d\n", filetype, retcode);
            else if (retcode = dputfld(area, "filename", filename))
                fprintf(stderr, "** ERROR: LOADIDX DPUTFLD ERROR: %s %d\n", filename, retcode);
            else if (retcode = dputfld(area, "expression", expression))
                fprintf(stderr, "** ERROR: LOADIDX DPUTFLD ERROR: %s %d\n", expression, retcode);
            else if (retcode = dputrec(area, RECNO))
                fprintf(stderr, "** ERROR: LOADIDX DPUTREC ERROR: %d\n", retcode);
            else
                ++records;
        }
    }
    fclose(fd);
    unlink("INDEXES.$$$");  
    unlink("LOADIDX.$$$");
    dclose(area);
    fprintf(stderr, "** INDEX RECORDS PROCESSED: %d\n", records);
}

dodbf()
{
    int             dbfs = 0;
    char           *p;
	struct find_t   files;

	if (_dos_findfirst("*.dbf", _A_NORMAL, &files) != 0) {
		perror("find_first");
		exit(0);
	}
	while (_dos_findnext(&files) == 0) {
		if (p = (char *) strchr(files.name, '.')) {
			if (!strcmp(p, ".DBF")) {
                dbproc(files.name);
                ++dbfs;
            }
		}
	}
    fprintf(stderr, "** DATABASE FILES PROCESSED: %d\n", dbfs);
}

loaddb()
{
    DBAREA  *area;
    FILE    *fd;
    char    *tmpfile = "loaddbf.$$$", buffer[81];
    char    file[20], field[20], type[1], width[3], decimals[17];
    int      retcode, records = 0;
    
    fd = fopen(tmpfile, "w");
    if (fd == NULL) {
        fprintf(stderr, "** ERROR: could not open \"LOADDBF.$$$\"\n");
        exit(9);
    }
    fprintf(fd, "FILENAME   C   10  0\n");
    fprintf(fd, "FIELDNAME  C   10  0\n");
    fprintf(fd, "FIELDTYPE  C    1  0\n");
    fprintf(fd, "FIELDWIDTH N    3  0\n");
    fprintf(fd, "DECIMALS   N   12  3\n");
    fclose(fd);
    retcode = dcreat("DATABASE.DBF", tmpfile);
    if (retcode == 0)
        fprintf(stderr, "** FILE \"DATABASE.DBF\" CREATED\n");
    unlink(tmpfile);
    chmod ("DATABASE.DBF", S_IREAD|S_IWRITE);
    
    fd = fopen("DATABASE.$$$", "r");
    if (fd == NULL) {
        fprintf(stderr, "** ERROR: could not open \"DATABASE.$$$\"\n");
        exit(9);
    }
    
    /* open database file */
    area = dopen("DATABASE.DBF", O_RDWR | O_BINARY);

    /* open failed completely */
    if (area == NULL) {
        fprintf(stderr, "** ERROR: could not open \"DATABASE.DBF\"\n");
        exit(1);
    }
    
    while (fgets(buffer, 80, fd)) {
        sscanf(buffer, "%[^,],%[^,],%[^,],%[^,],%[^,\n]",
            file, field, type, width, decimals);
        
        retcode = dappend(area);
        if (retcode) {
            fprintf(stderr, "** ERROR: DAPPEND ERROR: retcode=%d\n", retcode);
            exit(8);
        } else {
            if (retcode = dputfld(area, "filename", file))
                fprintf(stderr, "** ERROR: DPUTFLD ERROR: %s %d\n", file, retcode);
            else if (retcode = dputfld(area, "fieldname", field))
                fprintf(stderr, "** ERROR: DPUTFLD ERROR: %s %d\n", field, retcode);
            else if (retcode = dputfld(area, "fieldtype", type))
                fprintf(stderr, "** ERROR: DPUTFLD ERROR: %c %d\n", type, retcode);
            else if (retcode = dputfld(area, "fieldwidth", width))
                fprintf(stderr, "** ERROR: DPUTFLD ERROR: %s %d\n", width, retcode);
            else if (retcode = dputfld(area, "decimals", decimals))
                fprintf(stderr, "** ERROR: DPUTFLD ERROR: %s %d\n", decimals, retcode);
            else if (retcode = dputrec(area, RECNO))
                fprintf(stderr, "** ERROR: DPUTREC ERROR: %d\n", retcode);
            else
                ++records;
        }
    }
    fclose(fd);
    dclose(area);
    unlink("DATABASE.$$$");
    fprintf(stderr, "** DATABASE RECORDS PROCESSED: %d\n", records);
}



dbproc(infile)
	char           *infile;
{
	DBAREA         *area;
    DBFLIST        *t;
    FILE           *fd;
    char           *p, *tmpfile = "database.$$$";
    int             retcode;

	/* open database file */
	area = dopen(infile, O_RDWR | O_BINARY);

	/* open failed completely */
	if (area == NULL) {
        fprintf(stderr, "** ERROR: DBPROC DOPEN FAILED: %s\n", infile);
		exit(1);
	}
    
    fd = fopen(tmpfile, "a+");
    if (fd == NULL) {
        fprintf(stderr, "** ERROR: could not open \"database.$$$\"\n");
        exit(9);
    }
    
    /* check for other error condition */
	if (ERROR) {
        fprintf(stderr, "** ERROR: DBPROC DOPEN ERROR: %d\n", ERROR);
		exit(1);
	}
    t = area->dbfroot;
    p = (char *)strchr(infile, '.');
    if (p)
        *p = '\0';
    /*
    fprintf (fd, "# DATABASE DICTIONARY - FILE:%s\n", infile);
    fprintf (fd, "# Field Name\tType\tLength\tDecimal Pos\n");
    fprintf (fd, "# ==========\t====\t======\t===========\n");
    */
    while (t) {
        fprintf (fd, "%-s,%-s,%c,%1d,%1d\n",
            infile, t->field->name, t->field->type,
            t->field->length, t->field->dec_point);
        t = t->next;
    }
    /*
    fprintf(fd, "#\n");
    */
    fclose(fd);
    dclose(area);
    return(0);
}

FOXANCHOR      *
foxiopen(indexfile, mode)
	char           *indexfile;
	int             mode;
{
	int             bytes, ifile;
	FOXANCHOR      *anchor;

	ifile = open(indexfile, mode);
	if (ifile == -1)
		return (NULL);

	anchor = (FOXANCHOR *) malloc(sizeof(FOXANCHOR));

	bytes = read(ifile, anchor, (unsigned int) sizeof(FOXANCHOR));
	if (bytes != sizeof(FOXANCHOR))
		return (NULL);

	return (anchor);
}

DBANCHOR       *
dbiopen(indexfile, mode)
	char           *indexfile;
	int             mode;
{
	int             bytes, ifile;
	DBANCHOR       *anchor;

	ifile = open(indexfile, mode);
	if (ifile == -1)
		return (NULL);

	anchor = (DBANCHOR *) malloc(sizeof(DBANCHOR));

	bytes = read(ifile, anchor, (unsigned int) sizeof(DBANCHOR));
	if (bytes != sizeof(DBANCHOR))
		return (NULL);

	return (anchor);
}
