
* 
*   Program Name ............:  DBWHI4
*   Written By ..............:  Mark Mainwaring
*   Copyright Owned By ......:  Rocky Mountain Software Inc.
*   Location ................:  Vancouver  BC  CANADA
*   Telephone ...............:  (604) 736-1731
*   Fax Number ..............:  (604) 736-0404
*   CompuServe ID ...........:  71321,2043
*   Date of Creation ........:  April 28, 1991
* 
*
*   This demonstrates a simple method of filtering data displayed on a DBEDIT
*   screen.  I use it for DBEDITs nested 3 or 4 deep off a parent database.
*   Please note:  This sample is the minimum article.  Functions
*   for handling editing of index key fields, etc. are not included here.
*
* 


	USE CLIENTS
	INDEX ON  UPPER( province ) + UPPER( l_name )  TO CLI_PROV
	
	DO WHILE .Y.
		CLEAR
		C_province = SPACE( 2 )
		@ 02, 05  SAY "SIMPLE! DBEDIT FILTER FUNCTION"
		@ 05, 05  SAY "Enter province (BC, AB, MB or HI): " ;
		GET C_province PICTURE "@! AA"
		READ
	
		IF EMPTY( C_province ) .OR. LASTKEY() = 27
			EXIT
		ENDIF
		
		SEEK C_province
		IF FOUND()
			DO Browse
		ELSE
			@ 07, 05  SAY "Province not found.  Press any key: "
			INKEY( 0 )
		ENDIF
		
	ENDDO
	
	CLEAR ALL
	CLEAR
	QUIT
	
* 
		
PROCEDURE Browse

	PRIVATE  C_header, C_column, C_footer
	PRIVATE  N_top, N_bottom, N_left, N_right

	K_PgUp	= 18
	K_PgDn	= 3
	K_CPgUp	= 31
	K_CPgDn	= 30

	K_Left	= 19
	K_Right	= 4
	K_CRight= 2
	K_CLeft	= 26

	K_Up	= 5
	K_Down	= 24

	PRIVATE DISPFLD_[ 4 ], EDITFLD_[ 4 ], PICTURES_[ 4 ], TITLES_[ 4 ]

	DISPFLD_[ 1 ]   = 'IF( province == C_province, f_name,   SPACE( 15 ))'
	DISPFLD_[ 2 ]   = 'IF( province == C_province, l_name,   SPACE( 25 ))'
	DISPFLD_[ 3 ]   = 'IF( province == C_province, city,     SPACE( 20 ))'
	DISPFLD_[ 4 ]   = 'IF( province == C_province, province, SPACE(  2 ))'

	EDITFLD_[ 1 ]   = 'F_NAME'
	EDITFLD_[ 2 ]   = 'L_NAME'
	EDITFLD_[ 3 ]   = 'CITY'
	EDITFLD_[ 4 ]   = 'PROVINCE'

	PICTURES_[ 1 ] = ""
	PICTURES_[ 2 ] = ""
	PICTURES_[ 3 ] = "@!"
	PICTURES_[ 4 ] = "!!"

	TITLES_[ 1 ]  = "First Name"
	TITLES_[ 2 ]  = "Last Name"
	TITLES_[ 3 ]  = "City"
	TITLES_[ 4 ]  = "Province"

	C_header = CHR( 205 ) + CHR( 209 ) + CHR( 205 )		&&    
	C_column = " "        + CHR( 179 ) + " "			&&     
	C_footer = CHR( 205 ) + CHR( 207 ) + CHR( 205 )		&&    

	N_top    = 04
	N_left   = 00
	N_bottom = 17
	N_right  = 79

	DO Status

	* This defines the upper and lower limits of the filtered data.
	N_toprec = RECNO()
	N_botrec = SeekBottom( C_province )

	* Double Top, Double Side
	box_dtds = CHR(201)+CHR(205)+CHR(187)+CHR(186)+CHR(188)+CHR(205)+CHR(200)+CHR(186)+" "

	@ N_top, N_left, N_bottom, N_right BOX box_dtds
	
	@ N_top+2,    N_left   SAY CHR( 204 )		&&  
	@ N_top+2,    N_right  SAY CHR( 185 )		&&  
	@ N_bottom-2, N_left   SAY CHR( 204 )		&&  
	@ N_bottom-2, N_right  SAY CHR( 185 )		&&  


	DBEDIT( N_top+1, N_left+1, N_bottom-1, N_right-1, DISPFLD_, "BrowFunc", ;
	PICTURES_, TITLES_, C_header, C_column, C_footer, " " )

	SET CURSOR ON

* 

FUNCTION  BrowFunc

	PRIVATE    L_cursor, N_mode, N_field, C_field, C_value
	PARAMETERS N_mode, N_field

	PRIVATE N_result

	C_field   = EDITFLD_[ N_field ]
	C_picture = PICTURES_[ N_field ]

	DO CASE
		CASE N_mode = 0					&&  DBEDIT idle state.
			@ N_bottom-1, 04  SAY "Valid Keys:  Up  Down  ^PgUp  ^PgDn  Enter  ESC"
			CLEAR TYPEAHEAD
			DO Status

			IF province == C_province
				RETURN( 1 )
			ELSE
				DO CASE
					CASE LASTKEY() = K_CPgUp
						GOTO N_toprec
						TONE( 329, 1 )
					CASE LASTKEY() = K_CPgDn
						GOTO N_botrec
						TONE( 329, 1 )
					CASE LASTKEY() = K_PgUp
						GOTO N_toprec
						TONE( 329, 1 )
					CASE LASTKEY() = K_PgDn
						GOTO N_botrec
						TONE( 329, 1 )
					CASE LASTKEY() = K_Up
						GOTO N_toprec
						TONE( 329, 1 )
					CASE LASTKEY() = K_Down
						GOTO N_botrec
						TONE( 329, 1 )
				ENDCASE
				RETURN( 2 )
			ENDIF

		CASE N_mode = 1					&&  User tried to move past the BOF.
			TONE( 100, 1 )
			RETURN( 1 )
			
		CASE N_mode = 2					&&  User tried to move past the EOF.
			TONE( 100, 1 )
			RETURN( 1 )

		CASE N_mode = 3					&&  The database is empty.
			* Put your message handler here.
			RETURN( 0 )

		CASE N_mode = 4					&&  Keystroke exception.
			DO CASE
				CASE LASTKEY() = 27
					RETURN( 0 )

				CASE LASTKEY() = 13
					SET CURSOR ON
					* Macro used in this sample ONLY!  Macrot**ds...
					@ ROW(), COL()  GET &C_field PICTURE C_picture
					READ
					SET CURSOR OFF
					RETURN( 2 )			&&  Force re-read and re-paint.

				OTHERWISE
					RETURN( 1 )			&&  Return to DBEDIT.

			ENDCASE
	ENDCASE

* 

FUNCTION  SeekBottom

	PRIVATE    C_string
	PARAMETERS C_string

	* The C_string variable should be TRIMmed before this function uses it.

	PRIVATE C_end, C_next, C_new, N_record, N_lastrec

	* DO PushDbf	
	N_lastrec = RECNO()
	
	SEEK C_string
	IF FOUND()
		N_record = RECNO()
		C_end    = SUBSTR( C_string, LEN( C_string ), 1 )
		C_next   = CHR( ASC( C_end ) + 1 ) 
		C_new    = SUBSTR( C_string, 1, LEN( C_string ) - 1 ) + C_next

		SET SOFTSEEK ON
		SEEK C_new
		SET SOFTSEEK OFF
		IF RECNO() <> N_record
			SKIP -1
			N_record = RECNO()
		ENDIF
	ELSE
		N_record = RECCOUNT() + 1
	ENDIF

	* DO PopDbf
	GOTO N_lastrec
	
	RETURN( N_record )		

* 

PROCEDURE Status

	PRIVATE C_oldcolor

	C_oldcolor = SETCOLOR( "W/N" )

	@ 23, 00  SAY SPACE( 80 )
	@ 23, 02  SAY "Database:"
	@ 23, 27  SAY "Record 000000 of 000000"
	@ 23, 59  SAY "Last Edit: 00/00/00"
	@ 23, 12  SAY ALIAS()
	@ 23, 34  SAY STRZERO( RECNO(), 6 )
	@ 23, 44  SAY STRZERO( LASTREC(), 6 )
	@ 23, 70  SAY LUPDATE()

	SETCOLOR( C_oldcolor )
	
* 
* End of File.
