/***
*  GaugeInd.prg
*  Sample program to demonstrate the use of a bar progress gauge
*  with an indexing system.
*
*  Copyright (c) 1992, Computer Associates Corp.  All rights reserved.
*  Daniel Neil
*
*/

#include "gaugeind.ch"
***
*** Displays gauage and builds index
****************************************************************************
PROCEDURE GaugeIndex( cFile, cKey, bKey, lUnique, ;
                      nTop, nLeft, nBase, nRight, cColors, nStep )
  LOCAL aGauge, cScreen, aColors
  LOCAL lSimple   := (FIELDBLOCK(cKey)!=NIL)

  DEFAULT nTop    TO 5
  DEFAULT nLeft   TO 5
  DEFAULT nBase   TO 7
  DEFAULT nRight  TO MAXCOL()-7
  DEFAULT cColors TO "W/B,W+/B"
  DEFAULT nStep   To MAX(10,ROUND(RECCOUNT()/100,0))

  aColors := ListAsArray(cColors)
  cScreen := SAVESCREEN( nTop, nLeft, nBase, nRight )
  aGauge  := GaugeNew( nTop, nLeft, nBase, nRight, aColors[1], aColors[2] )

  GaugeDisplay( aGauge )

  dbCreateIndex( cFile, IF(lSimple,"("+cKey+")",cKey),        ;
                 {|| Update( aGauge, bKey, nStep ) }, lUnique )

  RESTSCREEN(nTop, nLeft, nBase, nRight, cScreen )

RETURN

***
*** Update index gauge
****************************************************************************
STATIC FUNCTION Update( aGauge, bKey, nStep )

  IF !EOF() .AND. (RECNO()%nStep == 0 .OR. RECNO() == LASTREC())
    GaugeUpdate( aGauge, RECNO()/LASTREC() )
  ENDIF

RETURN EVAL(bKey)
