************
*
*	Program....:  DBU
*	Filename...:  DBUCOPY.PRG
*	Author.....:  Dennis L. Dias
*	Date.......:  06/18/86, 06/18/90
*	Purpose....:  Copy and Append Module
*
*	Copyright (c) 1986-1990 Nantucket Corp., All Rights Reserved.
*
************
#ifdef FlagShip
    #include "sprache.fh"
#else
    #include "sprache.ch"
#endif


******
*	capprep
*
*	copy/append/replace/delete
*
*	note: see multibox in DBUUTIL.PRG
******
PROCEDURE capprep

  PRIVATE filename, files, fi_disp, okee_dokee, cur_el, rel_row, def_ext, mode,;
  fi_done, for_cond, while_cond, how_many, bcur, for_row, height,;
  field_mvar, with_what, s_order

  IF FileLock()
    IF M->func_sel = 3
      * replace or Sum command
      help_code = 22

      * select current work area
      SELECT (M->cur_area)

      * initialize variables to contain fieldname and replace expression
      field_mvar = ""
      with_what = ""

      * get master field list into local array for selection
      DECLARE field_m[FCOUNT()]
      all_fields(M->cur_area, M->field_m)

      * set up for multi-box
      DECLARE boxarray[9]
      boxarray[1] = "repl_title(sysparam)"
      boxarray[2] = "repl_field(sysparam)"
      boxarray[3] = "with_exp(sysparam)"
      boxarray[4] = "for_exp(sysparam)"
      boxarray[5] = "while_exp(sysparam)"
      boxarray[6] = "scope_num(sysparam)"
      boxarray[7] = "ok_button(sysparam)"
      boxarray[8] = "can_button(sysparam)"
      boxarray[9] = "fieldlist(sysparam)"

      * size and configuration
      bcur = 9			&& beginning cursor on field list
      for_row = 6
      height = 10
      okee_dokee = "do_replace()"
      fi_disp = "repl_field(3)"

    ELSEIF M->func_sel = 8
      * Sum command
      help_code = 22

      * select current work area
      SELECT (M->cur_area)

      * initialize variables to contain fieldname and replace expression
      field_mvar = ""
      to_what = ""

      * get master field list into local array for selection
      DECLARE field_m[FCOUNT()]
      all_fields(M->cur_area, M->field_m)

      * set up for multi-box
      DECLARE boxarray[9]
      boxarray[1] = "sum_title(sysparam)"
      boxarray[2] = "sum_field(sysparam)"
      boxarray[3] = "what_dbf(sysparam)"
      boxarray[4] = "for_exp(sysparam)"
      boxarray[5] = "while_exp(sysparam)"
      boxarray[6] = "scope_num(sysparam)"
      boxarray[7] = "ok_button(sysparam)"
      boxarray[8] = "can_button(sysparam)"
      boxarray[9] = "fieldlist(sysparam)"

      * size and configuration
      bcur = 9			&& beginning cursor on field list
      for_row = 6
      height = 10
      okee_dokee = "do_sum()"
      fi_disp = "sor_field(3)"

    ELSEIF M->func_sel = 11
      * Sort command
      help_code = 22

      * select current work area
      SELECT (M->cur_area)

      * initialize variables to contain fieldname and replace expression
      field_mvar = ""
      to_what = ""
      s_order = ""

      * get master field list into local array for selection
      DECLARE field_m[FCOUNT()]
      all_fields(M->cur_area, M->field_m)

      * set up for multi-box
      DECLARE boxarray[10]
      boxarray[1] = "sor_title(sysparam)"
      boxarray[2] = "sor_field(sysparam)"
      boxarray[3] = "what_dbf(sysparam)"
      boxarray[4] = "sort_ord(sysparam)"
      boxarray[5] = "for_exp(sysparam)"
      boxarray[6] = "while_exp(sysparam)"
      boxarray[7] = "scope_num(sysparam)"
      boxarray[8] = "ok_button(sysparam)"
      boxarray[9] = "can_button(sysparam)"
      boxarray[10] = "fieldlist(sysparam)"

      * size and configuration
      bcur = 10          && beginning cursor on field list
      for_row = 6
      height = 10
      okee_dokee = "do_sort()"
      fi_disp = "sor_field(3)"

    ELSEIF M->func_sel = 9
      * Report command
      help_code = 22

      * select current work area
      SELECT (M->cur_area)

      * initialize variables to contain fieldname and replace expression
      m_plain = "NO"
      m_eject = "NO"
      m_sum   = "NO"
      m_out   = ""
      for_cond  = ""
      while_cond = ""
      m_head  = ""
      filename = ""
      how_many = 0

      * set up for multi-box
      DECLARE boxarray[13]
      boxarray[1] = "frm_title(sysparam)"
      boxarray[2] = "frm_form(sysparam)"
      boxarray[3] = "frm_head(sysparam)"
      boxarray[4] = "frm_sum(sysparam)"
      boxarray[5] = "frm_plai(sysparam)"
      boxarray[6] = "frm_ejec(sysparam)"
      boxarray[7] = "for_exp(sysparam)"
      boxarray[8] = "while_exp(sysparam)"
      boxarray[9] = "scope_num(sysparam)"
      boxarray[10] = "frm_out(sysparam)"
      boxarray[11] = "ok_button(sysparam)"
      boxarray[12] = "can_button(sysparam)"
      boxarray[13] = "filelist(sysparam)"

      * size and configuration
      bcur = 13          && beginning cursor on field list
      for_row = 8
      height = 13

      okee_dokee = "make_rep()"
      * DBF for normal mode
      files = "frm_list"
      def_ext = ".FRM"

      fi_disp = "frm_form(3)"

      * when is a filename acceptable?
      fi_done = "not_empty('filename')"

    ELSEIF M->func_sel = 10
      * Label command
      help_code = 22

      * select current work area
      SELECT (M->cur_area)

      * initialize variables to contain fieldname and replace expression
      m_console = "NO"
      m_sample = "NO"
      m_out   = ""
      for_cond  = ""
      while_cond = ""
      filename = ""
      how_many = 0

      * set up for multi-box
      DECLARE boxarray[11]
      boxarray[1] = "lbl_title(sysparam)"
      boxarray[2] = "lbl_form(sysparam)"
      boxarray[3] = "lbl_cons(sysparam)"
      boxarray[4] = "lbl_samp(sysparam)"
      boxarray[5] = "for_exp(sysparam)"
      boxarray[6] = "while_exp(sysparam)"
      boxarray[7] = "scope_num(sysparam)"
      boxarray[8] = "lbl_out(sysparam)"
      boxarray[9] = "ok_button(sysparam)"
      boxarray[10] = "can_button(sysparam)"
      boxarray[11] = "filelist(sysparam)"

      * size and configuration
      bcur = 11          && beginning cursor on field list
      for_row = 6
      height = 11

      okee_dokee = "make_lbl()"
      * DBF for normal mode
      files = "lbl_list"
      def_ext = ".LBL"

      fi_disp = "lbl_form(3)"

      * when is a filename acceptable?
      fi_done = "not_empty('filename')"


    ELSEIF M->func_sel = 4 .OR. M->func_sel = 5
      * replace command
      help_code = 22

      * select current work area
      SELECT (M->cur_area)

      * get master field list into local array for selection
      DECLARE field_m[FCOUNT()]
      all_fields(M->cur_area, M->field_m)

      * set up for multi-box
      DECLARE boxarray[7]
      boxarray[2] = "for_exp(sysparam)"
      boxarray[3] = "while_exp(sysparam)"
      boxarray[4] = "scope_num(sysparam)"
      boxarray[5] = "ok_button(sysparam)"
      boxarray[6] = "can_button(sysparam)"
      boxarray[7] = "fieldlist(sysparam)"

      * size and configuration
      bcur = 2			&& beginning cursor on field list
      for_row = 3
      height = 7
      IF M->func_sel = 4
        boxarray[1] = "del_title(sysparam)"
        okee_dokee = "do_delete()"
      ELSE
        boxarray[1] = "recall_title(sysparam)"
        okee_dokee = "do_recall()"
      ENDIF
      fi_disp = "delrec_field(2)"

    ELSE
      * initialize filename variable
      filename = ""

      * only copy and append use a list of text files
      DECLARE txt_list[adir("*.TXT") + 20]		&& directory of text files
      array_dir("*.TXT",txt_list)					&& fill array with filenames

      * set up for multi-box
      DECLARE boxarray[10]

      IF M->func_sel = 1
        * copy command
        help_code = 12
        bcur = 2			&& beginning cursor on filename entry field
        boxarray[1] = "copy_title(sysparam)"
        boxarray[2] = "trg_getfil(sysparam)"
        fi_disp = "trg_getfil(3)"
        okee_dokee = "do_copy()"

      ELSE
        * append command
        help_code = 15
        bcur = 10			&& beginning cursor on selection list
        boxarray[1] = "appe_title(sysparam)"
        boxarray[2] = "src_getfil(sysparam)"
        fi_disp = "src_getfil(3)"
        okee_dokee = "do_append()"

      ENDIF

      * remainder of setup common to copy and append
      boxarray[3] = "for_exp(sysparam)"
      boxarray[4] = "while_exp(sysparam)"
      boxarray[5] = "scope_num(sysparam)"
      boxarray[6] = "tog_sdf(sysparam)"
      boxarray[7] = "ok_button(sysparam)"
      boxarray[8] = "tog_delim(sysparam)"
      boxarray[9] = "can_button(sysparam)"
      boxarray[10] = "filelist(sysparam)"

      * size and configuration
      for_row = 5
      height = 11

      * DBF for normal mode
      files = "dbf_list"
      def_ext = ".DBF"

      * when is a filename acceptable?
      fi_done = "not_empty('filename')"

    ENDIF

    * initialize local variables
    STORE "" TO for_cond, while_cond

    * normal mode, scope = ALL, top of selection list
    STORE 1 TO mode,cur_el
    rel_row = 0
    how_many = 0

    * do it with the all-purpose switchbox
    multibox(8, 17, M->height, M->bcur, M->boxarray)
    Unlock
  else
  	error_msg("Operation Failed. Unable to Lock File")
  endif
RETURN


******************************
* functions specific to COPY *
******************************

******
*	copy_title()
*
*	display title for "copy"
******
FUNCTION copy_title
PARAMETERS sysparam

RETURN box_title(M->sysparam, IF (DEUTSCH,"Kopiere ","Copy ") +;
							  SUBSTR(M->cur_dbf, RAT("\", M->cur_dbf) + 1) +;
                              IF (DEUTSCH," zu..."," to..."))

******
*   frm_title()
*
*   display title for "report"
******
FUNCTION frm_title
PARAMETERS sysparam

RETURN box_title(M->sysparam, "Report "+ IF(DEUTSCH,"von ","from "))

******
*   frm_head()
*
*   get heading for "report"
******
FUNCTION frm_head
PARAMETERS sysparam

RETURN get_exp(M->sysparam, "HEAD   ", 4, "m_head")


******
*   lbl_title()
*
*   display title for "label"
******
FUNCTION lbl_title
PARAMETERS sysparam
RETURN box_title(M->sysparam, "Label "+ IF(DEUTSCH,"von ","from "))


FUNCTION lbl_cons
PARAMETERS sysparam
RETURN get_exp(M->sysparam, "CONSOL ", 4, "m_console")



FUNCTION lbl_samp
PARAMETERS sysparam
RETURN get_exp(M->sysparam, "SAMPLE ", 5, "m_sample")


FUNCTION frm_sum
PARAMETERS sysparam
RETURN get_exp(M->sysparam, "SUM    ", 5, "m_sum")


FUNCTION frm_plai
PARAMETERS sysparam
RETURN get_exp(M->sysparam, "PLAIN  ", 6, "m_plain")


FUNCTION frm_ejec
PARAMETERS sysparam
RETURN get_exp(M->sysparam, "EJECT  ", 7, "m_eject")



FUNCTION frm_out
PARAMETERS sysparam
RETURN get_exp(M->sysparam, "OUTPUT ", 11, "m_out")


FUNCTION lbl_out
PARAMETERS sysparam
RETURN get_exp(M->sysparam, "OUTPUT ", 9, "m_out")


******
*	trg_getfil()
*
*	get target filename for "copy"
******
FUNCTION trg_getfil
PARAMETERS sysparam

help_code = M->prime_help
RETURN getfile(M->sysparam, 3)


******
*	do_copy()
*
*	do the copy command
*
*	note: this function is called when <enter> is pressed
*		  while the cursor is on the "Ok" button
******
FUNCTION do_copy

PRIVATE done, add_name, new_el

* assume incomplete
done = .F.

DO CASE

    CASE EMPTY(M->filename)
        error_msg(IF (DEUTSCH,"Keine Zieldatei angegeben",;
                              "Target not selected"))

	CASE M->filename == M->cur_dbf
        error_msg(IF (DEUTSCH,"Datei kann nicht in sich selbst kopiert werden",;
                              "File cannot be coppied onto itself"))

	CASE .NOT. EMPTY(M->for_cond) .AND. TYPE(M->for_cond) <> "L"
        do d_lex_err

	CASE .NOT. EMPTY(M->while_cond) .AND. TYPE(M->while_cond) <> "L"
        do d_wex_err

	OTHERWISE
		* ok to copy file

		IF FILE(M->filename)
           IF DEUTSCH
              IF rsvp("Zieldatei " + IF(aseek(M->dbf, M->filename) > 0,;
               "ist geffnet", "existiert") + "...berschreiben? (J/N)") <> "J"
                 RETURN .F.

              ENDIF
           ELSE
               IF rsvp("Target File " + IF(aseek(M->dbf, M->filename) > 0,;
                       "Is Open", "Exists") + "...Overwrite? (Y/N)") <> "Y"
                   RETURN .F.

               ENDIF
           ENDIF
		ENDIF

        stat_msg(IF (DEUTSCH,"Kopiere","Copying"))

		IF aseek(M->dbf, M->filename) > 0
			* copying to an open file...good luck!
			SELECT (aseek(M->dbf, M->filename))
			USE
			STORE .T. TO need_field,need_ntx,need_relat,need_filtr

		ENDIF

		SELECT (M->cur_area)

		IF RAT(M->def_ext, M->filename) = LEN(M->filename) - 3
			* target has default extension..does it exists in current dir?
			add_name = .NOT. FILE(name(M->filename) + M->def_ext)

		ELSE
			add_name = .F.

		ENDIF

		IF EMPTY(M->for_cond)
			* literal true is the same as no FOR condition
			for_cond = ".T."

		ENDIF

		IF EMPTY(M->while_cond)
			* literal true is correct only from top of file
			while_cond = ".T."

			IF M->how_many = 0
				* unless a scope has been entered
				GO TOP

			ENDIF
		ENDIF

                * initialize public variables for the Fields command
                * i don't know a better way to make the fields command work
                * OV
                do gcopfi

		DO CASE
                   CASE M->mode = 1 .AND. M->how_many = 0
#ifndef FlagShip
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127", ;
                                                  "&mcof_128", ;
                                                  "&mcof_129", ;
                                                  "&mcof_130", ;
                                                  "&mcof_131", ;
                                                  "&mcof_132", ;
                                                  "&mcof_133", ;
                                                  "&mcof_134", ;
                                                  "&mcof_135", ;
                                                  "&mcof_136", ;
                                                  "&mcof_137", ;
                                                  "&mcof_138", ;
                                                  "&mcof_139", ;
                                                  "&mcof_140", ;
                                                  "&mcof_141", ;
                                                  "&mcof_142", ;
                                                  "&mcof_143", ;
                                                  "&mcof_144", ;
                                                  "&mcof_145", ;
                                                  "&mcof_146", ;
                                                  "&mcof_147", ;
                                                  "&mcof_148", ;
                                                  "&mcof_149", ;
                                                  "&mcof_150", ;
                                                  "&mcof_151", ;
                                                  "&mcof_152", ;
                                                  "&mcof_153", ;
                                                  "&mcof_154", ;
                                                  "&mcof_155", ;
                                                  "&mcof_156", ;
                                                  "&mcof_157", ;
                                                  "&mcof_158", ;
                                                  "&mcof_159", ;
                                                  "&mcof_160", ;
                                                  "&mcof_161", ;
                                                  "&mcof_162", ;
                                                  "&mcof_163", ;
                                                  "&mcof_164", ;
                                                  "&mcof_165", ;
                                                  "&mcof_166", ;
                                                  "&mcof_167", ;
                                                  "&mcof_168", ;
                                                  "&mcof_169", ;
                                                  "&mcof_170", ;
                                                  "&mcof_171", ;
                                                  "&mcof_172", ;
                                                  "&mcof_173", ;
                                                  "&mcof_174", ;
                                                  "&mcof_175", ;
                                                  "&mcof_176", ;
                                                  "&mcof_177", ;
                                                  "&mcof_178", ;
                                                  "&mcof_179", ;
                                                  "&mcof_180", ;
                                                  "&mcof_181", ;
                                                  "&mcof_182", ;
                                                  "&mcof_183", ;
                                                  "&mcof_184", ;
                                                  "&mcof_185", ;
                                                  "&mcof_186", ;
                                                  "&mcof_187", ;
                                                  "&mcof_188", ;
                                                  "&mcof_189", ;
                                                  "&mcof_190", ;
                                                  "&mcof_191", ;
                                                  "&mcof_192" ;
                        WHILE &while_cond FOR &for_cond
#else
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127" ;
                        WHILE &while_cond FOR &for_cond
#endif
                        RELEASE ALL LIKE mcof_*

                   CASE M->mode = 1 .AND. M->how_many > 0
#ifndef FlagShip
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127", ;
                                                  "&mcof_128", ;
                                                  "&mcof_129", ;
                                                  "&mcof_130", ;
                                                  "&mcof_131", ;
                                                  "&mcof_132", ;
                                                  "&mcof_133", ;
                                                  "&mcof_134", ;
                                                  "&mcof_135", ;
                                                  "&mcof_136", ;
                                                  "&mcof_137", ;
                                                  "&mcof_138", ;
                                                  "&mcof_139", ;
                                                  "&mcof_140", ;
                                                  "&mcof_141", ;
                                                  "&mcof_142", ;
                                                  "&mcof_143", ;
                                                  "&mcof_144", ;
                                                  "&mcof_145", ;
                                                  "&mcof_146", ;
                                                  "&mcof_147", ;
                                                  "&mcof_148", ;
                                                  "&mcof_149", ;
                                                  "&mcof_150", ;
                                                  "&mcof_151", ;
                                                  "&mcof_152", ;
                                                  "&mcof_153", ;
                                                  "&mcof_154", ;
                                                  "&mcof_155", ;
                                                  "&mcof_156", ;
                                                  "&mcof_157", ;
                                                  "&mcof_158", ;
                                                  "&mcof_159", ;
                                                  "&mcof_160", ;
                                                  "&mcof_161", ;
                                                  "&mcof_162", ;
                                                  "&mcof_163", ;
                                                  "&mcof_164", ;
                                                  "&mcof_165", ;
                                                  "&mcof_166", ;
                                                  "&mcof_167", ;
                                                  "&mcof_168", ;
                                                  "&mcof_169", ;
                                                  "&mcof_170", ;
                                                  "&mcof_171", ;
                                                  "&mcof_172", ;
                                                  "&mcof_173", ;
                                                  "&mcof_174", ;
                                                  "&mcof_175", ;
                                                  "&mcof_176", ;
                                                  "&mcof_177", ;
                                                  "&mcof_178", ;
                                                  "&mcof_179", ;
                                                  "&mcof_180", ;
                                                  "&mcof_181", ;
                                                  "&mcof_182", ;
                                                  "&mcof_183", ;
                                                  "&mcof_184", ;
                                                  "&mcof_185", ;
                                                  "&mcof_186", ;
                                                  "&mcof_187", ;
                                                  "&mcof_188", ;
                                                  "&mcof_189", ;
                                                  "&mcof_190", ;
                                                  "&mcof_191", ;
                                                  "&mcof_192" ;
                        NEXT M->how_many;
                        WHILE &while_cond FOR &for_cond
#else
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127" ;
                        NEXT M->how_many;
                        WHILE &while_cond FOR &for_cond
#endif
                        RELEASE ALL LIKE mcof_*

                   CASE M->mode = 2 .AND. M->how_many = 0
#ifndef FlagShip
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127", ;
                                                  "&mcof_128", ;
                                                  "&mcof_129", ;
                                                  "&mcof_130", ;
                                                  "&mcof_131", ;
                                                  "&mcof_132", ;
                                                  "&mcof_133", ;
                                                  "&mcof_134", ;
                                                  "&mcof_135", ;
                                                  "&mcof_136", ;
                                                  "&mcof_137", ;
                                                  "&mcof_138", ;
                                                  "&mcof_139", ;
                                                  "&mcof_140", ;
                                                  "&mcof_141", ;
                                                  "&mcof_142", ;
                                                  "&mcof_143", ;
                                                  "&mcof_144", ;
                                                  "&mcof_145", ;
                                                  "&mcof_146", ;
                                                  "&mcof_147", ;
                                                  "&mcof_148", ;
                                                  "&mcof_149", ;
                                                  "&mcof_150", ;
                                                  "&mcof_151", ;
                                                  "&mcof_152", ;
                                                  "&mcof_153", ;
                                                  "&mcof_154", ;
                                                  "&mcof_155", ;
                                                  "&mcof_156", ;
                                                  "&mcof_157", ;
                                                  "&mcof_158", ;
                                                  "&mcof_159", ;
                                                  "&mcof_160", ;
                                                  "&mcof_161", ;
                                                  "&mcof_162", ;
                                                  "&mcof_163", ;
                                                  "&mcof_164", ;
                                                  "&mcof_165", ;
                                                  "&mcof_166", ;
                                                  "&mcof_167", ;
                                                  "&mcof_168", ;
                                                  "&mcof_169", ;
                                                  "&mcof_170", ;
                                                  "&mcof_171", ;
                                                  "&mcof_172", ;
                                                  "&mcof_173", ;
                                                  "&mcof_174", ;
                                                  "&mcof_175", ;
                                                  "&mcof_176", ;
                                                  "&mcof_177", ;
                                                  "&mcof_178", ;
                                                  "&mcof_179", ;
                                                  "&mcof_180", ;
                                                  "&mcof_181", ;
                                                  "&mcof_182", ;
                                                  "&mcof_183", ;
                                                  "&mcof_184", ;
                                                  "&mcof_185", ;
                                                  "&mcof_186", ;
                                                  "&mcof_187", ;
                                                  "&mcof_188", ;
                                                  "&mcof_189", ;
                                                  "&mcof_190", ;
                                                  "&mcof_191", ;
                                                  "&mcof_192" ;
                        WHILE &while_cond FOR &for_cond SDF
#else
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127" ;
                        WHILE &while_cond FOR &for_cond SDF
#endif
                        RELEASE ALL LIKE mcof_*

                   CASE M->mode = 2 .AND. M->how_many > 0
#ifndef FlagShip
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127", ;
                                                  "&mcof_128", ;
                                                  "&mcof_129", ;
                                                  "&mcof_130", ;
                                                  "&mcof_131", ;
                                                  "&mcof_132", ;
                                                  "&mcof_133", ;
                                                  "&mcof_134", ;
                                                  "&mcof_135", ;
                                                  "&mcof_136", ;
                                                  "&mcof_137", ;
                                                  "&mcof_138", ;
                                                  "&mcof_139", ;
                                                  "&mcof_140", ;
                                                  "&mcof_141", ;
                                                  "&mcof_142", ;
                                                  "&mcof_143", ;
                                                  "&mcof_144", ;
                                                  "&mcof_145", ;
                                                  "&mcof_146", ;
                                                  "&mcof_147", ;
                                                  "&mcof_148", ;
                                                  "&mcof_149", ;
                                                  "&mcof_150", ;
                                                  "&mcof_151", ;
                                                  "&mcof_152", ;
                                                  "&mcof_153", ;
                                                  "&mcof_154", ;
                                                  "&mcof_155", ;
                                                  "&mcof_156", ;
                                                  "&mcof_157", ;
                                                  "&mcof_158", ;
                                                  "&mcof_159", ;
                                                  "&mcof_160", ;
                                                  "&mcof_161", ;
                                                  "&mcof_162", ;
                                                  "&mcof_163", ;
                                                  "&mcof_164", ;
                                                  "&mcof_165", ;
                                                  "&mcof_166", ;
                                                  "&mcof_167", ;
                                                  "&mcof_168", ;
                                                  "&mcof_169", ;
                                                  "&mcof_170", ;
                                                  "&mcof_171", ;
                                                  "&mcof_172", ;
                                                  "&mcof_173", ;
                                                  "&mcof_174", ;
                                                  "&mcof_175", ;
                                                  "&mcof_176", ;
                                                  "&mcof_177", ;
                                                  "&mcof_178", ;
                                                  "&mcof_179", ;
                                                  "&mcof_180", ;
                                                  "&mcof_181", ;
                                                  "&mcof_182", ;
                                                  "&mcof_183", ;
                                                  "&mcof_184", ;
                                                  "&mcof_185", ;
                                                  "&mcof_186", ;
                                                  "&mcof_187", ;
                                                  "&mcof_188", ;
                                                  "&mcof_189", ;
                                                  "&mcof_190", ;
                                                  "&mcof_191", ;
                                                  "&mcof_192" ;
                        NEXT M->how_many;
                        WHILE &while_cond FOR &for_cond SDF
#else
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127" ;
                        NEXT M->how_many;
                        WHILE &while_cond FOR &for_cond SDF
#endif
                        RELEASE ALL LIKE mcof_*

                   CASE M->mode = 3 .AND. M->how_many = 0
#ifndef FlagShip
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127", ;
                                                  "&mcof_128", ;
                                                  "&mcof_129", ;
                                                  "&mcof_130", ;
                                                  "&mcof_131", ;
                                                  "&mcof_132", ;
                                                  "&mcof_133", ;
                                                  "&mcof_134", ;
                                                  "&mcof_135", ;
                                                  "&mcof_136", ;
                                                  "&mcof_137", ;
                                                  "&mcof_138", ;
                                                  "&mcof_139", ;
                                                  "&mcof_140", ;
                                                  "&mcof_141", ;
                                                  "&mcof_142", ;
                                                  "&mcof_143", ;
                                                  "&mcof_144", ;
                                                  "&mcof_145", ;
                                                  "&mcof_146", ;
                                                  "&mcof_147", ;
                                                  "&mcof_148", ;
                                                  "&mcof_149", ;
                                                  "&mcof_150", ;
                                                  "&mcof_151", ;
                                                  "&mcof_152", ;
                                                  "&mcof_153", ;
                                                  "&mcof_154", ;
                                                  "&mcof_155", ;
                                                  "&mcof_156", ;
                                                  "&mcof_157", ;
                                                  "&mcof_158", ;
                                                  "&mcof_159", ;
                                                  "&mcof_160", ;
                                                  "&mcof_161", ;
                                                  "&mcof_162", ;
                                                  "&mcof_163", ;
                                                  "&mcof_164", ;
                                                  "&mcof_165", ;
                                                  "&mcof_166", ;
                                                  "&mcof_167", ;
                                                  "&mcof_168", ;
                                                  "&mcof_169", ;
                                                  "&mcof_170", ;
                                                  "&mcof_171", ;
                                                  "&mcof_172", ;
                                                  "&mcof_173", ;
                                                  "&mcof_174", ;
                                                  "&mcof_175", ;
                                                  "&mcof_176", ;
                                                  "&mcof_177", ;
                                                  "&mcof_178", ;
                                                  "&mcof_179", ;
                                                  "&mcof_180", ;
                                                  "&mcof_181", ;
                                                  "&mcof_182", ;
                                                  "&mcof_183", ;
                                                  "&mcof_184", ;
                                                  "&mcof_185", ;
                                                  "&mcof_186", ;
                                                  "&mcof_187", ;
                                                  "&mcof_188", ;
                                                  "&mcof_189", ;
                                                  "&mcof_190", ;
                                                  "&mcof_191", ;
                                                  "&mcof_192" ;
                        WHILE &while_cond FOR &for_cond DELIMITED
#else
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127" ;
                        WHILE &while_cond FOR &for_cond DELIMITED
#endif
                        RELEASE ALL LIKE mcof_*

                   CASE M->mode = 3 .AND. M->how_many > 0
#ifndef FlagShip
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127", ;
                                                  "&mcof_128", ;
                                                  "&mcof_129", ;
                                                  "&mcof_130", ;
                                                  "&mcof_131", ;
                                                  "&mcof_132", ;
                                                  "&mcof_133", ;
                                                  "&mcof_134", ;
                                                  "&mcof_135", ;
                                                  "&mcof_136", ;
                                                  "&mcof_137", ;
                                                  "&mcof_138", ;
                                                  "&mcof_139", ;
                                                  "&mcof_140", ;
                                                  "&mcof_141", ;
                                                  "&mcof_142", ;
                                                  "&mcof_143", ;
                                                  "&mcof_144", ;
                                                  "&mcof_145", ;
                                                  "&mcof_146", ;
                                                  "&mcof_147", ;
                                                  "&mcof_148", ;
                                                  "&mcof_149", ;
                                                  "&mcof_150", ;
                                                  "&mcof_151", ;
                                                  "&mcof_152", ;
                                                  "&mcof_153", ;
                                                  "&mcof_154", ;
                                                  "&mcof_155", ;
                                                  "&mcof_156", ;
                                                  "&mcof_157", ;
                                                  "&mcof_158", ;
                                                  "&mcof_159", ;
                                                  "&mcof_160", ;
                                                  "&mcof_161", ;
                                                  "&mcof_162", ;
                                                  "&mcof_163", ;
                                                  "&mcof_164", ;
                                                  "&mcof_165", ;
                                                  "&mcof_166", ;
                                                  "&mcof_167", ;
                                                  "&mcof_168", ;
                                                  "&mcof_169", ;
                                                  "&mcof_170", ;
                                                  "&mcof_171", ;
                                                  "&mcof_172", ;
                                                  "&mcof_173", ;
                                                  "&mcof_174", ;
                                                  "&mcof_175", ;
                                                  "&mcof_176", ;
                                                  "&mcof_177", ;
                                                  "&mcof_178", ;
                                                  "&mcof_179", ;
                                                  "&mcof_180", ;
                                                  "&mcof_181", ;
                                                  "&mcof_182", ;
                                                  "&mcof_183", ;
                                                  "&mcof_184", ;
                                                  "&mcof_185", ;
                                                  "&mcof_186", ;
                                                  "&mcof_187", ;
                                                  "&mcof_188", ;
                                                  "&mcof_189", ;
                                                  "&mcof_190", ;
                                                  "&mcof_191", ;
                                                  "&mcof_192" ;
                        NEXT M->how_many;
                        WHILE &while_cond FOR &for_cond DELIMITED
#else
                        COPY TO &filename FIELDS "&mcof_001", ;
                                                  "&mcof_002", ;
                                                  "&mcof_003", ;
                                                  "&mcof_004", ;
                                                  "&mcof_005", ;
                                                  "&mcof_006", ;
                                                  "&mcof_007", ;
                                                  "&mcof_008", ;
                                                  "&mcof_009", ;
                                                  "&mcof_010", ;
                                                  "&mcof_011", ;
                                                  "&mcof_012", ;
                                                  "&mcof_013", ;
                                                  "&mcof_014", ;
                                                  "&mcof_015", ;
                                                  "&mcof_016", ;
                                                  "&mcof_017", ;
                                                  "&mcof_018", ;
                                                  "&mcof_019", ;
                                                  "&mcof_020", ;
                                                  "&mcof_021", ;
                                                  "&mcof_022", ;
                                                  "&mcof_023", ;
                                                  "&mcof_024", ;
                                                  "&mcof_025", ;
                                                  "&mcof_026", ;
                                                  "&mcof_027", ;
                                                  "&mcof_028", ;
                                                  "&mcof_029", ;
                                                  "&mcof_030", ;
                                                  "&mcof_031", ;
                                                  "&mcof_032", ;
                                                  "&mcof_033", ;
                                                  "&mcof_034", ;
                                                  "&mcof_035", ;
                                                  "&mcof_036", ;
                                                  "&mcof_037", ;
                                                  "&mcof_038", ;
                                                  "&mcof_039", ;
                                                  "&mcof_040", ;
                                                  "&mcof_041", ;
                                                  "&mcof_042", ;
                                                  "&mcof_043", ;
                                                  "&mcof_044", ;
                                                  "&mcof_045", ;
                                                  "&mcof_046", ;
                                                  "&mcof_047", ;
                                                  "&mcof_048", ;
                                                  "&mcof_049", ;
                                                  "&mcof_050", ;
                                                  "&mcof_051", ;
                                                  "&mcof_052", ;
                                                  "&mcof_053", ;
                                                  "&mcof_054", ;
                                                  "&mcof_055", ;
                                                  "&mcof_056", ;
                                                  "&mcof_057", ;
                                                  "&mcof_058", ;
                                                  "&mcof_059", ;
                                                  "&mcof_060", ;
                                                  "&mcof_061", ;
                                                  "&mcof_062", ;
                                                  "&mcof_063", ;
                                                  "&mcof_064", ;
                                                  "&mcof_065", ;
                                                  "&mcof_066", ;
                                                  "&mcof_067", ;
                                                  "&mcof_068", ;
                                                  "&mcof_069", ;
                                                  "&mcof_070", ;
                                                  "&mcof_071", ;
                                                  "&mcof_072", ;
                                                  "&mcof_073", ;
                                                  "&mcof_074", ;
                                                  "&mcof_075", ;
                                                  "&mcof_076", ;
                                                  "&mcof_077", ;
                                                  "&mcof_078", ;
                                                  "&mcof_079", ;
                                                  "&mcof_080", ;
                                                  "&mcof_081", ;
                                                  "&mcof_082", ;
                                                  "&mcof_083", ;
                                                  "&mcof_084", ;
                                                  "&mcof_085", ;
                                                  "&mcof_086", ;
                                                  "&mcof_087", ;
                                                  "&mcof_088", ;
                                                  "&mcof_089", ;
                                                  "&mcof_090", ;
                                                  "&mcof_091", ;
                                                  "&mcof_092", ;
                                                  "&mcof_093", ;
                                                  "&mcof_094", ;
                                                  "&mcof_095", ;
                                                  "&mcof_096", ;
                                                  "&mcof_097", ;
                                                  "&mcof_098", ;
                                                  "&mcof_099", ;
                                                  "&mcof_100", ;
                                                  "&mcof_101", ;
                                                  "&mcof_102", ;
                                                  "&mcof_103", ;
                                                  "&mcof_104", ;
                                                  "&mcof_105", ;
                                                  "&mcof_106", ;
                                                  "&mcof_107", ;
                                                  "&mcof_108", ;
                                                  "&mcof_109", ;
                                                  "&mcof_110", ;
                                                  "&mcof_111", ;
                                                  "&mcof_112", ;
                                                  "&mcof_113", ;
                                                  "&mcof_114", ;
                                                  "&mcof_115", ;
                                                  "&mcof_116", ;
                                                  "&mcof_117", ;
                                                  "&mcof_118", ;
                                                  "&mcof_119", ;
                                                  "&mcof_120", ;
                                                  "&mcof_121", ;
                                                  "&mcof_122", ;
                                                  "&mcof_123", ;
                                                  "&mcof_124", ;
                                                  "&mcof_125", ;
                                                  "&mcof_126", ;
                                                  "&mcof_127" ;
                        NEXT M->how_many;
                        WHILE &while_cond FOR &for_cond DELIMITED
#endif
                        RELEASE ALL LIKE mcof_*

		ENDCASE

		IF aseek(M->dbf, M->filename) > 0
			* copying to an open file...good luck again!
			SELECT (aseek(M->dbf, M->filename))
			USE &filename

		ENDIF

		IF FILE(name(M->filename) + M->def_ext) .AND. M->add_name
			* add only .dbf files in the current directory
			new_el = afull(&files) + 1

			IF M->new_el <= LEN(&files)
				&files[M->new_el] = M->filename
				array_sort(&files)

			ENDIF
		ENDIF

        stat_msg(IF (DEUTSCH,"Datei kopiert","File copied"))
		done = .T.

ENDCASE

RETURN M->done


********************************
* functions specific to APPEND *
********************************

******
*	appe_title()
*
*	display title for "append"
******
FUNCTION appe_title

PARAMETERS sysparam
IF DEUTSCH
   RETURN box_title(M->sysparam, "Anhngen an " +;
                    SUBSTR(M->cur_dbf, RAT("\", M->cur_dbf) + 1) +;
                    " aus")
ENDIF
RETURN box_title(M->sysparam, "Append to " +;
							  SUBSTR(M->cur_dbf, RAT("\", M->cur_dbf) + 1) +;
							  " from")


******
*	src_getfil()
*
*	get source filename for "append"
******
FUNCTION src_getfil

PARAMETERS sysparam

help_code = M->prime_help
RETURN getfile(M->sysparam, 3)


******
*   frm_form()
*
*   get frm filename for "report"
******
FUNCTION frm_form

PARAMETERS sysparam

help_code = M->prime_help
RETURN getfile(M->sysparam, 3)

******
*   lbl_form()
*
*   get lbl filename for "label"
******
FUNCTION lbl_form

PARAMETERS sysparam

help_code = M->prime_help
RETURN getfile(M->sysparam, 3)


******
*	do_append()
*
*	do the append command
*
*	note: this function is called when <enter> is pressed
*		  while the cursor is on the "Ok" button
******
FUNCTION do_append

PRIVATE done

* assume incomplete
done = .F.

DO CASE

    CASE EMPTY(M->filename)
        error_msg(IF (DEUTSCH,"Keine Quelldatei angegeben",;
                              "Source not selected"))

	CASE M->filename == M->cur_dbf
        error_msg(IF (DEUTSCH,"Daten knnen nicht aus derselben Datei angehngt werden",;
                              "File cannot be appended from itself"))

	CASE .NOT. FILE(M->filename)
        do d_cope_err

	CASE .NOT. EMPTY(M->for_cond) .AND. TYPE(M->for_cond) <> "L"
        do d_lex_err

	CASE .NOT. EMPTY(M->while_cond) .AND. TYPE(M->while_cond) <> "L"
        do d_wex_err

	OTHERWISE
		* ok to append

		IF aseek(M->dbf, M->filename) > 0
			* appending from an open file
			SELECT (aseek(M->dbf, M->filename))
			USE
			STORE .T. TO need_field,need_ntx,need_relat,need_filtr

		ENDIF

        stat_msg(IF (DEUTSCH,"Anhngen","Appending"))
		SELECT (M->cur_area)

		IF EMPTY(M->for_cond)
			* literal true is the same as no FOR condition
			for_cond = ".T."

		ENDIF

		IF EMPTY(M->while_cond)
			* literal true is the same as no WHILE condition
			while_cond = ".T."

		ENDIF

		DO CASE

			CASE M->mode = 1 .AND. M->how_many = 0
				APPEND FROM &filename WHILE &while_cond FOR;
							&for_cond

			CASE M->mode = 1 .AND. M->how_many > 0
				APPEND FROM &filename NEXT M->how_many WHILE;
							&while_cond FOR &for_cond

			CASE M->mode = 2 .AND. M->how_many = 0
				APPEND FROM &filename WHILE &while_cond FOR;
							&for_cond SDF

			CASE M->mode = 2 .AND. M->how_many > 0
				APPEND FROM &filename NEXT M->how_many WHILE;
							&while_cond FOR &for_cond SDF

			CASE M->mode = 3 .AND. M->how_many = 0
				APPEND FROM &filename WHILE &while_cond FOR;
							&for_cond DELIMITED

			CASE M->mode = 3 .AND. M->how_many > 0
				APPEND FROM &filename NEXT M->how_many WHILE;
							&while_cond FOR &for_cond DELIMITED

		ENDCASE

		IF aseek(M->dbf, M->filename) > 0
			* appending from an open file
			SELECT (aseek(M->dbf, M->filename))
			USE &filename

		ENDIF

        stat_msg(IF (DEUTSCH,"Anhngen beendet","Append completed"))
		done = .T.

ENDCASE

RETURN M->done


*********************************
* functions specific to REPLACE *
*********************************

******
*	repl_title()
*
*	display title for "replace"
******
FUNCTION repl_title

PARAMETERS sysparam

RETURN box_title(M->sysparam, IF (DEUTSCH,"Ersetze","Replace")+" in " +;
							  SUBSTR(M->cur_dbf, RAT("\", M->cur_dbf) + 1) +;
							  "...")


******
*   sum_title()
*
*   display title for "Sum"
******
FUNCTION sum_title

PARAMETERS sysparam

RETURN box_title(M->sysparam, "SUM in " +;
							  SUBSTR(M->cur_dbf, RAT("\", M->cur_dbf) + 1) +;
							  "...")

******
*   sor_title()
*
*   display title for "sort"
******
FUNCTION sor_title

PARAMETERS sysparam

RETURN box_title(M->sysparam, IF (DEUTSCH,"Sortiere ","Sort ") +;
							  SUBSTR(M->cur_dbf, RAT("\", M->cur_dbf) + 1) +;
                              IF (DEUTSCH," zu..."," to..."))


******
*   sor_field()
*
*   get fieldnames for sort (only one field can be summed at a time)
******
FUNCTION sor_field

PARAMETERS sysparam

help_code = M->prime_help
RETURN genfield(M->sysparam, .T.)


******
*   sort_ord()
*
*   get "sort" order
******
FUNCTION sort_ord

PARAMETERS sysparam
help_code = 16
RETURN get_exp(M->sysparam, "ORDER  ", 5, "s_order")



******
*	repl_field()
*
*	get fieldname for replace (only one field can be replaced at a time)
******
FUNCTION repl_field

PARAMETERS sysparam

help_code = M->prime_help
RETURN genfield(M->sysparam, .T.)

******
*   sum_field()
*
*   get fieldname for sum (only one field can be summed at a time)
******
FUNCTION sum_field

PARAMETERS sysparam

help_code = M->prime_help
RETURN genfield(M->sysparam, .T.)


******
*	with_exp()
*
*	get "with" expression for replace
******
FUNCTION with_exp

PARAMETERS sysparam
PRIVATE rval

help_code = M->prime_help
rval = get_exp(M->sysparam, "WITH   ", 4, "with_what")

IF M->sysparam = 4 .AND. LASTKEY() = 13 .AND. .NOT. EMPTY(M->with_what)
	* expression just entered..dehilite and jump to 'Ok'
	get_exp(3, "WITH   ", 4, "with_what")
	to_ok()

ENDIF

RETURN M->rval

******
*   what_exp()
*
*   get "what" expression for sum
******
FUNCTION what_exp

PARAMETERS sysparam
PRIVATE rval

help_code = M->prime_help
rval = get_exp(M->sysparam, "TO     ", 4, "to_what")

RETURN M->rval

******
*   what_dbf()
*
*   get to dbf for sort
******
FUNCTION what_dbf

PARAMETERS sysparam
PRIVATE rval

help_code = M->prime_help
rval = get_exp(M->sysparam, "TO     ", 4, "to_what")

RETURN M->rval


******
*	do_replace()
*
*	do the replace command
*
*	note: this function is called when <enter> is pressed
*		  while the cursor is on the "Ok" button
******
FUNCTION do_replace

PRIVATE done

* assume incomplete
done = .F.

DO CASE

    CASE EMPTY(M->field_mvar)
        error_msg(IF (DEUTSCH,"Kein Feld gewhlt","Field not selected"))

	CASE EMPTY(M->with_what)
        error_msg(IF (DEUTSCH,"Ersetzen-Ausdruck nicht angegeben",;
                              "Replace expression not entered"))

	CASE TYPE(M->with_what) <> TYPE(M->field_mvar) .and. ;
		!(TYPE(M->field_mvar) == "M") .and. ;
		!(TYPE(M->with_what) == "UI")
        error_msg(IF (DEUTSCH,"Die Typen des Ersetzen-Ausdrucks und "+;
                              "Feldinhalts stimmen nicht berein",;
                   "Type mismatch between replace expression and field"))

	CASE .NOT. EMPTY(M->for_cond) .AND. TYPE(M->for_cond) <> "L"
        do d_lex_err

	CASE .NOT. EMPTY(M->while_cond) .AND. TYPE(M->while_cond) <> "L"
        do d_wex_err

	OTHERWISE
		* ok to replace
        stat_msg(IF (DEUTSCH,"Ersetze Daten","Replacing data"))

		IF EMPTY(M->for_cond)
			* literal true is the same as no FOR condition
			for_cond = ".T."

		ENDIF

		IF EMPTY(M->while_cond)
			* literal true is the same as no WHILE condition
			while_cond = ".T."

			IF M->how_many = 0
				* unless a scope has been entered
				GO TOP

			ENDIF
		ENDIF

		IF M->how_many = 0
			REPLACE &field_mvar WITH &with_what;
					WHILE &while_cond FOR &for_cond

		ELSE
			REPLACE NEXT M->how_many &field_mvar WITH &with_what;
					WHILE &while_cond FOR &for_cond

		ENDIF

        stat_msg(IF (DEUTSCH,"Ersetzen beendet","Replace completed"))
		done = .T.

ENDCASE

RETURN M->done

******
*   do_sum()
*
*   do the sum command
*
*	note: this function is called when <enter> is pressed
*		  while the cursor is on the "Ok" button
******
FUNCTION do_sum

PRIVATE done

* assume incomplete
done = .F.

DO CASE

	CASE EMPTY(M->field_mvar)
        error_msg(IF (DEUTSCH,"Feld nicht angegeben","Field not selected"))

    CASE EMPTY(M->to_what)
        error_msg(IF (DEUTSCH,"Variable fr Sum nicht angegeben",;
                              "Variable for Sum not entered"))

	CASE .NOT. EMPTY(M->for_cond) .AND. TYPE(M->for_cond) <> "L"
        error_msg(IF (DEUTSCH,"FOR Bedingung mu ein logischer Ausdruck sein",;
                              "FOR condition must be a Logical expression"))

	CASE .NOT. EMPTY(M->while_cond) .AND. TYPE(M->while_cond) <> "L"
        error_msg(IF (DEUTSCH,"WHILE Bedingung mu ein logischer Ausdruck sein",;
                              "WHILE condition must be a Logical expression"))

	OTHERWISE
        * ok to Sum
        stat_msg(IF (DEUTSCH,"Summiere Daten","Summing data"))

		IF EMPTY(M->for_cond)
			* literal true is the same as no FOR condition
			for_cond = ".T."

		ENDIF

		IF EMPTY(M->while_cond)
			* literal true is the same as no WHILE condition
			while_cond = ".T."

			IF M->how_many = 0
				* unless a scope has been entered
				GO TOP

			ENDIF
		ENDIF

		IF M->how_many = 0
            SUM &field_mvar TO &to_what;
					WHILE &while_cond FOR &for_cond

		ELSE
            SUM NEXT M->how_many &field_mvar TO &to_what;
					WHILE &while_cond FOR &for_cond

		ENDIF

        stat_msg(IF (DEUTSCH,"Summieren beendet","Summing completed"))
        @ M->wt + 5, M->wl + 2 SAY str(&to_what)
        inkey(0)
        stat_msg("")
        done = .T.

ENDCASE

RETURN M->done

******
*   do_sort()
*
*   do the sort command
*
*	note: this function is called when <enter> is pressed
*		  while the cursor is on the "Ok" button
******
FUNCTION do_sort

PRIVATE done

* assume incomplete
done = .F.

DO CASE

	CASE EMPTY(M->field_mvar)
        error_msg(IF (DEUTSCH,"Feld(er) nicht selektiert",;
                              "Field(s) not selected"))

    CASE EMPTY(M->to_what)
        error_msg(IF (DEUTSCH,"Zieldatei nicht angegeben",;
                              "Target file not entered"))

    CASE .NOT. EMPTY(s_order) .AND. .NOT. Substr(Ltrim(s_order), 1, 1) $ " DA"
        error_msg(IF (DEUTSCH,"Sortierfolge mu D oder A sein",;
                              "Sort order must be D or A"))

	CASE .NOT. EMPTY(M->for_cond) .AND. TYPE(M->for_cond) <> "L"
        do d_lex_err

	CASE .NOT. EMPTY(M->while_cond) .AND. TYPE(M->while_cond) <> "L"
        do d_wex_err

	OTHERWISE
        SELECT (M->cur_area)
        USE
        IF NetUse(M->cur_dbf,.T.,NIL,NIL,.F.,.F.)
           * ok to Sort
           stat_msg(IF (DEUTSCH,"Sortiere Daten","Sorting data"))
           ld_cha = '|'
           cBrowseBuf := SaveScreen(4, 0, 4, 79)
           saveColor := SetColor(M->color1)
           @ 4,1 SAY ld_cha + "       % sorted"

           IF EMPTY(M->for_cond)
              * literal true is the same as no FOR condition
              for_cond = ".T."
           ENDIF

           IF EMPTY(M->s_order)
              * /A is the default
              s_order = "A"
           ENDIF

           IF EMPTY(M->while_cond)
              * literal true is the same as no WHILE condition
              while_cond = ".T."
           ENDIF

           IF M->how_many = 0
              * unless a scope has been entered
              GO TOP
              SORT ON &field_mvar /&s_order TO &to_what;
                   WHILE &while_cond .and. zei_fort() FOR &for_cond

           ELSE
              SORT ON &field_mvar /&s_order TO &to_what;
                   NEXT M->how_many;
                   WHILE &while_cond .and. zei_fort() FOR &for_cond

           ENDIF

           stat_msg(IF (DEUTSCH,"Sortieren beendet","Sorting completed"))
           NetUse(M->cur_dbf,,,,.F.)   && Shared
           SetColor(saveColor)
           RestScreen(4, 0, 4, 79, cBrowseBuf)
           stat_msg("")
        ELSE
           do d_ex_err
           NetUse(M->cur_dbf,,,,.F.)   && Shared
        ENDIF

done = .T.

ENDCASE

RETURN M->done

****************************************
* functions specific to DELETE /RECALL *
****************************************

******
*	del_title()
*
*	display title for "delete"
******
FUNCTION del_title

PARAMETERS sysparam

RETURN box_title(M->sysparam, IF (DEUTSCH,"Lsche","Delete")+" in " +;
							  SUBSTR(M->cur_dbf, RAT("\", M->cur_dbf) + 1) +;
							  "...")
******
*	recall_title()
*
*	display title for "recall"
******
FUNCTION recall_title

PARAMETERS sysparam

RETURN box_title(M->sysparam, IF (DEUTSCH,"Zurckholen","Recall")+" in " +;
							  SUBSTR(M->cur_dbf, RAT("\", M->cur_dbf) + 1) +;
							  "...")

******
*	delrec_field()
*
*	get fieldname for condition
******
FUNCTION delrec_field

PARAMETERS sysparam

help_code = M->prime_help
RETURN genfield(M->sysparam, .T.)

******
*	do_delete()
*
*	do the delete command
*
*	note: this function is called when <enter> is pressed
*		  while the cursor is on the "Ok" button
******
FUNCTION do_delete

PRIVATE done

* assume incomplete
done = .F.

DO CASE

	CASE .NOT. EMPTY(M->for_cond) .AND. TYPE(M->for_cond) <> "L"
        do d_lex_err

	CASE .NOT. EMPTY(M->while_cond) .AND. TYPE(M->while_cond) <> "L"
        do d_wex_err

	OTHERWISE
		* ok to replace
        stat_msg(IF (DEUTSCH,"Lsche Stze","Deleting records"))

		IF EMPTY(M->for_cond)
			* literal true is the same as no FOR condition
			for_cond = ".T."

		ENDIF

		IF EMPTY(M->while_cond)
			* literal true is the same as no WHILE condition
			while_cond = ".T."

			IF M->how_many = 0
				* unless a scope has been entered
				GO TOP

			ENDIF
		ENDIF

		IF M->how_many = 0
			DELETE WHILE &while_cond FOR &for_cond

		ELSE
			DELETE NEXT M->how_many WHILE &while_cond FOR &for_cond

		ENDIF

        stat_msg(IF (DEUTSCH,"Lschen beendet","Delete completed"))
		done = .T.

ENDCASE

RETURN M->done

******
*	do_recall()
*
*	do the recall command
*
*	note: this function is called when <enter> is pressed
*		  while the cursor is on the "Ok" button
******
FUNCTION do_recall
PRIVATE done

* assume incomplete
done = .F.

DO CASE

	CASE .NOT. EMPTY(M->for_cond) .AND. TYPE(M->for_cond) <> "L"
        do d_lex_err


	CASE .NOT. EMPTY(M->while_cond) .AND. TYPE(M->while_cond) <> "L"
        do d_wex_err

	OTHERWISE
		* ok to replace
        stat_msg(IF (DEUTSCH,"Lschmarkierung aufheben","Recalling records"))

		IF EMPTY(M->for_cond)
			* literal true is the same as no FOR condition
			for_cond = ".T."

		ENDIF

		IF EMPTY(M->while_cond)
			* literal true is the same as no WHILE condition
			while_cond = ".T."

			IF M->how_many = 0
				* unless a scope has been entered
				GO TOP

			ENDIF
		ENDIF

		IF M->how_many = 0
			RECALL WHILE &while_cond FOR &for_cond

		ELSE
			RECALL NEXT M->how_many WHILE &while_cond FOR &for_cond

		ENDIF

        stat_msg(IF (DEUTSCH,"Zurckholen beendet","Recall completed"))
		done = .T.

ENDCASE

RETURN M->done

*************************************************
* functions common to COPY, APPEND, and REPLACE *
*************************************************

******
*	for_exp()
*
*	get "for" expression
******
FUNCTION for_exp

PARAMETERS sysparam

help_code = 16
RETURN get_exp(M->sysparam, "FOR    ", M->for_row, "for_cond")



******
*	while_exp()
*
*	get "while" expression
******
FUNCTION while_exp

PARAMETERS sysparam

help_code = 16
RETURN get_exp(M->sysparam, "WHILE  ", M->for_row + 1, "while_cond")


******
*	scope_num()
*
*	get scope
******
FUNCTION scope_num

PARAMETERS sysparam
local saveColor
PRIVATE old_scope

help_code = 17
saveColor := SetColor(M->colorNorm)

DO CASE

	CASE M->sysparam = 1 .OR. M->sysparam = 3
		* normal display
		@ M->wt + M->for_row + 2, M->wl + 2;
		SAY "SCOPE  " + pad(IF(M->how_many = 0, "ALL",;
							"NEXT " + LTRIM(STR(M->how_many))), 20)

		IF M->sysparam = 1
			* report position
			@ M->wt + M->for_row + 2, M->wl + 9 SAY ""

		ENDIF

	CASE M->sysparam = 2
		* hi-lite
		SetColor(M->colorHilite)
		@ M->wt + M->for_row + 2, M->wl + 9;
		SAY pad(IF(M->how_many = 0,;
				   "ALL", "NEXT " + LTRIM(STR(M->how_many))), 20)

	CASE M->sysparam = 4
		* selected

		IF CHR(M->keystroke) $ "0123456789" + CHR(13)
			* numeric digit or <enter>

			IF M->keystroke <> 13
				* include initial digit in entry
				KEYBOARD CHR(M->keystroke)

			ENDIF

			old_scope = M->how_many		&& in case of abort

			* set certain keys to exit the READ
			SET KEY 5 TO clear_gets
			SET KEY 24 TO clear_gets
			xkey_clear()

			* image is important
			SetColor(M->colorHilite)
			@ M->wt + M->for_row + 2, M->wl + 9 SAY pad("NEXT",20)

			SetColor(M->colorNorm)
			@ M->wt + M->for_row + 2, M->wl + 14;
			GET M->how_many PICTURE "99999999"

			SET CURSOR ON
			READ
			SET CURSOR OFF

			* remember the exit key
			keystroke = LASTKEY()

			* restore keys to normal
			SET KEY 5 TO
			SET KEY 24 TO
			xkey_norm()

			IF M->keystroke = 13
				* jump to "Ok" button
				to_ok()
				@ M->wt + M->for_row + 2, M->wl + 9;
				SAY pad(IF(M->how_many = 0, "ALL", "NEXT " +;
						LTRIM(STR(M->how_many))), 20)

			ELSE

				IF menu_key() <> 0
					* menu request
					how_many = M->old_scope

				ENDIF

				IF M->keystroke <> 27 .AND. .NOT. isdata(M->keystroke)
					* forward the request
					KEYBOARD CHR(M->keystroke)

				ENDIF
			ENDIF

		ELSE
			* character key..scope = 0 = ALL
			how_many = 0

		ENDIF
ENDCASE

SetColor(saveColor)
RETURN 2


***************************************
* functions common to COPY and APPEND *
***************************************

******
*	tog_sdf()
*
*	toggle sdf mode
******
FUNCTION tog_sdf

PARAMETERS sysparam
local saveColor

help_code = 11
saveColor := SetColor(M->colorNorm)

DO CASE

	CASE M->sysparam = 1 .OR. M->sysparam = 3
		* normal display
		@ M->wt + 9, M->wl + 8 SAY " SDF "

		IF M->mode = 2
			* SDF is current mode
			@ M->wt + 8, M->wl + 7, M->wt + 10, M->wl + 13 BOX sframe

		ENDIF

		IF M->sysparam = 1
			* report position
			@ M->wt + 9, M->wl + 9 SAY ""

		ENDIF

	CASE M->sysparam = 2
		* hi-lite
		SetColor(M->colorHilite)
		@ M->wt + 9, M->wl + 8 SAY " SDF "

	CASE M->sysparam = 4 .AND. M->keystroke = 13
		* selected..no character keys accepted here

		IF M->mode = 2
			* SDF...toggle off
			@ M->wt + 8, M->wl + 7, M->wt + 10, M->wl + 13 BOX "        "
			mode = 1

			* change from .TXT to .DBF
			cur_el = 1
			rel_row = 0
			files = "dbf_list"
			def_ext = ".DBF"
			filelist(1)			&& display new list

		ELSE
			* toggle SDF on

			IF M->mode = 3
				* toggle DELIMITED off
				@ M->wt + 8, M->wl + 16, M->wt + 10, M->wl + 28 BOX "        "

			ELSE
				* normal mode..change from .DBF to .TXT
				cur_el = 1
				rel_row = 0
				files = "txt_list"
				def_ext = ".TXT"
				filelist(1)		&& display new list

			ENDIF

			* indicate SDF on
			@ M->wt + 8, M->wl + 7, M->wt + 10, M->wl + 13 BOX sframe
			mode = 2

		ENDIF
ENDCASE

SetColor(saveColor)
RETURN 2


******
*	tog_delim
*
*	toggle delimited mode
******
FUNCTION tog_delim

PARAMETERS sysparam
local saveColor

help_code = 11
saveColor := SetColor(M->colorNorm)
DO CASE

	CASE M->sysparam = 1 .OR. M->sysparam = 3
		* normal display
		@ M->wt + 9, M->wl + 17 SAY " DELIMITED "

		IF M->mode = 3
			* DELIMITED is current mode
			@ M->wt + 8, M->wl + 16, M->wt + 10, M->wl + 28 BOX sframe

		ENDIF

		IF M->sysparam = 1
			* report position
			@ M->wt + 9, M->wl + 17 SAY ""

		ENDIF

	CASE M->sysparam = 2
		* hi-lite
		SetColor(M->colorHilite)
		@ M->wt + 9, M->wl + 17 SAY " DELIMITED "

	CASE M->sysparam = 4 .AND. M->keystroke = 13
		* selected..no character keys accepted here

		IF M->mode = 3
			* DELIMITED...toggle off
			@ M->wt + 8, M->wl + 16, M->wt + 10, M->wl + 28 BOX "        "
			mode = 1

			* change from .TXT to .DBF
			cur_el = 1
			rel_row = 0
			files = "dbf_list"
			def_ext = ".DBF"
			filelist(1)			&& display new list

		ELSE
			* toggle DELIMITED on

			IF M->mode = 2
				* toggle SDF off
				@ M->wt + 8, M->wl + 7, M->wt + 10, M->wl + 13 BOX "        "

			ELSE
				* normal mode..change from .DBF to .TXT
				cur_el = 1
				rel_row = 0
				files = "txt_list"
				def_ext = ".TXT"
				filelist(1)		&& display new list

			ENDIF

			* indicate DELIMITED on
			@ M->wt + 8, M->wl + 16, M->wt + 10, M->wl + 28 BOX sframe
			mode = 3

		ENDIF
ENDCASE

SetColor(saveColor)
RETURN 2

PROCEDURE gcopfi
LOCAL j, jm, my_fields
PRIVATE t
 my_fields = "field_n" + SUBSTR("123456", M->cur_area, 1)
 j := 1
 jm := LEN(&my_fields)
 DO WHILE j <= jm
    * Must fill all fields and define the fields as public
    t = LTRIM(STRZERO(j,3))
    PUBLIC mcof_&t
    mcof_&t = rtrim(&my_fields[j])
    j++
 enddo

return 


* EOF DBUCOPY.PRG
