/*
   DBT2FPT.PRG - Memo file converter by Loren Scott / SuccessWare 90, Inc.

   This is a simple program demonstrating how to convert Clipper .DBT's
   to FoxPro-compatible FPT's using the Clipper 5.2 DBFCDX RDD.

    Compile:  CLIPPER dbt2fpt /n/w
    Link   :  BLINKER FI dbt2fpt LIB dbfcdx,clipper

   ---------------------------------------------------------------------
*/

#include "RDDSYS.CH"

REQUEST DBFCDX


FUNC DBT2FPT( cOldFile, cNewFile )

LOCAL aFile := {}

cOldFile := Upper( AllTrim( cOldFile ))
cNewFile := Upper( AllTrim( cNewFile ))

IF "." $ cOldFile
  cOldFile := Left( cOldFile, at( ".", cOldFile )-1 )
ENDIF

IF "." $ cNewFile
  cNewFile := Left( cNewFile, at( ".", cNewFile )-1 )
ENDIF

// Display a message
? "DBT2FPT - Memo File Converter"
?

// Make sure we got the correct parameters
IF PCOUNT() < 2
  ? "USAGE:  DBT2FPT <oldfile> <newfile>"
  ?
  ? "where:  <oldfile> = Name of the database containing the memo"
  ? "                    field to convert."
  ? "        <newfile> = New file to create"
  ?
  Return(1)
ENDIF

// Check for the original file
IF !File( cOldFile + ".DBF" )
  ? "Cannot find " + cOldFile + "!"
  ?
  Return(2)
ENDIF

// Open the original file (using DBFNTX)
USE (cOldFile) VIA "DBFNTX"

// Set DBFCDX Driver as the default for creating new dbf
RDDSetDefault("DBFCDX")

// Show that we're doing something
? "Working"

// Now copy to the new file (with nifty UDF)
COPY TO (cNewFile) FOR ShowDot()

// Look, we made it!
?? "Done!"
?

// Clean up before leaving
CLOSE ALL

// Compare file sizes
aFile := Directory( cOldFile + ".DBT" )
? PadR( "Old " + cOldFile + ".DBT Size",21 ) + ": "
?? Str( aFile[1,2] ) + " bytes"
aFile := Directory( cNewFile + ".FPT" )
? PadR( "New " + cNewFile + ".FPT Size",21 ) + ": "
?? Str( aFile[1,2] ) + " bytes"
?

Return(0)

FUNC ShowDot()
  ?? "."
Return (.T.)
