* "dbrowse()" .PRG
* This module is the "dbrowse" engine
*
* Following are navigation keys:
* <Home> <PgUp> <Up Arrow> <Down Arrow> <PgDown> <End>
* 
* Following are editing keys:              
* <Ins> add record   <Enter> edit record   <Del> delete record
*
* Example call:
* DO dbrowse WITH toprow, l_col, b_row, r_col, std_clr, enhcd_clr, bar_clr
*
* (c) 1992
* Captain Chuck Becker
* 1/31/92


#INCLUDE c:\force\hdr\system.hdr
#INCLUDE c:\force\hdr\io.hdr
#INCLUDE c:\force\hdr\string.hdr
#INCLUDE c:\force\hdr\database.hdr

#DEFINE K_HOME       32839
#DEFINE K_UP         32840
#DEFINE K_PG_UP      32841
#DEFINE K_END        32847
#DEFINE K_DOWN       32848
#DEFINE K_PG_DOWN    32849
#DEFINE K_INS        32850
#DEFINE K_DEL        32851
#DEFINE K_ENTER         13
#DEFINE K_ESC           27


* --- This block must be modified for each call to dbrowse --
DBFDEF mydbf EXTERN                                        &&
   CHAR(20) name                                           &&
   CHAR(10) phone                                          &&
   MEMO     notes                                          &&
ENDDEF                                                     &&
                                                           &&
INDEXDEF EXTERN                                            &&
   CHAR(20) mydbf_1  upper(mydbf->name)                    &&
ENDDEF                                                     &&
* -----------------------------------------------------------

VARDEF PRIVATE
   UINT     key_hit
   LONG     row_marker
   LONG     record_marker
   LONG     rows_written
   LONG     scratch_row
ENDDEF   

VARDEF EXTERN
   BYTE  __color_std    && controls "normal" color
   BYTE  __color_enhcd  && controls "enhanced" (get) color
ENDDEF

* --- modify the type and size of "line_item" for each call --
FUNCTION CHAR(35) line_item PROTOTYPE                       &&
* ------------------------------------------------------------


* --- modify this procedure as necessary for each call ---
PROCEDURE read_vals PROTOTYPE                           &&
   PARAMETERS LONG left_col                             &&
* --------------------------------------------------------


PROCEDURE redraw_screen PROTOTYPE
   PARAMETERS LONG top_row, LONG left_col, LONG bottom_row, LONG right_col


PROCEDURE dbrowse
   PARAMETERS LONG top_row, LONG left_col, LONG bottom_row, LONG right_col,;
              UINT c_standard, UINT c_enhanced, UINT c_litebar
   
   VARDEF
      LONG  max_rows
   ENDDEF
   
   max_rows = bottom_row - top_row + 1

   key_hit = &K_HOME            && forces a "home" key on entry into the loop
   
   DO WHILE key_hit <> &K_ESC      && main processing loop, exit on <Esc> key
      DO CASE
         
         CASE key_hit = &K_HOME
            @ top_row, left_col CLEAR TO bottom_row, right_col
            rows_written = 0
            GO TOP
            DO WHILE .NOT. eof() .AND. rows_written < max_rows
               @ top_row + rows_written, left_col SAY line_item()
               SKIP 1
               rows_written = rows_written + 1
            ENDDO
            @ top_row, left_col
            GO TOP
         
         CASE key_hit = &K_PG_UP
            SKIP -( max_rows + row() - top_row )
            IF bof()
               key_hit = &K_HOME
               LOOP
            ELSE
               SKIP max_rows
               @ top_row, left_col CLEAR TO bottom_row, right_col
               rows_written = 0
               DO WHILE .NOT. bof() .AND. rows_written < max_rows
                  @ bottom_row - rows_written, left_col SAY line_item()
                  SKIP -1
                  rows_written = rows_written + 1
               ENDDO
               SKIP max_rows
               @ bottom_row, left_col
            ENDIF
         
         CASE key_hit = &K_UP
            @ row(), left_col SAY line_item()
            SKIP -1
            IF bof()
               GO TOP
               key_hit = 7    && sounds 'bell' on "otherwise"
               LOOP
            ELSE
               @ row()-1, left_col
               IF row() < top_row
                  @ top_row, left_col
                  scroll( 7,; 
                     top_row,; 
                     left_col,; 
                     bottom_row,; 
                     right_col,; 
                     1,; 
                     c_standard )
               ENDIF
            ENDIF
         
         CASE key_hit = &K_DOWN
            @ row(), left_col SAY line_item()
            SKIP
            IF eof()
               GO BOTTOM
               key_hit = 7    && sounds 'bell' on "otherwise"
               LOOP
            ELSE
               @ row()+1, left_col
               IF row() > bottom_row
                  @ bottom_row, left_col
                  scroll( 6,; 
                     top_row,; 
                     left_col,; 
                     bottom_row,; 
                     right_col,; 
                     1,; 
                     c_standard )
               ENDIF
            ENDIF
         
         CASE key_hit = &K_PG_DOWN
            SKIP max_rows + bottom_row - row()
            IF eof()
               key_hit = &K_END
               LOOP
            ELSE
               SKIP -max_rows
               @ top_row, left_col CLEAR TO bottom_row, right_col
               rows_written = 0
               DO WHILE .NOT. eof() .AND. rows_written < max_rows
                  @ top_row + rows_written, left_col SAY line_item()
                  SKIP 1
                  rows_written = rows_written + 1
               ENDDO
               SKIP -max_rows
               @ top_row, left_col
            ENDIF
         
         CASE key_hit = &K_END
            @ top_row, left_col CLEAR TO bottom_row, right_col
            rows_written = 0
            GO BOTTOM
            DO WHILE .NOT. bof() .AND. rows_written < max_rows
               @ bottom_row - rows_written, left_col SAY line_item()
               SKIP -1
               rows_written = rows_written + 1
            ENDDO
            @ bottom_row, left_col
            GO BOTTOM
            IF rows_written < max_rows
               scroll( 6,; 
                       top_row,; 
                       left_col,; 
                       bottom_row,; 
                       right_col,; 
                       max_rows - rows_written,; 
                       c_standard )
               @ bottom_row - (max_rows - rows_written), left_col
            ENDIF
         
         CASE key_hit = &K_INS                                && add a record
            curcolor( row(), left_col, c_standard, len( line_item() ) )
            scroll( 6,; 
                    top_row,; 
                    left_col,; 
                    row(),; 
                    right_col,; 
                    1,; 
                    c_standard )
            curcolor( row(), left_col, c_enhanced, len( line_item() ) )
            APPEND BLANK
            DO read_vals WITH left_col
            DO redraw_screen WITH top_row, left_col, bottom_row, right_col
         
         CASE key_hit = &K_ENTER                       && edit current record
            curcolor( row(), left_col, c_enhanced, len( line_item() ) )
            IF .NOT. eof()
               DO read_vals WITH left_col
               DO redraw_screen WITH top_row, left_col, bottom_row, right_col
            ELSE
               key_hit = 7
               LOOP
            ENDIF
            
         CASE key_hit = &K_DEL                       && delete current record
            IF .NOT. eof()
               DELETE
               SKIP
               IF eof()
                  GO BOTTOM
               ENDIF

               DO redraw_screen WITH top_row, left_col, bottom_row, right_col
            ELSE
               key_hit = 7
               LOOP
            ENDIF
            
         OTHERWISE
            ?? chr( 7 )
      ENDCASE
      
      __color_std = c_litebar              && this block draws the "high-
      @ row(), left_col SAY line_item()      && light" bar for the current
      __color_std = c_standard              && record
      
      CLEAR TYPEAHEAD
      DO cursor_off
      key_hit = get_key()       && ATTENTION!!! this is where the loop pauses
      DO cursor_on              && to wait for a user keystroke!!!
   
   ENDDO

ENDPRO

      
* --- Modify this function to return desired line item -------------------
FUNCTION CHAR(35) line_item                                             &&
   IF eof()                                                             &&
      RETURN space(35)                                                  &&
   ELSE                                                                 &&
      RETURN mydbf->name + "  " + "(" + substr(mydbf->phone, 1, 3) +;   &&
                                  ")" + substr(mydbf->phone, 4, 3) +;   &&
                                  "-" + substr(mydbf->phone, 7, 4)      &&
   ENDIF                                                                &&
ENDPRO                                                                  &&
* ------------------------------------------------------------------------


* --- modify this block as necessary for each call ------------------------
PROCEDURE read_vals                                                      &&
   PARAMETERS LONG left_col                                              &&
   CLEAR GETS                                                            &&
      @ row(), left_col GET mydbf->name                                  &&
      @ row(), left_col+22 GET mydbf->phone PICTURE "@R (999)999-9999"   &&
   READ                                                                  &&
ENDPRO                                                                   &&
* -------------------------------------------------------------------------

PROCEDURE redraw_screen
   PARAMETERS LONG top_row, LONG left_col, LONG bottom_row, LONG right_col
   
   VARDEF
      LONG  max_rows
   ENDDEF

   max_rows = bottom_row - top_row + 1
   record_marker = recno()
   rows_written = 0
   scratch_row = row() - top_row
   SKIP -( scratch_row )
   IF bof()
      GO TOP
   ENDIF
            
   @ top_row, left_col CLEAR TO bottom_row, right_col
   DO WHILE .NOT. eof() .AND. rows_written < max_rows
      @ top_row + rows_written, left_col SAY line_item()
      IF recno() = record_marker
         row_marker = row()
      ENDIF
      rows_written = rows_written + 1
      SKIP 1
   ENDDO
   SKIP -1
   @ row_marker, left_col
   SKIP -( top_row + rows_written - row_marker - 1 )

ENDPRO
