///////////////////////////////////////////////////////////////
// DBPRN.PRG
// Allows the user to print a selected database structure
// Written by James McCullen
// 11/11/93
///////////////////////////////////////////////////////////////
#include "DBSTRUCT.CH"
FUNCTION MAIN
LOCAL aStruct
LOCAL afiles [ADIR("*.DBF")] 
ADIR("*.dbf", afiles)
cMemBox = CHR(218)+CHR(196)+CHR(191)+CHR(179)+CHR(217)+;
   CHR(196)+CHR(192)+CHR(179)

DO WHILE .T.
   CLEAR
   M_NAME = SPACE(20)
   @ 5,15 SAY "PRINT DATABASE STRUCTURE"
   @15,15 SAY "PLEASE ENTER DATABASE NAME " GET M_NAME PICT "@!"
   @16,15 SAY "TYPE 'DBF' TO PRINT ALL DBF FILES IN CURRENT DIRECTORY"
   @17,15 SAY "TYPE '?' TO SEE A LIST OF AVAILABLE DBF FILES"
   @18,15 SAY "LEAVE BLANK TO EXIT"
   READ
   IF M_NAME = SPACE(20)
      CLOSE DATA 
      QUIT
   ENDIF
   IF M_NAME = "?"
         save_lines := SAVESCREEN(0,0,24,79)
         @15,39,21,53 BOX cMemBox
         nSele := ACHOICE(16,40,20,52,aFiles)
         IF nSele > 0
            M_Name := aFiles[nSele]
            PRNDBF()
         ENDIF
         RESTSCREEN(0,0,24,79,save_lines)
         LOOP
   ENDIF
   
   IF M_NAME <> "DBF"
      IF FILE(M_NAME+".DBF")
         M_NAME := RTRIM(M_NAME)+".DBF"
         PRNDBF()
      ELSE
         @16,15 SAY "INVALID FILE NAME - PRESS ENTER"
         INKEY(0)
         LOOP
      ENDIF
   ELSE
      FOR i = 1 to len(afiles)
          M_Name = aFiles[i]
          PRNDBF()
      next 
   ENDIF
ENDDO
RETURN

FUNCTION PRNDBF()
   CLEAR
   USE (M_NAME)
   aStruct := dbstruct()
   SET DEVICE TO PRINT
   SET PRINT ON
   @1, 5 SAY "PUT YOUR COMPANY NAME HERE"
   @2, 5 SAY "DATABASE: " + M_NAME 
   @3, 5 SAY "DATE    : " + dtoc(date())
   @4, 5 SAY " "
   @5, 0 SAY "FIELD NAME"
   @5,12 SAY "TYPE"
   @5,24 SAY "LENGTH"
   @5,38 SAY "DEC"
   @6, 0 SAY "----------"
   @6,12 SAY "----"
   @6,24 SAY "------"
   @6,38 SAY "---"
   
   AEVAL(astruct, {|afield| qout(padr(afield[DBS_NAME],12," "),; 
         afield[DBS_TYPE]," ", afield[DBS_LEN]," ", afield[DBS_DEC])} )
   qout("*** EOF ***")
   EJECT
   SET PRINT OFF
   SET DEVICE TO SCREEN
RETURN
