; ************** dBASE II/III PASSWORD NON-ECHO KEYBOARD ROUTINE ************
;
;  This program was developed out of a need to enter a password in a dBASE II
;  application and NOT have it echoed on screen.  Characters are entered
;  normally, but only "*" characters appear on screen.  One could modify
;  this program for longer strings, different displayed character, or response
;  to extended characters.
;

CODE        SEGMENT
PASSWORD    PROC FAR
            ASSUME CS:CODE

;           PUSH DS          ;These three lines are only needed for dBIII
;           MOV AX,0         ;using the RUN command.  Otherwise skip them
;           PUSH AX          ;for use with dBII.

            INC BX          ;BX contains address of string passed with
                            ;dBII CALL command.
            MOV CL,0        ;Initialize a counter.

LOOP:
            CMP CL,8        ;Max of 8 characters allowed in this sample.
            JE  FINI
            INC CL
            MOV AH,8        ;Get a single character via DOS function.
            INT 21H
            MOV [BX],AL     ;Save character in string.
            INC BX
            CMP AL,13       ;Is it <RETURN>?
            JE  FINI        ;If so, then quit.
            CMP AL,0        ;Is it an extended code?
            JE  LOOP        ;If so, then don't print anything.
            MOV AH,2        ;Write a single character.
            MOV DL,42       ;Replace with a "*" character on screen only.
            INT 21H
            JMP LOOP
FINI:
            RET             ;Finished, so return to dBII or DOS.

PASSWORD    ENDP
CODE        ENDS
            END
