/* STDEV.C: Clipper function                                    */
/* Computes and returns standard deviation for an array of      */
/* numbers                                                      */
/* Call from Clipper with DEVIATION = stdev (array)             */
/* Returns a double                                             */

#include <nandef.h>
#include <extend.h>
#include <math.h>

CLIPPER stdev ()
{
double mean = 0.0, var = 0.0;
int     i, n;

	if (!(PCOUNT > 0 && ISARRAY (1))) {               /* if bad arg */
		_retnd (0.0);                                  /* return 0.0 */
		return;
	}
	if (ALENGTH (1) < 2) {               /* same if array too small */
		_retnd (0.0);
		return;
	}

	/* Calculate the mean */
	for (i = 1, n = 0; i <= ALENGTH (1); i++) /* for # elements... */
		if (_parinfa (1, i) == NUMERIC) {      /* if numeric then.. */
			mean += _parnd (1, i);            /* accumulate subtotal */
			++n;                             /* count valid elements */
		}
	if (n > 0)                     /* if we have valid elements... */
		mean /= (double) n;                          /* derive mean */
	else {
		_retnd (0.0);
		return;
	}

	/* Calculate variance */
	for (i = 1; i <= ALENGTH (1); i++)        /* for # elements... */
		if (_parinfa (1, i) == NUMERIC)       /* if numeric then... */
			var += ((_parnd (1, i)-mean) * (_parnd (1, i)-mean));

	/* Return Standard Deviation */
	_retnd (sqrt (var / (double) n));
}
