/* BIGGEST.C: Clipper function to return greatest */
/* of three integers. Call from Clipper           */
/* as X = greatest (a, b, c). Validates arguments */
/* and substitutes -32767 for any invalid ones.   */
#include "nandef.h"
#include "extend.h"
#define  TINY  -32768

CLIPPER biggest ()
{
int a, b, c;

	/* Check the arguments */
	if (PCOUNT == 3 && ISNUM (1) && ISNUM (2) && ISNUM (3)) {
		a = _parni (1);
					/* all args are valid */
		b = _parni (2);
		c = _parni (3);
	} else {
				/* else find and replace bad args */
		c = (PCOUNT < 3) ? TINY : _parni (3);
				/* replace as required */
		b = (PCOUNT < 2) ? TINY : _parni (2);
				/* when too few args */
		a = (PCOUNT < 1) ? TINY : _parni (1);
		/* check for incorrect type */
		if (PCOUNT == 3)
			c = ISNUM (3) ? c : TINY;
		if (PCOUNT > 1)
			b = ISNUM (2) ? b : TINY;
		if (PCOUNT > 0)
			c = ISNUM (1) ? a : TINY;
	}                               /* end else */
	/* Find the biggest one */
	if (a > b)
		if (a > c) {
			_retni (a);     /* a is greatest */
			return;
		}
	if (b > a)
		if (b > c) {
			_retni (b);     /* b is greatest */
			return;
		}
	_retni (c);                     /* c is greatest */
}
