Listing 1


USE Benchmark
go
drop procedure AG_XACT29
go
CREATE PROCEDURE AG_XACT29 (
      /*-------------------------------------------*/
      /*                                           */
      /* TRANSACTION 29: Product by Price Category */
      /*                                           */
      /*-------------------------------------------*/

   @Quantity  int   = NULL,
   @FromPrice money = NULL,
   @ToPrice   money = NULL)

AS BEGIN
   set forceplan on
   
   SELECT   PT.Name, COUNT(*)
   FROM     PricingPolicy PP,ProductTyping T, ProductTypes PT 
   WHERE    PT.ID  = T.ProductTypeID
     AND    T.ProductID  = PP.ProductID
     AND    PP.Quantity  = @Quantity
     AND    (PP.Price BETWEEN @FromPrice AND @ToPrice)
   GROUP BY PT.Name
   ORDER BY 2 DESC
   set forceplan off

END
go
GRANT ALL ON AG_XACT29 TO PUBLIC
go
