*
* ListDir.Prg:  Example of processing a complex multidimensional
*               array with a variable structure.
*
*               Craig Yellick, Alto Microcomputer Inc.
*               7107 Ohms Lane, Minneapolis, MN 55439
*               (612) 835-1080   CompuServe 76247,541
*
*               ListDir.Exe will load the file and subdirectory
*               structure of an entire drive volume and then
*               list the structure to the screen.  Optional
*               parameter allows you to specify the starting
*               subdirectory.  Default is the root directory.
*
*  Examples:    C:\> listdir list entire directory structure
*               C:\> listdir \clip5\    list c:\CLIP5\
*
*               (No error checking is performed on the parameter!)
*
*  Notes:       This program is not so notable for what it DOES
*               but HOW it does it.  There are two functions.
*               LoadDir() loads the specified directory structure
*               and returns a single array that contains the ENTIRE
*               directory structure of any arbitrary drive volume.
*               ListDir() accepts such an array and displays the
*               contents formatted clearly on the screen.  Both
*               functions make use of recursion to cleanly and
*               efficiently perform their tasks.  The code looks
*               amazingly simple -- the mark of elegance!
*
* Compiling:    Compile with the /N option because the source code
*               filename, LISTDIR.PRG, is also the name of a function.
*
* Linking:      Use of a pre-linked library (a "PLL" file) containing
*               at least CLIPPER.LIB and EXTEND.LIB will result in
*               a LISTDIR.EXE of under 10 kb.
*
* Enhancements: This code is BEGGING for you to add file size,
*               date, time and file attributes!
*
*-----------------------------------------------------------------------*
*
*  File Header:  The following are required for compiling the
*                functions found in this source code file.
*

***  IFNIL replaces a long-winded run of three lines of code
*    when testing if a parameter was omitted from a function call
*    and then supplying a default value.
*
*    "IF PARAM = NIL" is the 5.0 way to test for unused parameters,
*    much better than Summer '87's cumbersome IF TYPE("PARAM") = "U"
*    or checking PCOUNT() and keeping track of the parameter order.
*
#command IFNIL <var> := <value>  ;
      => if <var> = nil ; <var> := <value> ; endif

***  This Clipper header file contains #DEFINE commands useful
*    when dealing with the output of the DIRECTORY() function.
*
#include "DIRECTRY.CH"

* end file header
*-----------------------------------------------------------------------*

function Main(path)
*
*  Entry point from DOS.
*

ifnil path := "\"

@ 0,0 clear
? "Loading directory structure"
ListDir(LoadDir(path))

return nil

* end func Main
*-----------------------------------------------------------------------
*
function ListDir(dir_, level)
*
*  Display outer level of a subdirectory and file list
*  in the arrray passed as a parameter.  Optional level
*  number indicates how deep in to consider the "outer" level.
*
*  NOTE: ListDir() calls itself recursively.
*

local i
ifnil level := 0
for i= 1 to len(dir_)
  ? space(level *3)
  if valtype(dir_[i]) = "A"
    ?? dir_[i, 1]
    ?? replicate("-", 15 -len(dir_[i, 1]))
    ListDir(dir_[i, 2], level +1)
  else
    ?? dir_[i]
  endif
next i
return nil

* end func ListDir
*-----------------------------------------------------------------------
*
function LoadDir(path)
*
*  Load DOS files and subdirectories into single multidemensional array.
*  Optional parameter specifies starting subdirectory.
*  Default is root directory.
*  Returns array containing the structure.
*
*  NOTE:  LoadDir() calls itself recursively.
*

local i, name, d_, r_ := {}

ifnil path := "\"
d_ := directory(path +"*.*", "D")

for i = 1 to len(d_)
  name := d_[i, F_NAME]
  if d_[i, F_ATT] = "D"
    if .not. (name $ "..")
      ?? "."
      aadd(r_, {name, LoadDir(path +name +"\")})
    endif
  else
    aadd(r_, name)
  endif
next i

return r_

* end func LoadDir
*-----------------------------------------------------------------------*
* eof ListDir.Prg
*______________________________________________________________

