****************************
*  FUNCTION:      DBEDITLOCK
*  Author:        Diane Lask and Luiz Quintella
*  Date:          July 28, 1989
*  Version:       Clipper Summer '87
*  Note(s):       Lock a DBEDIT() column
****************************

FUNCTION DBEDITLOCK

*       Takes same parameters as DBEDIT

PARAMETERS Top, Left, Bottom, Right, FieldName, Field_Pic, ;
    Heading, Hlines, Vlines, Footlines, Footings

PRIVATE    I, OldRec ,TempName

IF !USED()              && If no Database Return .F.
   RETURN (.F.)
ENDIF

DECLARE NewField[ FCOUNT() - 1 ]

*       Do some parameter range checking

IF TYPE("Top") = 'U'
   Top = 0
ENDIF

IF TYPE("Left") = 'U'
   Left = 25
ENDIF

Left = IIF( LEFT < 25, 25, Left )    && 25 <=  Left <=  54
Left = IIF( Left > 54, 54, Left )

IF TYPE("Bottom") = 'U'
   Bottom = 24
ENDIF

IF TYPE("Right") = 'U'
   Right = 79
ENDIF

Right = IIF( Right < Left, Left + 25, Right)
Right = IIF( Right > 79, 79, Right)

IF TYPE("FieldName") = 'U'
   DECLARE FieldName[ FCOUNT() ]

   FOR I = 1 TO FCOUNT()
      FieldName[ I ] = FIELD(I)
   NEXT
ENDIF

*       Pop off the first field for DBEDIT

FOR I = 1 TO FCOUNT() - 1
   NewField[ I ] = FieldName[ I+1 ]
NEXT

IF TYPE("Heading") = 'U'
   DECLARE Heading[ FCOUNT() - 1 ]

   FOR I = 1 TO FCOUNT() -1
      Heading[ I ] = NewField[ I ]
   NEXT
ENDIF

IF TYPE("Field_Pic") = 'U'
   Field_Pic = .T.
ENDIF

IF TYPE("Hlines") = 'U'
   Hlines = .T.
ENDIF

IF TYPE("Vlines") = 'U'
   Vlines = .T.
ENDIF

IF TYPE("Footlines") = 'U'
   Footlines = .T.
ENDIF

IF TYPE("Footings") = 'U'
   Footings = .T.
ENDIF

LockedField = FieldName[1]        && Define the locked field

*       Draw the 'fake' DBEDIT screen

@ Top + 1, (Left - 25) TO Top + 1 , Left DOUBLE
@ Top + 1, (Left -1) TO Bottom , Left -1
@ TOP , (LEFT -24) SAY LockedField

*       Display the locked column values

OldRec = RECNO()
TempName = FieldName[1]

FOR I = TOP + 2 +IIF( TYPE( 'Footings') = 'U', 2, 0) TO Bottom
   @ I, (Left - 24) SAY &TempName
   SKIP 1
NEXT

GOTO OldRec

DBEDIT( Top, Left, Bottom, Right, NewField, "MYUDF", Field_Pic, ;
        Heading, Hlines, Vlines, Footlines, Footings)

RETURN (.T.)


***********************************************
* FUNCTION :  MYUDF                           *
*             UDF for lockit                  *
*                                             *
* Parameters: Status                          *
* RETURNS   :   0 or 1                        *
***********************************************

FUNCTION MYUDF
PARAMETERS Status

PRIVATE Key, I, OldRec, TempName

Key = LASTKEY()

DO CASE
   CASE Status = 0

        *   Update the locked column if at the
        *   top or bottom of the dbedit or page keys
        *   have been pressed

      IF ( ROW() = Top + 2  .OR.  ROW() = ;
         BOTTOM - IIF( TYPE( 'Footings') = 'U', 2, 0) ) .OR. ;
           Key = 18 .OR.  Key = 3 .OR. Key = 31 .OR. Key = 30
         OldRec = RECNO()

         * Skip back through the database a number of records
         * equal to the number of displayed records in the dbedit

         SKIP - (ROW() - (TOP + 2 + ;
               IIF( TYPE( 'Footings') = 'U' , 2, 0) ) )

         *       Display the locked column values

         TempName = FieldName[1]

         FOR I = TOP + 2 TO Bottom
            @ I, (Left - 24) SAY &TempName
            SKIP 1
         NEXT
         GOTO OldRec
      ENDIF

   CASE Status = 1
      *  YOUR BOTTOM OF FILE HANDLER GOES HERE
      RETURN (1)

   CASE Status = 2
      *  YOUR END OF FILE HANDLER GOES HERE
      RETURN (1)

   CASE Status = 3
      *  YOUR DATABASE EMPTY HANDLER GOES HERE
      RETURN (1)

   CASE STATUS = 4
      IF Key = 27          && Leave DBEDIT IF Esc key pressed
         RETURN (0)
      ENDIF
ENDCASE
RETURN (1)

*   end of code
