*     INKEY() Return Values
* 
* Key		Alone	Shift	Ctrl	Alt
* 
* F1		   28		 84		 94		104
* F2		   -1		 85		 95		105
* F3		   -2		 86		 96		106
* F4		   -3		 87		 97		107
* F5		   -4		 88		 98		108
* F6		   -5		 89		 99		109
* F7		   -6		 90		100		110
* F8		   -7		 91		101		111
* F9		   -8		 92		102		112
* F10 	   -9		 93		103		113
* F11 	  133		135		137		139
* F12 	  134		136		138		140
* 1		   49		 33		  -		120
* 2		   50		 64		 33		121
* 3		   51		 35		  -		122
* 4		   52		 36		  -		123
* 5		   53		 37		  -		124
* 6		   54		 94		 30		125
* 7		   55		 38		  -		126
* 8		   56		 42		  -		127
* 9		   57		 40		  -		128
* 0		   48		 41		  -		 19
* a		   97		 65		  1		 30
* b		   98		 66		  2		 48
* c		   99		 67		  3		 46
* d		  100		 68		  4		 32
* e		  101		 69		  5		 18
* f		  102		 70		  6		 33
* g		  103		 71		  7		 34
* h		  104		 72		127		 35
* i		  105		 73		  9		 23
* j		  106		 74		 10		 36
* k		  107		 75		 11		 37
* l		  108		 76		 12		 38
* m		  109		 77		 13		 50                      
* n		  110		 78		 14		 49
* o		  111		 79		 15		 24
* p		  112		 80		 16		 25
* q		  113		 81		 17		 16
* r		  114		 82		 18		 19
* s		  115		 83		 19		 31
* t		  116		 84		 20		 20
* u		  117		 85		 21		 22
* v		  118		 86		 22		 47
* w		  119		 87		 23		 17
* x		  120		 88		 24		 45
* y		  121		 89		 25		 21
* z		  122		 90		 26		 44
* 
* INS     22		 22		146	 	162  
* HOME     1		  1		 29		151 
* DEL      7		  7		147		163 
* END      6		  6		 23		159 
* PGUP    18		 18		 31		153 
* PGDN     3		 51		 30		161 
* UP	      5		  5		141 	152 
* RIGHT    4		  4		  2		157 
* LEFT	   19		 19		 26		155 
* DOWN	   24		 24		145		160 
* ESCAPE  27		 27		 27		  1 
* ENTER   13		 13		 10		 28 
* BSPACE 127		127		127		 14 
* TAB      9		 15		148	 	165 


* This routine will KEYBOARD the key that is paased to it as a number.
* Be aware that not all keys have unique values therefore this will not
* work with some keys.
*
* A good example is HOME, SHIFT+HOME, and ALT+ENTER all return the same
* value through INKEY().
*

FUNCTION _Keytest
PARA nKeyPress
DO CASE
   CASE nKeyPress > 0 .AND. nKeyPress <= 127
     KEYBOARD CHR(nKeyPress)
   CASE nkeyPress = 28
     KEYBOARD "{F1}"
   CASE nkeyPress = -1
     KEYBOARD "{F2}"
   CASE nkeyPress = -2
     KEYBOARD "{F3}"
   CASE nkeyPress = -3
     KEYBOARD "{F4}"
   CASE nkeyPress = -4
     KEYBOARD "{F5}"
   CASE nkeyPress = -5
     KEYBOARD "{F6}"
   CASE nkeyPress = -6
     KEYBOARD "{F7}"
   CASE nkeyPress = -7
     KEYBOARD "{F8}"
   CASE nkeyPress = -8
     KEYBOARD "{F9}"
   CASE nkeyPress = -9
     KEYBOARD "{F10}"
   CASE nkeyPress = 133
     KEYBOARD "{F11}"
   CASE nkeyPress = 135
     KEYBOARD "{SHIFT+F11}"
   CASE nkeyPress = 137
     KEYBOARD "{CTRL+F11}"
   CASE nkeyPress = 139
     KEYBOARD "{ALT+F11}"
   CASE nkeyPress = 134
     KEYBOARD "{F12}"
   CASE nkeyPress = 136
     KEYBOARD "{SHIFT+F12}"
   CASE nkeyPress = 138
     KEYBOARD "{CTRL+F12}"
   CASE nkeyPress = 140
     KEYBOARD "{ALT+F12}"
   CASE nkeyPress = 141
     KEYBOARD "{CTRL+UPARROW}"
   CASE nkeyPress = 145
     KEYBOARD "{CTRL+DOWNARROW}"
   CASE nkeyPress = 146
     KEYBOARD "{CTRL+INS}"
   CASE nkeyPress = 147
     KEYBOARD "{CTRL+DEL}"
   CASE nkeyPress = 148
     KEYBOARD "{CTRL+TAB}"
   CASE nkeyPress = 151
     KEYBOARD "{ALT+HOME}"
   CASE nkeyPress = 152
     KEYBOARD "{ALT+UPARROW}"   
   CASE nkeyPress = 153
     KEYBOARD "{ALT+PGUP}"
   CASE nkeyPress = 155
     KEYBOARD "{ALT+LEFTARROW}"     
   CASE nkeyPress = 157
     KEYBOARD "{ALT+RIGHTARROW}"
   CASE nkeyPress = 159
     KEYBOARD "{ALT+END}"
   CASE nkeyPress = 160
     KEYBOARD "{ALT+DOWNARROW}"
   CASE nkeyPress = 161
     KEYBOARD "{ALT+PGDN}"
   CASE nkeyPress = 162
     KEYBOARD "{ALT+INS}"
   CASE nkeyPress = 163
     KEYBOARD "{ALT+DEL}"                       
   CASE nkeyPress = 165
     KEYBOARD "{ALT+TAB}"
ENDCASE



