/* *************************************************************
    copyright (c) 1988 ken lombardi
    al dente systems  (206) 884-9672
    12204 143rd ave ct kpn
    gig harbor, washington 98335

    There are no warranties.
    If you use the code or the executable file send
    $15.00 to al dente systems above...
    This cannot be resold.
    Please feel free to distribute these four files
    together...not seperated.
	SAMPLE.TXT
	DBINFO.C
	DBINFO.EXE
	DBREAD.ME

    you must link with setargv.obj in order to be able to
    expand the command line argument wildcards...which
    is what really makes this program useful...to be able
    to print the structure of a group of database files
    from dos with :
	    C:\dbfiles>dbinfo *.dbf > prn
    or redirect into a file that you can open with your
    favorite word processor
	    C:dbinfo *.dbf > struct.txt

    compiled with msc 5.1
    cl /F 2000 dbinfo.c

    the /F 2000 is needed to increase the stack space...

    dbase III file header :
  +-------+-------------+-----------------------------------+
  | byte  |  contents	|   meaning			    |
  +-------+-------------+-----------------------------------+
  | 0	  |  1 byte	|   version number		    |
  +-------+-------------+-----------------------------------+
  | 1-3   |  3 bytes	|   date of last update (yy mm dd)  |
  +-------+-------------+-----------------------------------+
  | 4-7   |  32bit num	|   recs in file		    |
  +-------+-------------+-----------------------------------+
  | 8-9   |  int	|   length of header		    |
  +-------+-------------+-----------------------------------+
  | 10-11 |  int	|   length of record		    |
  +-------+-------------+-----------------------------------+
  | 12-31 |  20 bytes	|   reserved?			    |
  +-------+-------------+-----------------------------------+
  | 32-?  |  32 byte ea |   field descriptor array	    |
  +-------+-------------+-----------------------------------+
  | ?+1   |  1 Byte	|   0DH field terminator	    |
  +-------+-------------+-----------------------------------+

    field descriptor array :
  +-------+-------------+-----------------------------------+
  | byte  |  contents	|   meaning			    |
  +-------+-------------+-----------------------------------+
  | 0-10  |  11 bytes	|   field name in ascii/0 filled    |
  +-------+-------------+-----------------------------------+
  | 11	  |  1 byte	|   field type in ascii (c,n,l,d,m) |
  +-------+-------------+-----------------------------------+
  | 12-15 |  32 bit num |   field data address set in mem   |
  +-------+-------------+-----------------------------------+
  | 16	  |  1 byte	|   field length		    |
  +-------+-------------+-----------------------------------+
  | 17	  |  1 byte	|   field decimal count 	    |
  +-------+-------------+-----------------------------------+
  | 18-31 |  14 bytes	|   reserved bytes		    |
  +-------+-------------+-----------------------------------+

    the purpose of this utility is to read a dbase file and print
    the basic information about its structure...field names,types
    sizes...etc
    We will open a dbf file for read only and then read the file
    into a buffer which is then placed into the appropriate
    structures and printed.

** ************************************************************ */


#include <stdio.h>
#include <dos.h>
#include <ctype.h>

#define PROGNAME "dbinfo.exe  ver 1.0"
#define RSIZE 32	/* each thing to read is 32 bytes in size movedata */
#define HSIZE 4161	/* the max header size to read +1 */
			/* dBase III ((128 fields * 32bytes) + 64 bytes + 1) */

FILE *read_fp;
char *dbfname ;

/* the structure to contain the formatted date from the header file */
struct the {
    char year ;
    char month ;
    char day ;
    } ;
struct the date ;

/* the header struct itself... */
struct db {
    char    ver ;
    struct the date ;
    unsigned long recs ;
    unsigned lgh_hdr ;
    unsigned lgh_rec ;
    char reserved[20] ;
    } ;
struct db hdr ;

/* the field descriptor structure array */
struct desc {
    char name[11] ;
    char type ;
    unsigned long addr ;
    unsigned char lgh_fld ;
    unsigned char dec ;
    char more_res[14] ;
	} ;

struct desc fields[128] ;







void inp_name(char *thename)
{

	bdos(9,
"...........................................................\r\n\
Usage........dbinfo <filename>\r\n\
filename.....the file to read...path names/wildcards are ok!\r\n\
	     Example :C>dbinfo this.dbf\r\n\
		  or :C>dbinfo \\database\\that.dbf\r\n\
		  or :C>dbinfo *.dbf\r\n\
...........................................................\r\n\
al dente systems (206) 884-9672\r\n\n\
	Now please enter filename : $ ",0) ;
	gets(thename) ;
	if( ! isgraph(*thename) ) {
		printf("\n Improper File Name. Please try again.\n\n") ;
		exit(3) ;
	}
}	


chk_file( )
{
  char buf[HSIZE] ;
  struct SREGS reg ;	/* for segread to get seg register values */

    fread(buf,RSIZE,HSIZE,read_fp) ;
    /* need to get the address of the current data segment reg.ds */
    segread(&reg) ;
    /* this moves the header info into the header structure */
    movedata(reg.ds,buf,reg.ds,&hdr,RSIZE) ;
    /* notice the use of the value for header length that we got one line up */
    /* add 32 to buf to move past the actual header info into the field desc */
    movedata(reg.ds,buf+32 ,reg.ds,&fields[0],hdr.lgh_hdr ) ;
    return ;
 }

pr_data()
{
  int i=0 ;
  unsigned ans ;
    printf("\n\n") ;
    printf("Database Name       : %s\n",dbfname) ;
    printf("dBase ver. number   : %d\n",(int)hdr.ver) ;
    printf("Date of last update : %d.%d.%d\n",hdr.date.month,hdr.date.day,hdr.date.year) ;
    printf("Number of records   : %lu\n",hdr.recs) ;
    printf("Length of Header    : %u\n",hdr.lgh_hdr) ;
    printf("Length of record    : %u\n",hdr.lgh_rec) ;
    /* subtract 33 from the length of the header and divide by 32   */
    /* the 33 = 32 for header info and 1 for the end of header 0x0D */
    /* divide by 32 because each field descriptor array = 32 bytes  */
    ans = (hdr.lgh_hdr-33)/32 ;
    printf("Number of fields    : %d\n\n",ans) ;
    printf("  Field Name     Type    Length  Decimal\n");
    printf("=========================================\n") ;
    while( i < ans) {
	printf(" %-3d: %-11s  %-2c      %-3d      %d\n",i+1,fields[i].name,fields[i].type,(int)fields[i].lgh_fld,(int)fields[i].dec) ;
	i++ ;
	}
}


main(int argc,char *argv[])
{
int i =0 ;

	printf("(c)Copyright 1988.  Ken Lombardi   %s\n",PROGNAME) ;
	printf("   .....The Header Reader.....      \n") ;
	if (argc == 1)
	     inp_name(*argv) ;
	for(i=1; argc-- > 1; i++) {
	    dbfname = argv[i] ;
	    if ((read_fp = fopen(argv[i], "rb")) == NULL ) {
		printf("\nSorry, %s can't seem to open %s...\n",PROGNAME, argv[i]);
		printf("Please check the filename and path name.\n");
		exit(1);
	    }

	    chk_file()	;
	    pr_data() ;
	    if( fclose( read_fp ) != 0) {
		fprintf(stderr,"%s: error closing %s",PROGNAME,argv[i]) ;
		exit(4) ;
		}
	}
	exit(0) ;
}	/* end function MAIN */
