*:*********************************************************************
*:
*:        Program: TOOLS.PRG
*:
*:         System: Debug Tools
*:         Author: Peter G. Hansen
*:      Copyright (c) 1989, Peter G. Hansen
*:  Last modified: 11/28/89     14:29
*:
*:  Procs & Fncts: VIEWDB()
*:               : WHICH_REC()
*:               : VIEWPRG()
*:
*:     Documented: 11/28/89 at 14:30                SNAP! version 3.10
*:*********************************************************************
*!*********************************************************************
*!
*!       Function: VIEWDB()
*!
*!*********************************************************************
FUNCTION viewdb
fixcolor=setcolor()			&& save screen color
vtempscr=savescreen(8,1,23,79)		&& save the screen
DECLARE logfiles[adir("*.dbf")]		&& array of DBF files for ACHOICE
box_size=adir("*.dbf",logfiles)		&& how many are there?
IF box_size>13				&& box auto-sizes
   b_line=22
ELSE
   b_line=9+box_size
ENDIF
SET COLOR TO B/W,W/B
dbfbox=savescreen(8,14,b_line,28)	&& save another part of the screen
@ 8,14,b_line,28 BOX "Ŀ "
@ 8,15 SAY " Data Files "
mfilenum=achoice(9,15,21,27,logfiles)	&& ACHOICE call with list of files
IF mfilenum=0 .OR. LASTKEY()=27		&& user wants out...
   RETURN .F.		
ENDIF	
mfilename2=logfiles[mfilenum]		&& selected file name
mfilename=LEFT(mfilename2,LEN(TRIM(mfilename2))-4)	&& just the first 8 characters, please
restscreen(8,14,b_line,28,dbfbox)	&& restore the screen
Ntxs=adir("*.ntx")			&& list of index files
DECLARE logfiles[ntxs+1]		&& same as above
box_size=adir("*.ntx",logfiles)
logfiles[ntxs+1]="None"
IF box_size>13
   b_line=22
ELSE
   b_line=9+box_size
ENDIF
SET COLOR TO B/W,W/B
@ 8,14,b_line,28 BOX "Ŀ "
@ 8,15 SAY " Index Files "
mfilenumn=achoice(9,15,21,27,logfiles)
IF mfilenumn=0 .OR. LASTKEY()=27
   RETURN .F.		
ENDIF	
IF mfilenumn=Ntxs+1
   mfilenamn2=""
ELSE
   mfilenamn2=logfiles[mfilenumn]
ENDIF
mfilenamn=LEFT(mfilenamn2,LEN(TRIM(mfilenamn2))-4)
artifax=opendbf(mfilename,mfilenamn)		&& OPENDBF opens file
rex=lastrec()
IF rex>11
   last_line=22
ELSE
   last_line=10+rex
ENDIF
@ 8,2 CLEAR TO last_line+1,78
@ 8,1,last_line+1,79 BOX "ͻȺ "
@ 8, 3 SAY " "+Alltrim(mfilename2)+" "
@ last_line+1,3 SAY "Index Key: "+indexkey(0)+" "
dummy=""
dbedit(9,2,last_line,78,dummy,"which_rec")
closedbf(artifax,mfilename)			&& CLOSEDBF closes file
restscreen(8,1,23,79,vtempscr)
SET COLOR TO &fixcolor.
RETURN .T.

*!*********************************************************************
*!
*!       Function: WHICH_REC()
*!
*!*********************************************************************
FUNCTION which_rec
PARA STATUS,xfld_ptr
DO CASE
CASE LASTKEY()=27
   RETURN 0
OTHERWISE
   @ 8,20 SAY " Record # "+Alltrim(STR(RECNO(),6,0))+" of "+Alltrim(STR(lastrec(),6,0))+" "
   RETURN 1
ENDCASE

*!*********************************************************************
*!
*!       Function: VIEWPRG()
*!
*!*********************************************************************
FUNCTION viewprg
fixcolor=setcolor()
vtempscr=savescreen(8,1,23,79)
DECLARE logfiles[adir("*.prg")]
box_size=adir("*.prg",logfiles)
b_line=22
SET COLOR TO B/W,W/B
@ 8,14,b_line,28 BOX "Ŀ "
@ 8,16 SAY " PRG Files "
mfilenum=achoice(9,15,22,27,logfiles)
IF mfilenum=0 .OR. LASTKEY()=27
   RETURN .F.		
ENDIF	
mfilename2=logfiles[mfilenum]
mfilename=LEFT(mfilename2,LEN(TRIM(mfilename2))-4)

** open the ASCII file and read the contents into a memo field
Buffer=MEMOREAD(mfilename2)
@ 8,2 CLEAR TO 24,79
@ 8,1,24,79 BOX "ͻȺ "
@ 8, 3 SAY " "+Alltrim(mfilename2)+" "
SET COLOR TO N/W
SET Cursor ON
MEMOEDIT(Buffer,9,2,23,78)
SET Cursor OFF
RETURN .T.

*!*********************************************************************
*!
*!       Function: OPENDBF()
*!
*!           Uses: &F_ALIAS       
*!
*!        Indexes: &F_INDEX
*!
*!*********************************************************************
FUNCTION opendbf
PARA f_alias, f_index
** is it open?
itsopen=.F.
FOR X=1 TO 10
   IF LEN(TRIM(ALIAS(X)))=0	&& no more aliases, exit
      EXIT
   ENDIF
   IF UPPER(TRIM(f_alias))=UPPER(TRIM(ALIAS(X)))	&& it's open
      itsopen=.T.
      EXIT
   ENDIF
NEXT

** if it's not already open
IF itsopen
   ** if it's already open
   RETURN RECNO()
ELSE
   SELECT 0
   USE &f_alias.
   IF LEN(TRIM(f_index))>0
      SET INDEX TO &f_index.
   ENDIF
   RETURN 0
ENDIF


*!*********************************************************************
*!
*!       Function: CLOSEDBF()
*!
*!*********************************************************************
FUNCTION closedbf
PARA rekno, f_alias
IF rekno=0
   SELECT &f_alias.	
   USE
   RETURN .T.
ELSE
   ** restore record pointer
   SELECT &f_alias.
   GO rekno
ENDIF
RETURN .T.



*: EOF: TOOLS.PRG

