/*-------------------------------------------------------------------*
 | DBF.H  -  dBase III and Clipper file definitions                  |
 |                                                                   |
 | R.Trevithick - Sun  11-13-1988                                    |
 *-------------------------------------------------------------------*/

#define NORM_DBF    0x03                /* ID of .dbf file w/o memo */
#define MEMO_DBF    0x83                /* ID of .dbf file w/ memo  */
#define CLIP_NXF    0x06                /* ID of Clipper index file */
#define DBF_ATTR    0x27                /* all files except dir and label */



struct dbf_header {
    unsigned char   id_byte;            /* version; high bit if memo */
    signed char     year,               /* dbase's revision date.  Not  */
                    month,              /*  necessarily the same as the */
                    day;                /*  DOS revision date. */
    unsigned long   num_recs;           /* number of records in file */
    unsigned int    header_len,         /* size of the header */
                    record_len;         /* size of each record */
    unsigned char   reserved[20];       /* reserved bytes */
};



struct dbf_record {
    unsigned char   field_name[11],     /* field name */
                    data_type;          /* C,N,L,D,M */
    unsigned long   data_addr;          /* field data address */
    unsigned char   field_length,       /* field length */
                    decimals,           /* field decimal count */
                    reserved[14];       /* reserved bytes */
};



struct ndx_header {
    unsigned char   id_bytes[4],        /* sure wish I had docs */
                    dummy1[8],
                    db_klen,            /* length of dBase key */
                    dummy2[1],
                    clip_klen,          /* length of Clipper key */
                    dummy3[7],
                    clip_key[2],        /* Clipper ascii key starts here */
                    db_key[255];        /* dBase's starts here */
};

