/**************************************************************************
 * DBFTOOLS.C       by Dave Gordon        Version 1.0           1/27/90   *
 *                                                                        *
 * DBFTOOLS.EXE is a comprehensive "tool kit" for .DBF files. It can      *
 * pack, zap or index a file specified on the command line. If no file    *
 * is specified, the program exits with an error message. If the file     *
 * can't be found, it also exits with an error message. The program uses  *
 * the Code Base 4 library.                                               *
 *                                                                        *
 * Compile with: tcc -Lc:\lib -Ic:\include -ml -N -DTURBO dbftools t4.lib *
 *                                                                        *
 * Copyright 1990 by David A. Gordon, all rights reserved.                *
 * Contact at: 5580 Hollins Lane, Burke, VA 22015.                        *
 *                                                                        *
 * Released as "Freeware" for all to use and enjoy, but no warranty is    *
 * given as to the usefulness or safety of this program. David A. Gordon  *
 * will not be held liable for any damages, losses or incidental problems *
 * suffered by anyone using this program. "Use at your own risk." While   *
 * every effort has been made to ensure the program is safe to use as     *
 * directed, it is intrinsically powerful ( and potentially dangerous ).  *
 *                                                                        *
 **************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <d4base.h>
#include <ctype.h>

extern unsigned _stklen = 10000 ;         /* increase stack size to 10,000 */
void syntax_error() ;


main(int argc, char* argv[])
{
int func = 0 ;

   printf("Copyright 1990 by Dave Gordon, all rights reserved") ;

   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
   /* The following section of code checks out the command line parameters.
      The first command line parameter must be one of the function keywords.
      The second command line parameter must be a usable .DBF file. If the 
      "index" function is selected, there must be 2 additional command line 
      parameters. Any functions to be added in the future need to be 
      reflected here.                                                     */

   if (argc < 3) {      /* check for at least two command line parameters */
	syntax_error() ;
	exit(1) ;
	} 

   if (!stricmp(argv[1], "zap"))                                   /* zap */
	func = 1 ;
   if (!stricmp(argv[1], "pack"))                                 /* pack */
	func = 2 ;
   if (!stricmp(argv[1], "index") && argc == 5)                  /* index */
	func = 3 ;
   if (func == 0) {                                             /* errors */
	syntax_error() ;
	exit(1) ;
	}      

   if (d4use_excl(argv[2]) == -1) {                       /* file usable? */
	printf("\nError opening file!\n") ;
	exit(1) ;
	}           
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    /* This section of code asks the user for verification of intent. If   
       the user does not respond with a 'y', the program terminates.       */

    printf("\nFile %s has %x records.", argv[2], d4reccount()) ;
    printf("\nAre you SURE you want to %s it? ", argv[1]) ;

    if (tolower(getchar()) == 'y') {       /* get user response from stdin */
	switch (func) {

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    /* These are the actual functions, the part that does the real work!   */

	    case 1 : d4zap(1L, d4reccount()) ;                      /* zap */
		     printf("\nDone! %s is now empty", argv[2]) ;
		     break ;

	    case 2 : d4pack() ;                                    /* pack */
	             printf("\nDone! %s now has %x records.\n", argv[2], d4reccount()) ;
		     break ;

								  /* index */
	    case 3 : printf("\nIndexing %s on %s to %s ....", argv[2], argv[3], argv[4]) ;
		     if (i4index(argv[4], argv[3], 0, 0) == -1) {
			 printf("\nIndexing file error!") ;
			 exit(1) ;
			 } /* endif */
		     else
			 printf("\nDone!") ;
		     break ;

            } /* end switch */
	} /* endif, and end of the functional part ..... */

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

   d4close_all() ;
   printf("\n") ;
   exit(0) ;

} /* end of main() */

/**************************************************************************/

void syntax_error()  /* Help screen function .... */
{

   printf("\nUsage:  dbftools  ZAP    filename\n") ;
   printf("OR:     dbftools  PACK   filename\n") ;
   printf("OR:     dbftools  INDEX  filename  expression  indexfile\n") ;

} /* end of syntax_error() */

/**************************************************************************/

/* Another fine Ozone production... */
