*\////////////////////////////////////////////////////*
*\                                                   /*
*\   TESTDBFS.PRG                                    /*
*\                                                   /*
*\   Written by Larry Bauder  CIS 71320,2707         /*
*\   Released to the Public Domain   11-20-88        /*
*\   I hope someone will find the concept useful.    /*
*\---------------------------------------------------/*
*\   Compile with CLIPPER Summer 87  2:00 am Version /*
*\---------------------------------------------------/*
*\   IMPORTANT:  Run this DEMO before running        /* 
*\               MAKEDBFS.  This file is set up      /* 
*\               to work with the DBFS.DBF file      /*
*\               supplied with this demo.            /*
*\                                                   /*
*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\/*

priv ns,max,this_file

max = 10
priv if_dbf[max]

* To test your own DBFS file, change the following file
* names to match your application.

if_dbf[1] = "EMPLOYEE"
if_dbf[2] = "CLIENTS"
if_dbf[3] = "STOCK"
if_dbf[4] = "BACKORDR"
if_dbf[5] = "ONORDER"
if_dbf[6] = "HISTORY"
if_dbf[7] = "TEMP1"
if_dbf[8] = "TEMP2"
if_dbf[9] = "TEMP3"
if_dbf[10]= "TEMP4"
* etc.

clear
centerme('File Checkup',21)
for ns = 1 to max
  this_file = if_dbf[ns]
  IF .NOT. FILE('&this_file..DBF')
    centerme(space(30),22)
    centerme('Making &this_file..DBF',22)
    created = creater("&this_file.")
    if .not. created
       centerme('File missing.  Call the programmer.  Error with DBFS',22)
       quit
    endif
  ENDIF
next


*-------------------------
func centerme
*-------------------------
para c_string,c_line
length = len(c_string)
@ c_line, 40-int(length/2) say c_string
return("")


*-------------------------
func creater
*-------------------------
* written 3-19-88 by Larry Bauder
* creates a dbf file 
*
* Last modified: 7-14-88 to look for dbfsndx.ndx
*
* To modify a file's structure, append a record to DBFS.dbf
*   that includes all of the usual from a COPY TO EXTE command
*   plus FILE_NAME,FIELD_NUM and TOTAL_FLDS (C8,C2,C2 resp.)
* A companion utility, MAKEDBFS, will scan a directory and 
*   include all dbf's it finds in DBFS.dbf
*
* CAUTION: The following activity occurs in the current work area,
*          so change to an open area before calling creater().
*
*          Also, if the file to be created already exists, make sure
*          it is closed!
*
PARA file_n
priv f_flag,max,n

file_n = UPPER(file_n)

* note the parameter passed should NOT include an extension
IF AT(".",file_n) > 0
  file_n = SUBSTR(file_n,1,AT(".",file_n)-1)
ENDIF
IF .NOT. FILE("DBFS.DBF")
  f_flag = .F.
  RETURN (f_flag)
ENDIF  
* creates very temporary dbf 
CREATE t_temp

IF FILE('DBFSNDX.NDX')
  USE dbfs INDEX dbfsndx
ELSE
  USE dbfs
  INDEX ON file_name + field_num TO dbfsndx
ENDIF
SEEK file_n 
IF FOUND()
  MAX = total_flds
  * set up the arrays for temporary storage
  declare field_n[max], type_f[max], width[max], dec[max]
  *  fill the arrays
  FOR N = 1 TO MAX
    field_n[n] = field_name
    type_f[n] = field_type
    width[n]= field_len
    dec[n]  = field_dec
    SKIP
  NEXT
  * dbfs.dbf closed here
  USE t_temp
  * transfer the arrays to the EXTENDED file
  FOR N = 1 TO MAX
    APPEND BLANK
    REPL field_name WITH field_n[n],field_type WITH type_f[n],;
      field_len WITH width[n],field_dec WITH dec[n]
  NEXT
  * create the requested file from the EXTENDED file
  USE
  CREATE &file_n. FROM t_temp
  * clean up
  ERASE t_temp.dbf
  * check if file created okay
  IF FILE("&file_n..DBF")
    f_flag = .T.
  ELSE
    f_flag = .F.
  ENDIF
ELSE
  * filename not found in DBFS.dbf
  f_flag = .F.
ENDIF
RETURN(f_flag)
