;-----------------------------------------------------------------------------
;  Program file..: DBFORMAT.asm
;  Author........: Paolo Ramozzi
;  Date..........: 06/14/89
;  Used by.......: Clipper, Summer '87
;  Function......: Format diskette 360Kb to 1.44Kb.
;  Compile ......: Microsoft MASM 5.0 : MASM dbformat;
;
;  Syntax .......: status = DBFORMAT ( drive, mode )
;
;                  where: drive = 0 - Drive A:
;                         drive = 1 - Drive B:
;
;                         mode  = 1 - 360Kb
;                         mode  = 2 - 720Kb
;                         mode  = 3 - 1.2Kb
;                         mode  = 4 - 1.44Kb
;
;                  Function returns 0 on successfull operation or
;                  -1 if any error occurs.
;
;----------------------------------------------------------------------------

public  DBFORMAT

extrn   __parni:far
extrn   __parinfo:far
extrn   __retni:far

dgroup  group   datasg

datasg  segment public  'DATA'

fdrive          db      0
fmode           dw      0
fmt_max         db      0
ftrack          db      0
fhead           db      0
dskbas          db      0
fmt_table       db      72 DUP (0)
boot_sect       db      0EBh,03Eh,090h
                db      'DBFORMAT'
                db      000h,002h,002h,001h,000h,002h,070h,000h
                db      0D0h,002h,0FDh,002h,000h,009h,000h,002h
                db      36 DUP (0)
                db      090h,0FAh,0B8h,030h,000h,08Eh,0D0h,0BCh
                db      0FCh,000h,0FBh,00Eh,01Fh,0BBh,007h,000h
                db      0BEh,076h,07Ch,090h,08Ah,004h,046h,03Ch
                db      000h,074h,008h,0B4h,00Eh,056h,0CDh,010h
                db      05Eh,0EBh,0F1h,0B4h,001h,0CDh,016h,074h
                db      006h,0B4h,000h,0CDh,016h,0EBh,0F4h,0B4h
                db      000h,0CDh,016h,033h,0D2h,0CDh,019h
                db      13,10,"WARNING: THIS DISK CAN'T BOOT."
                db      13,10,10,"To make it bootable use DOS command SYS <drive:>"
                db      13,10,"or format with DOS FORMAT <drive:> /S command."
                db      13,10,10,"Change disk and strike any key .......",13,10,10,10
                db      510-($-boot_sect) DUP(0)
                db      055h,0AAh
fat_sect        db      3   DUP (0)
zero_sect       db      512 DUP (0)

datasg  ends


_prog   segment 'CODE'
        assume  cs:_prog,ds:dgroup,es:dgroup,ss:nothing




DBFORMAT        proc    far

                push    bp                           ; preserve BP reg
                mov     bp,sp                        ; BP point to stack
                push    ds                           ; must save regs
                push    es                           ;
                push    si                           ;
                push    di                           ;


                xor     ax,ax                        ; get # of parameters
                push    ax                           ;
                call    __parinfo                    ; call information function
                add     sp,2                         ; fix up the stack
                cmp     al,2                         ; # of parameters = 2
                je      GetDrive                     ; Yes. Get 1st
                jmp     Ferror                       ; No. Return Error
GetDrive:
                mov     ax,1                         ; get 1st parameter (drive)
                push    ax                           ;
                call    __parni                      ; must be an integer
                add     sp,2                         ; fix up the stack
                cmp     al,0                         ; drive A ?
                jz      GetMode                      ; Ok.
                cmp     al,1                         ; drve B ?
                jz      GetMode                      ; Ok.
                jmp     Ferror                       ; Invalid drive

GetMode:
                mov     fdrive,al                    ; save drive number
                mov     ax,2                         ; get 2nd parameter
                push    ax                           ;
                call    __parni                      ; must be an integer
                add     sp,2                         ; fix up the stack
                mov     fmode,2709h                  ; assume mode = 1
                mov     fmt_max,27h                  ; 360 Kb
                cmp     al,1                         ; format 360Kb ?
                je      ParamOk                      ; Ok. Do it
                mov     fmode,4F09h                  ; assume mode = 2
                mov     fmt_max,4Fh                  ; 720 Kb
                cmp     al,2                         ; format 720Kb ?
                je      ParamOk                      ; Ok. Do it
                mov     fmode,4F0Fh                  ; assume mode = 3
                mov     fmt_max,4Fh                  ; 1.2 Mb
                cmp     al,3                         ; format 1.2Mb ?
                je      ParamOk                      ; Ok. Do it
                mov     fmode,4F12h                  ; assume mode = 4
                mov     fmt_max,4Fh                  ; 1.44 Mb
                cmp     al,4                         ; format 1.44Mb ?
                je      ParamOk                      ; Ok. Do it
                jmp     Ferror                       ; bad format request
ParamOk:
                mov     ax,dgroup                    ; Data Segment
                mov     es,ax                        ; in ES register
                push    es                           ; preserve
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS
                mov     ah,8                         ; read drive parameters
                mov     dl,fdrive                    ; drive #
                int     13h                          ; call BIOS
                mov     ah,18h                       ; set media type format
                mov     dl,fdrive                    ; drive #
                mov     cx,fmode                     ; format mode
                int     13h                          ; call BIOS
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS
                pop     es                           ; restore
                clc                                  ; clear carry flag

FmtPrep:
                call    Set_DskBas                   ; disk_base parameters
                mov     bx,OFFSET dgroup:fmt_table   ; offset to fmt table
                mov     ftrack,0                     ; track 0
                mov     fhead,0                      ; head 0
Fmt_Loop:
                mov     dh,fhead                     ; head #
                mov     dl,fdrive                    ; drive #
                mov     ch,ftrack                    ; track #
                mov     cl,0                         ; not used
                call    Table_Prep                   ; prepare for track format
                mov     ax,fmode                     ; # of sectors in AL
                mov     ah,5                         ; format function
                call    Bios_Int                     ; call BIOS
                jnc     Fmt_Next                     ; Ok. Format next track
                jmp     Ferror                       ; error on format track
Fmt_Next:
                cmp     fhead,1                      ; last head = 1 ?
                je      New_Track                    ; Yes. Change track
                mov     fhead,1                      ; No. Format head 1
                jmp     Fmt_Loop                     ; format loop
New_Track:
                inc     ftrack                       ; track counter
                mov     ah,ftrack                    ; in AH
                cmp     ah,fmt_max                   ; last track ?
                ja      Fmt_End                      ; Yes. Done format
                mov     fhead,0                      ; No. Continue
                jmp     Fmt_Loop                     ;
Fmt_End:
                call    Write_Boot                   ; Write boot sector
                jc      Ferror                       ; exit on error
                call    Write_Fat                    ; Write fat sectors
                jc      Ferror                       ; exit on error
                call    Write_Root                   ; Write root directory
                jc      Ferror                       ; exit on error
                xor     ax,ax                        ; clear return value
                jmp     Exit                         ; Done.

Ferror:
                mov     ax,-1                        ; error return

Exit:
                call    Reset_DskBas                 ; reset disk_base
                push     ax                          ; push return value
                call     __retni                     ; and return it to CLIPPER
                add      sp,2                        ; fix up the stack

                pop     di                           ; restore regs
                pop     si                           ;
                pop     es                           ;
                pop     ds                           ;
                pop     bp                           ;
                ret                                  ; far return to CLIPPER

DBFORMAT        endp

;-----------------------------------------------------------;
; Local subroutine - update format parameter table          ;
;-----------------------------------------------------------;

Table_Prep      proc    near

                push    di                           ; save regs
                push    cx                           ;
                push    ax                           ;
                mov     di,bx                        ; offset table in DI
                mov     cx,fmode                     ; # of sector
                and     cx,00FFh                     ; in CX
                xor     ax,ax                        ; clear AX
                cld                                  ; clear direction flag
Prep_Loop:
                mov     al,ftrack                    ; store track #
                stosb                                ;
                mov     al,fhead                     ; store head #
                stosb                                ;
                inc     ah                           ; store sector #
                mov     al,ah                        ;
                stosb                                ;
                mov     al,2                         ; store format mode
                stosb                                ; (2 = 512 bytes/sector)
                loop    Prep_Loop                    ; for all sectors

                pop     ax                           ; restore regs
                pop     cx
                pop     di
                ret                                  ; near return

Table_Prep      endp

;-----------------------------------------------------------;
; Local subroutine - call BIOS Int 13 for r/w sector        ;
;-----------------------------------------------------------;

Bios_Int        proc    near
                push    bx                           ; save regs
                push    es                           ;
                push    ax                           ;
                int     13h                          ; call BIOS (read sector)
                jnc     Bios_Ret                     ; Read ok. Exit
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS
                pop     ax                           ; restore regs
                pop     es                           ; for retry
                push    es                           ; save regs
                push    ax                           ;
                int     13h                          ; call BIOS (read sector)
                jnc     Bios_Ret                     ; Read ok. Exit
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS
                pop     ax                           ; restore regs
                pop     es                           ; for retry
                push    es                           ; save regs
                push    ax                           ;
                int     13h                          ; call BIOS (read sector)
Bios_Ret:       pop     bx                           ; restore regs
                pop     es                           ;
                pop     bx                           ;
                ret                                  ; near return

Bios_Int        endp

;-----------------------------------------------------------;
; Local subroutine - write boot sector                      ;
;-----------------------------------------------------------;

Write_Boot      proc    near

                push    di                           ; preserve
                mov     di,OFFSET dgroup:boot_sect   ; buffer address
                mov     ax,fmode                     ; fmt mode
Boot1:
                cmp     ax,2709h                     ; 360Kb ?
                jne     Boot2                        ; No.
                mov     BYTE PTR[di+00Dh],002h       ; Yes.
                mov     BYTE PTR[di+011h],070h       ; Fill
                mov     WORD PTR[di+013h],02D0h      ; buffer
                mov     BYTE PTR[di+015h],0FDh       ; area
                mov     BYTE PTR[di+016h],002h       ;
                mov     BYTE PTR[di+018h],009h       ;
                jmp     Boot_Ok                      ; Done.
Boot2:
                cmp     ax,4F09h                     ; 720Kb ?
                jne     Boot3                        ; No.
                mov     BYTE PTR[di+00Dh],002h       ; Yes.
                mov     BYTE PTR[di+011h],070h       ; Fill
                mov     WORD PTR[di+013h],05A0h      ; buffer
                mov     BYTE PTR[di+015h],0F9h       ; area
                mov     BYTE PTR[di+016h],003h       ;
                mov     BYTE PTR[di+018h],009h       ;
                jmp     Boot_Ok                      ; Done.
Boot3:
                cmp     ax,4F0Fh                     ; 1.2Mb ?
                jne     Boot4                        ; No.
                mov     BYTE PTR[di+00Dh],001h       ; Yes.
                mov     BYTE PTR[di+011h],0E0h       ; Fill
                mov     WORD PTR[di+013h],0960h      ; buffer
                mov     BYTE PTR[di+015h],0F9h       ; area
                mov     BYTE PTR[di+016h],007h       ;
                mov     BYTE PTR[di+018h],00Fh       ;
                jmp     Boot_Ok                      ; Done.
Boot4:
                mov     BYTE PTR[di+00Dh],001h       ; Otherwise 1.44Mb
                mov     BYTE PTR[di+011h],0E0h       ; Fill
                mov     WORD PTR[di+013h],0B40h      ; buffer
                mov     BYTE PTR[di+015h],0F0h       ; area
                mov     BYTE PTR[di+016h],009h       ;
                mov     BYTE PTR[di+018h],012h       ;
Boot_Ok:
                xor     dx,dx                        ; clear DX
                mov     dl,fdrive                    ; drive # in DL
                mov     cx,0001h                     ; track 0, sector 1
                mov     bx,di                        ; buffer address in BX
                mov     ax,0301h                     ; write one sector
                call    Bios_Int                     ; call BIOS
                pop     di                           ; restore DI

                ret                                  ; near return

Write_Boot      endp

;-----------------------------------------------------------;
; Local subroutine - write FAT sectors                      ;
;-----------------------------------------------------------;

Write_Fat       proc    near

                push    di                           ; preserve
                mov     di,OFFSET dgroup:fat_sect    ; buffer address
                mov     ax,fmode                     ; fmt mode
Fat1:
                cmp     ax,2709h                     ; 360Kb ?
                jne     Fat2                         ; No. Skip
                mov     BYTE PTR[di+000h],0FDh       ; Yes.
                mov     WORD PTR[di+001h],0FFFFh     ; Fill buffer area
                xor     dx,dx                        ; clear DX
                mov     dl,fdrive                    ; drive # in DL
                mov     cx,0002h                     ; start at sector # 2
Fat1_Loop:      mov     bx,di                        ; buffer address in BX
                mov     ax,0301h                     ; write one sector
                call    Bios_Int                     ; call BIOS
                jnc     Fat1_T1                      ; Ok. Continue
                jmp     Fat_Ok                       ; Exit on error
Fat1_T1:
                inc     cl                           ; next sector
                cmp     cl,06                        ; last sector ?
                jb      Fat1_T2                      ; No. Continue
                jmp     Fat_Ok                       ; Yes. Exit
Fat1_T2:        mov     di,OFFSET dgroup:zero_sect   ; point to empty buffer
                cmp     cl,04                        ; begin 2nd copy of FAT ?
                jne     Fat1_Loop                    ; No.
                mov     di,OFFSET dgroup:fat_sect    ; Yes. point to header buf.
                jmp     Fat1_Loop                    ; loop
Fat2:
                cmp     ax,4F09h                     ; 720Kb ?
                jne     Fat3                         ; No. Skip
                mov     BYTE PTR[di+000h],0F9h       ; Yes.
                mov     WORD PTR[di+001h],0FFFFh     ; Fill buffer area
                xor     dx,dx                        ; clear DX
                mov     dl,fdrive                    ; drive # in DL
                mov     cx,0002h                     ; start at sector # 2
Fat2_Loop:      mov     bx,di                        ; buffer address in BX
                mov     ax,0301h                     ; write one sector
                call    Bios_Int                     ; call BIOS
                jnc     Fat2_T1                      ; Ok. Continue
                jmp     Fat_Ok                       ; Exit on error
Fat2_T1:
                inc     cl                           ; next sector
                cmp     cl,08                        ; last sector ?
                jb      Fat2_T2                      ; No. Continue
                jmp     Fat_Ok                       ; Yes. Exit
Fat2_T2:        mov     di,OFFSET dgroup:zero_sect   ; point to empty buffer
                cmp     cl,05                        ; begin 2nd copy of FAT ?
                jne     Fat2_Loop                    ; No. Continue
                mov     di,OFFSET dgroup:fat_sect    ; Yes. Point to header buf.
                jmp     Fat2_Loop                    ; loop
Fat3:
                cmp     ax,4F0Fh                     ; 1.2Mb ?
                jne     Fat4                         ; No. Skip
                mov     BYTE PTR[di+000h],0F9h       ; Yes.
                mov     WORD PTR[di+001h],0FFFFh     ; Fill buffer area
                xor     dx,dx                        ; clear DX
                mov     dl,fdrive                    ; drive # in DL
                mov     cx,0002h                     ; start at sector # 2
Fat3_Loop:      mov     bx,di                        ; buffer address in BX
                mov     ax,0301h                     ; write one sector
                call    Bios_Int                     ; call BIOS
                jnc     Fat3_T1                      ; Ok. Continue
                jmp     Fat_Ok                       ; Exit on error
Fat3_T1:
                inc     cl                           ; next sector
                cmp     cl,010h                      ; last sector ?
                jb      Fat3_T2                      ; No. Continue
                jmp     Fat_Ok                       ; Yes. Exit
Fat3_T2:        mov     di,OFFSET dgroup:zero_sect   ; point to empty buffer
                cmp     cl,09                        ; begin 2nd copy of FAT ?
                jne     Fat3_Loop                    ; No. Continue
                mov     di,OFFSET dgroup:fat_sect    ; Yes. Point to header buf.
                jmp     Fat3_Loop                    ; loop
Fat4:
                mov     BYTE PTR[di+000h],0F0h       ; Otherwise 1.44Mb
                mov     WORD PTR[di+001h],0FFFFh     ; Fill buffer area
                xor     dx,dx                        ; clear DX
                mov     dl,fdrive                    ; drive # in DL
                mov     cx,0002h                     ; start at sector # 2
Fat4_Loop:      mov     bx,di                        ; buffer address in BX
                mov     ax,0301h                     ; write one sector
                call    Bios_Int                     ; call BIOS
                jnc     Fat4_T1                      ; Ok. Continue
                jmp     Fat_Ok                       ; Exit on error
Fat4_T1:
                cmp     dh,01                        ; head # 1 ?
                je      Fat_Ok                       ; Yes. Exit
                mov     di,OFFSET dgroup:zero_sect   ; No. Point to empty buffer
                inc     cl                           ; next sector
                cmp     cl,013h                      ; last sector on head 0 ?
                jb      Fat4_T2                      ; No. Continue
                mov     dh,01                        ; Yes. Change head #
                mov     cl,01                        ; move 1 to sector #
                jmp     Fat4_Loop                    ; loop
Fat4_T2:
                cmp     cl,0Bh                       ; begin 2nd copy of FAT ?
                jne     Fat4_Loop                    ; No. Continue
                mov     di,OFFSET dgroup:fat_sect    ; Yes. Point to header buf.
                jmp     Fat4_Loop                    ; loop
Fat_Ok:
                pop     di                           ; restore

                ret                                  ; near return

Write_Fat       endp

;-----------------------------------------------------------;
; Local subroutine - write Root Directory sectors           ;
;-----------------------------------------------------------;

Write_Root      proc    near

                push    di                           ; preserve
                mov     di,OFFSET dgroup:zero_sect   ; buffer address
                mov     ax,fmode                     ; fmt mode
Root1:
                cmp     ax,2709h                     ; 360Kb ?
                jne     Root2                        ; No. Skip
                xor     dx,dx                        ; Yes. Clear DX
                mov     dl,fdrive                    ; drive # in DL
                mov     cx,0006h                     ; start at sector # 6
Root1_Loop:
                mov     bx,di                        ; buffer address in BX
                mov     ax,0301h                     ; Write one sector
                call    Bios_Int                     ; call BIOS
                jnc     Root1_T1                     ; Ok. Continue
                jmp     Root_Ok                      ; Exit on error
Root1_T1:
                inc     cl                           ; next sector
                cmp     dh,01                        ; head # 1 ?
                je      Root1_T2                     ; Yes. Test last sector
                cmp     cl,0Ah                       ; last sector on head 0 ?
                jb      Root1_Loop                   ; No. Continue
                mov     dh,01                        ; Yes. Change head #
                mov     cl,01                        ; move 1 to sector #
                jmp     Root1_Loop                   ; loop
Root1_T2:
                cmp     cl,04                        ; last sector ?
                jb      Root1_Loop                   ; No. Continue
                jmp     Root_Ok                      ; Yes. Exit
Root2:
                cmp     ax,4F09h                     ; 720Kb ?
                jne     Root3                        ; No. Skip
                xor     dx,dx                        ; Yes. Clear DX
                mov     dl,fdrive                    ; drive # in DL
                mov     cx,0008h                     ; start at sector # 8
Root2_Loop:
                mov     bx,di                        ; buffer address in BX
                mov     ax,0301h                     ; Write one sector
                call    Bios_Int                     ; call BIOS
                jnc     Root2_T1                     ; Ok. Continue
                jmp     Root_Ok                      ; Exit on error
Root2_T1:
                inc     cl                           ; next sector
                cmp     dh,01                        ; head # 1 ?
                je      Root2_T2                     ; Yes. Test last sector
                cmp     cl,0Ah                       ; last sector on head 0 ?
                jb      Root2_Loop                   ; No. Continue
                mov     dh,01                        ; Yes. Change head #
                mov     cl,01                        ; move 1 to sector #
                jmp     Root2_Loop                   ; loop
Root2_T2:
                cmp     cl,06                        ; last sector ?
                jb      Root2_Loop                   ; No. Continue
                jmp     Root_Ok                      ; Yes. Exit
Root3:
                cmp     ax,4F0Fh                     ; 1.2Mb ?
                jne     Root4                        ; No. Skip
                mov     dh,01                        ; Yes. head # 1 in DH
                mov     dl,fdrive                    ; drive # in DL
                mov     cx,0001h                     ; start at sector # 1
Root3_Loop:
                mov     bx,di                        ; buffer address in BX
                mov     ax,0301h                     ; Write one sector
                call    Bios_Int                     ; call BIOS
                jnc     Root3_T1                     ; Ok. Continue
                jmp     Root_Ok                      ; Exit on error
Root3_T1:
                inc     cl                           ; next sector
                cmp     cl,00Fh                      ; last sector ?
                jb      Root3_Loop                   ; No. Continue
                jmp     Root_Ok                      ; Yes. Exit
Root4:
                mov     dh,01                        ; Otherwise 1.44Mb
                mov     dl,fdrive                    ; drive # in DL
                mov     cx,0002h                     ; start at sector # 2
Root4_Loop:
                mov     bx,di                        ; buffer address in BX
                mov     ax,0301h                     ; Write one sector
                call    Bios_Int                     ; call BIOS
                jnc     Root4_T1                     ; Ok. Continue
                jmp     Root_Ok                      ; Exit on error
Root4_T1:
                inc     cl                           ; next sector
                cmp     cl,010h                      ; last sector ?
                jb      Root4_Loop                   ; No. Continue
Root_Ok:
                pop     di                           ; restore
                ret                                  ; near return

Write_Root      endp

;-----------------------------------------------------------;
; Local subroutine - set disk_base parameter (address 0:78) ;
;-----------------------------------------------------------;

Set_DskBas      proc    near

                push    ds                           ; save regs
                push    es                           ;
                push    bx                           ;
                push    ax                           ;

                xor     ax,ax                        ; clear AX
                mov     es,ax                        ; segment 0000 in ES
                mov     ax,fmode                     ; fmt mode
                les     bx,es:[0078h]                ; address of disk par in BX
                mov     cl,es:[bx+4]                 ; value in CL
                mov     dskbas,cl                    ; save old value
                mov     es:[bx+4],al                 ; update value
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS

                pop     ax                           ; restore regs
                pop     bx
                pop     es
                pop     ds
                ret                                  ; near return

Set_DskBas      endp

;-------------------------------------------------------------;
; Local subroutine - reset disk_base parameter (address 0:78) ;
;-------------------------------------------------------------;

Reset_DskBas    proc    near

                push    ds                           ; save regs
                push    es
                push    bx
                push    ax

                xor     ax,ax                        ; clear AX
                mov     es,ax                        ; segment 0000 in ES
                mov     al,dskbas                    ; old value in AL
                les     bx,es:[0078h]                ; address of disk par in BX
                mov     es:[bx+4],al                 ; restore old value
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS

                pop     ax                           ; restore regs
                pop     bx
                pop     es
                pop     ds
                ret                                  ; near return

Reset_DskBas    endp

_prog           ends
                end
