;-----------------------------------------------------------------------------
;  Program file..: DBDCHECK.asm
;  Author........: Paolo Ramozzi
;  Date..........: 06/14/89
;  Used by.......: Clipper, Summer '87
;  Function......: Check diskette Format 360Kb to 1.44Kb.
;  Compile ......: Microsoft MASM 5.0 : MASM dbdcheck;
;
;  Syntax .......: status = DBDCHECK ( drive )
;
;                  where: drive  =  0 - Drive A:
;                                   1 - Drive B:
;
;  Return .......:        status = -2 - Wrong Parameters
;                                  -1 - Drive not ready
;                                   0 - Non DOS diskette (unknown)
;                                   1 - 360Kb
;                                   2 - 720Kb
;                                   3 - 1.2Mb
;                                   4 - 1.44Mb
;
;----------------------------------------------------------------------------

public  DBDCHECK

extrn   __parni:far
extrn   __parinfo:far
extrn   __retni:far

dgroup  group   datasg

datasg  segment public  'DATA'

fdrive          db      0
ftrack          db      0
fhead           db      0
boot_sect       db      512 DUP (0)

datasg  ends


_prog   segment 'CODE'
        assume  cs:_prog,ds:dgroup,es:dgroup,ss:nothing




DBDCHECK        proc    far

                push    bp                           ; preserve BP reg
                mov     bp,sp                        ; BP point to stack
                push    ds                           ; must save regs
                push    es                           ;
                push    si                           ;
                push    di                           ;


                xor     ax,ax                        ; get # of parameters
                push    ax                           ;
                call    __parinfo                    ; call information function
                add     sp,2                         ; fix up the stack
                cmp     al,1                         ; # of parameters = 1 ?
                je      GetDrive                     ; Yes. Get it
                jmp     Ferror                       ; No. Return Error
GetDrive:
                mov     ax,1                         ; get 1st parameter (drive)
                push    ax                           ;
                call    __parni                      ; must be a integer type
                add     sp,2                         ; fix up the stack
                cmp     al,0                         ; drive A ?
                jz      ParamOk                      ; Ok.
                cmp     al,1                         ; drive B ?
                jz      ParamOk                      ; Ok.
                jmp     Ferror                       ; Invalid drive

ParamOk:
                mov     fdrive,al                    ; save drive number
                mov     ax,dgroup                    ; Data Segment
                mov     es,ax                        ; in ES register
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS
                call    Boot_Test                    ; test diskette type
                jmp     Exit                         ; return

Ferror:
                mov     ax,-2                        ; bad parameters

Exit:
                push     ax                          ; push return value
                call     __retni                     ; and return it to CLIPPER
                add      sp,2                        ; fix up the stack

                pop     di                           ; restore regs
                pop     si                           ;
                pop     es                           ;
                pop     ds                           ;
                pop     bp                           ;
                ret                                  ; far return to CLIPPER

DBDCHECK        endp

;-----------------------------------------------------------;
; Local subroutine - call BIOS Int 13 for read sector       ;
;-----------------------------------------------------------;

Bios_Int        proc    near
                push    bx                           ; save regs
                push    es                           ;
                push    ax                           ;
                int     13h                          ; call BIOS (read sector)
                jnc     Bios_Ret                     ; Read ok. Exit
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS
                pop     ax                           ; restore regs
                pop     es                           ; for retry
                push    es                           ; save regs
                push    ax                           ;
                int     13h                          ; call BIOS (read sector)
                jnc     Bios_Ret                     ; Read ok. Exit
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS
                pop     ax                           ; restore regs
                pop     es                           ; for retry
                push    es                           ; save regs
                push    ax                           ;
                int     13h                          ; call BIOS (read sector)
Bios_Ret:       pop     bx                           ; restore regs
                pop     es                           ;
                pop     bx                           ;
                ret                                  ; near return

Bios_Int        endp

;-----------------------------------------------------------;
; Local subroutine - check boot sector                      ;
;-----------------------------------------------------------;

Boot_Test       proc    near

                push    di                           ; preserve
                mov     di,OFFSET dgroup:boot_sect   ; address of buffer
Boot_Read:
                xor     dx,dx                        ; clear DX
                mov     dl,fdrive                    ; drive number in DL
                mov     cx,0001h                     ; track 0, sector 1
                mov     bx,di                        ; buffer addr in ES:BX
                mov     ax,0201h                     ; read one sector
                call    Bios_Int                     ; call BIOS
                jnc     Boot1                        ; Read ok. Continue
                cmp     ah,80h                       ; drive not ready ?
                jne     Boot_No                      ; No. Return unknown
                mov     ax,-1                        ; Yes. Return -1
                jmp     Boot_End                     ; and exit
Boot1:
                cmp     WORD PTR[di+013h],02D0h      ; 360Kb ?
                jne     Boot2                        ; No. Continue
                mov     ax,1                         ; Yes. Return 1
                jmp     Boot_End                     ;
Boot2:
                cmp     WORD PTR[di+013h],05A0h      ; 720Kb ?
                jne     Boot3                        ; No. Continue
                mov     ax,2                         ; Yes. Return 2
                jmp     Boot_End                     ;
Boot3:
                cmp     WORD PTR[di+013h],0960h      ; 1.2Mb ?
                jne     Boot4                        ; No. Continue
                mov     ax,3                         ; Yes. Return 3
                jmp     Boot_End                     ;
Boot4:
                cmp     WORD PTR[di+013h],0B40h      ; 1.44Mb ?
                jne     Boot_No                      ; No. Return unknown
                mov     ax,4                         ; Yes. Return 4
                jmp     Boot_End
Boot_No:
                mov     ax,0                         ; diskette unknown

Boot_End:
                pop     di                           ; restore
                ret                                  ; near return

Boot_Test       endp

_prog           ends
                end
