* John T. Opincar, Jr.
* CID: 71631,541
* 04/12/90

*--------------------------------INITDBFOPEN-----------------------------------*

function initdbfopen
parameters maxarea

* begin
    public AREAMAX
    AREAMAX = maxarea
    public areas[AREAMAX + 1], opens[AREAMAX + 1]
    afill(areas, '')
    afill(opens, .f.)
    select 0
    use DICTION
    set filter to !deleted()
    if !file('dictdata.ntx')
        index on upper(DATABASE) to DICTDATA
    endif
    set index to DICTDATA
    select 0
return ''

*------------------------------------OPEN--------------------------------------*

function open
parameters dbf, ntx

private lcv, num_char, dbh, length, t0, opened, pcount, ordcount, aream
private oldarea, areaptr, numchar, _duration

* const
    _duration = 5

* begin
    oldarea = alias()
    pcount = pcount()
    if pcount = 0
        misc_error(procname(), procline(), 'Too few parameters, a database must be specified.', '')
    endif
    dbf = trim(dbf)
    if .not. file(dbf + if('.'$dbf, '', '.dbf'))
        db_error(procname(), procline(), 'cannot find ' + dbf + '.')
    endif
    if (pcount = 2)
        if empty(ntx)
            pcount = 1
        endif
    endif

    *** add default extension if extension is not specified and check for its existence
    if pcount > 1
        ntx = upper(trim(ntx))
        if .not. file(ntx + '.ntx')
            db_error(procname(), procline(), 'cannot find ' + ntx + '.')
        endif
    endif

    dbf = upper(trim(dbf))
    dbh = left(dbf,4)
    select (select(dbf))
    if upper(alias()) == upper(dbf)
        length = len(&dbh.ntxs)
        opened = .t.
    else
        if pcount = 1
            ntx = '********.***'
        endif
        select DICTION
        seek dbf
        length = DICTION->INDEXCOUNT
        public &dbh.ntxs[length]
        ordcount = 1
        for lcv = 1 to length
            numchar = ltrim(str(lcv, 2, 0))
            &dbh.ntxs[lcv] = trim(INDEX&numchar)
        next lcv

        select 0
        t0 = seconds()
        opened = .f.
        do while (seconds() - t0 < _duration) .and. (.not. opened)
            use (dbf)
            opened = (.not. neterr())
            if .not. opened
                inkey(1)
            endif
        enddo

        if opened
            * believe it or not, there is no other way to do this!
            do case
            case length = 1
                set index to (&dbh.ntxs[1])
            case length = 2
                set index to (&dbh.ntxs[1]), (&dbh.ntxs[2])
            case length = 3
                set index to (&dbh.ntxs[1]), (&dbh.ntxs[2]), (&dbh.ntxs[3])
            case length = 4
                set index to (&dbh.ntxs[1]), (&dbh.ntxs[2]), (&dbh.ntxs[3]), (&dbh.ntxs[4])
            case length = 5
                set index to (&dbh.ntxs[1]), (&dbh.ntxs[2]), (&dbh.ntxs[3]), (&dbh.ntxs[4]), (&dbh.ntxs[5])
            case length = 6
                set index to (&dbh.ntxs[1]), (&dbh.ntxs[2]), (&dbh.ntxs[3]), (&dbh.ntxs[4]), (&dbh.ntxs[5]), (&dbh.ntxs[6])
            case length = 7
                set index to (&dbh.ntxs[1]), (&dbh.ntxs[2]), (&dbh.ntxs[3]), (&dbh.ntxs[4]), (&dbh.ntxs[5]), (&dbh.ntxs[6]), (&dbh.ntxs[7])
            case length = 8
                set index to (&dbh.ntxs[1]), (&dbh.ntxs[2]), (&dbh.ntxs[3]), (&dbh.ntxs[4]), (&dbh.ntxs[5]), (&dbh.ntxs[6]), (&dbh.ntxs[7]), (&dbh.ntxs[8])
            case length = 9
                set index to (&dbh.ntxs[1]), (&dbh.ntxs[2]), (&dbh.ntxs[3]), (&dbh.ntxs[4]), (&dbh.ntxs[5]), (&dbh.ntxs[6]), (&dbh.ntxs[7]), (&dbh.ntxs[8]), (&dbh.ntxs[9])
            case length = 10
                set index to (&dbh.ntxs[1]), (&dbh.ntxs[2]), (&dbh.ntxs[3]), (&dbh.ntxs[4]), (&dbh.ntxs[5]), (&dbh.ntxs[6]), (&dbh.ntxs[7]), (&dbh.ntxs[8]), (&dbh.ntxs[9]), (&dbh.ntxs[10])
            case length = 11
set index to (&dbh.ntxs[1]), (&dbh.ntxs[2]), (&dbh.ntxs[3]), (&dbh.ntxs[4]), (&dbh.ntxs[5]), (&dbh.ntxs[6]), (&dbh.ntxs[7]), (&dbh.ntxs[8]), (&dbh.ntxs[9]), (&dbh.ntxs[10]), (&dbh.ntxs[11])
            case length = 12
set index to (&dbh.ntxs[1]), (&dbh.ntxs[2]), (&dbh.ntxs[3]), (&dbh.ntxs[4]), (&dbh.ntxs[5]), (&dbh.ntxs[6]), (&dbh.ntxs[7]), (&dbh.ntxs[8]), (&dbh.ntxs[9]), (&dbh.ntxs[10]), (&dbh.ntxs[11]), (&dbh.ntxs[12])
            case length = 13
set index to (&dbh.ntxs[1]),(&dbh.ntxs[2]),(&dbh.ntxs[3]),(&dbh.ntxs[4]),(&dbh.ntxs[5]),(&dbh.ntxs[6]),(&dbh.ntxs[7]),(&dbh.ntxs[8]),(&dbh.ntxs[9]),(&dbh.ntxs[10]),(&dbh.ntxs[11]),(&dbh.ntxs[12]),(&dbh.ntxs[13])
            case length = 14
set index to (&dbh.ntxs[1]),(&dbh.ntxs[2]),(&dbh.ntxs[3]),(&dbh.ntxs[4]),(&dbh.ntxs[5]),(&dbh.ntxs[6]),(&dbh.ntxs[7]),(&dbh.ntxs[8]),(&dbh.ntxs[9]),(&dbh.ntxs[10]),(&dbh.ntxs[11]),(&dbh.ntxs[12]),(&dbh.ntxs[13]),(&dbh.ntxs[14])
            case length = 15
set index to (&dbh.ntxs[1]),(&dbh.ntxs[2]),(&dbh.ntxs[3]),(&dbh.ntxs[4]),(&dbh.ntxs[5]),(&dbh.ntxs[6]),(&dbh.ntxs[7]),(&dbh.ntxs[8]),(&dbh.ntxs[9]),(&dbh.ntxs[10]),(&dbh.ntxs[11]),(&dbh.ntxs[12]),(&dbh.ntxs[13]),(&dbh.ntxs[14]),(&dbh.ntxs[15])
            endcase
        endif
    endif
    if opened
        if pcount = 1
            set order to 0
        else
            ntx_ptr = ascan(&dbh.ntxs, ntx)
            if (ntx_ptr = 0)
                if .not. empty(oldarea)
                    select &oldarea
                endif
                db_error(procname(), procline(), 'cannot find ' + ntx + '.')
            endif
            set order to (ntx_ptr)
        endif
        set filter to !deleted()
        areaptr = ascan(areas, upper(dbf))
        if areaptr > 0
            adel(areas, areaptr)
            adel(opens, areaptr)
        endif
        ains(areas, 1)
        ains(opens, 1)
        areas[1] = upper(dbf)
        opens[1] = .t.
        if !empty(areas[AREAMAX + 1])
            areaptr = AREAMAX + 1
            do while (areaptr > 1) .and. opens[areaptr]
                areaptr = areaptr - 1
            enddo
            if areaptr = 1
                db_error(procname(), procline(), 'Database priority queue full.')
            endif
            aream = areas[areaptr]
            adel(areas, areaptr)
            adel(opens, areaptr)
            areas[AREAMAX + 1] = ''
            opens[AREAMAX + 1] = .f.
            select &aream
            use
            dbh = left(aream, 4)
            release &dbh.ntxs
            select &dbf
        endif
    else
        * appropriate message telling user that database is not available
    endif
return opened

*-----------------------------------ISOPEN-------------------------------------*

function isopen
parameters dbf

private areaptr, retval

* begin
    retval = .f.
    areaptr = ascan(areas, upper(trim(dbf)))
    if areaptr > 0
        retval = opens[areaptr]
    endif
return retval

*-----------------------------------DCLOSE-------------------------------------*

function dclose
parameters dbf

private areaptr

* begin
    areaptr = ascan(areas, upper(trim(dbf)))
    if areaptr > 0
        opens[areaptr] = .f.
    endif
return ''

*----------------------------------SETORDER------------------------------------*

function setorder
parameters neworder

private oldorder, dbf, dbh

* begin
    dbf = upper(alias())
    dbh = left(dbf, 4)
    if empty(dbf)
        misc_error(procname(), procline(), 'Database required.', '')
    endif
    if (indexord() = 0)
        oldorder = ''
    else
        oldorder = &dbh.ntxs[indexord()]
    endif
    if (pcount() > 0)
        if empty(neworder)
            set order to 0
        else
            set order to ( ascan(&dbh.ntxs, upper(neworder)) )
        endif
    endif
return upper(oldorder)
