* Function Name: test.prg 
* Author: Dave Irwin - CIS# 76137,3150
* Copyright (c) 1989 by Software Solutions (416) 849-6295
*-----------------------------------------------------------------------------
* Created: 8/24/1989 at 12:40
*.............................................................................
* Revision: 1.0 Last Revised: 8/24/1989 at 12:40
* Description: Original Creation.
*
* Parameters: mDBF_FILE -> Complete DBF file name with extension
*             mMIXIT    -> .T. will make file UNreadable to Dbase III/IV            	
*                          .F. will make file readable to Dbase III/IV
*
* This function need only be called once to make the file readable/unreadable
* from Dbase III/IV for all users until the function is called again.
*																	 
* Clipper will ignore the change made to the header, thus keeping 'Dot
* Prompters' out but allowing full access from your Clipper Apps.
*
* For the ultimate in data encryption, check out NetLib from 
* Communications Horizions.
*
* All rights freely given as long as this text header remains with ALL 
* copies of this source code.
*
*.............................................................................
*---------------------------- ALL RIGHTS RESERVED ----------------------------

FUNCTION MIX_HEAD
	PRIVATE headersize, handle, newbyte, find, mdbf_file, mmixit
	PARAMETERS mDBF_FILE, mMIXIT

	mRETURN = .T.

	*----------------------------
	* GET FILE HEADER INFO
	*----------------------------
	USE &mDBF_FILE EXCL
	headersize = HEADER() -2					 && GET HEADER SIZE
	USE

	*----------------------------
	* SCRAMBLE DBF HEADER
	*----------------------------
	handle = FOPEN(mDBF_FILE,66)	 			 && OPEN FILE FOR LOW LEVEL R/W ACCESS
	find = FSEEK(handle,headersize,0)			 && MOVE POINTER TO END OF HEADER

	IF mMIXIT
		newbyte = chr(0) 						 && MAKE UNREADABLE TO DBASE III/IV
	ELSE
		newbyte = chr(13)						 && MAKE READABLE TO DBASE III/IV
	ENDIF

	IF FWRITE(handle,newbyte,1)	= 0				 && WRITE NEW END OF HEADER BYTE
		mRETURN = .F.
	ENDIF

	FCLOSE(handle)								 && CLOSE THE FILE

RETURN mRETURN						 			 && CLOSE AND RETURN


