*** DBFHEAD.PRG
*** 29-Mar-89
*** Clipper Summer '87

*** Copyright 1989, Joshua Spahn
*** FromTheWings Software
*** P.O. Box 643, NYC, NY 10108
*** Permission is granted to use freely provided author credit is given.

* Description: Program creates a dBASE III .dbf file without using the
* CREATE command and intermediate file of header information.
* Includes a few handy general purpose routines:
* PAD, GET_YN, ASUM, LONG_INT, WRITEINT

* Procedure dbfcreat requires the following public [external] variables
public c_dbfext, c_memoext
c_dbfext = ".DBF"
c_memoext = ".DBT"

**************************** BEGIN TEST PORTION **************************

private fldcount, success
fldcount = 5
success = .f.

public a_fldname[fldcount], a_fldtype[fldcount]
public a_fldlen[fldcount], a_flddec[fldcount]

private i
for i = 1 to fldcount
   a_fldname[i] = "FIELD" + ltrim(str(i))
   a_fldtype[i] = substr("CNDLM", i, 1)
   do case
      case i = 1              && Character
        a_fldlen[i] = 15
         a_flddec[i] = 0
      case i = 2              && Numeric
         a_fldlen[i] = 5
         a_flddec[i] = 2
      case i = 3              && Date
         a_fldlen[i] = 8
         a_flddec[i] = 0
      case i = 4              && Logical
         a_fldlen[i] = 1
         a_flddec[i] = 0
      case i = 5              && Memo
         a_fldlen[i] = 10
         a_flddec[i] = 0
   endcase
next

success = dbfcreat("TEST", a_fldname, a_fldtype, a_fldlen, a_flddec)

set cursor on   && procedure get_yn turns it off
return
***************************** END TEST PORTION ***************************


************************ Create Empty .DBF file
function dbfcreat  *******************************************************
************************ without intermediate .DBF
parameters p_dbfname, p_namearr, p_typearr, p_lenarr, p_decarr

private success, dbffile, createfile
private fhandle, memofield, fldcount
private namewidth, typewidth
private reserved, db3_id, delebyte
private hdrstr, hdrlen, hdrstrlen
private i, offset

success = .f.
dbffile = upper(p_dbfname + c_dbfext)
createfile = .t.
if file(dbffile)
   createfile = get_yn(24, 0, dbffile + " exists. Overwrite?", .f.)
endif

if createfile
   fhandle = fcreate(p_dbfname + c_dbfext, 0)
   if ferror() = 0
      fldcount = len(p_namearr)
      namewidth = 11
      typewidth = 1
      delebyte = 1      && each record has one byte for deleted()

      * Build file portion of header
      * db3_id = 03h or 83h if there are memo fields
      memofield = iif(ascan(p_typearr, "M") > 0, 8 * 16, 0)
      db3_id = chr(3 + memofield)
      lastupda = db3_date(date())
      records = long_int(0)
      hdrstrlen = ((fldcount + 1) * 32) + 1
      hdrlen = writeint(hdrstrlen)
      recordlen = writeint(asum(p_lenarr) + delebyte)
      reserved = replicate(chr(0), 20)
      hdrstr = db3_id + lastupda + records + hdrlen + recordlen + reserved

      * Build field portion of header
      offset = 1
      for i = 1 to fldcount
         * total length per field = 32 { 11, 4, 1, 1, 1, 14 }
         hdrstr = hdrstr + substr(pad(p_namearr[i], namewidth), 1, namewidth)
         hdrstr = hdrstr + substr(p_typearr[i], 1, typewidth)
         hdrstr = hdrstr + long_int(offset)
         hdrstr = hdrstr + chr(p_lenarr[i])
         hdrstr = hdrstr + chr(p_decarr[i])
         hdrstr = hdrstr + space(14)
         offset = offset + p_lenarr[i]
      next

      * Add terminating character to header
      hdrstr = hdrstr + chr(13)

      fwrite(fhandle, hdrstr, hdrstrlen)
      fclose(fhandle)
      success = .t.

      if memofield > 0
         fhandle = fcreate(p_dbfname + c_memoext)
         fclose(fhandle)
      endif
   endif
endif
return success
************************ Pad A String With Spaces To Fixed Length
function pad       *******************************************************
************************
parameters p_str, p_len

private strlen
strlen = len(p_str)
return p_str + space(p_len - strlen)
************************ Returns Three Char String: YY MM DD
function db3_date  *******************************************************
************************
parameters p_date

private yr, mo, da
yr = year(p_date) - 1900
mo = month(p_date)
da = day(p_date)
return chr(yr) + chr(mo) + chr(da)
************************ Returns Long Integer In Four Characters
function long_int *******************************************************
************************
parameters p_value

private int_size, loword, hiword
int_size = 256 * 256

loword = mod(p_value, int_size)
hiword = int(p_value/int_size)

return writeint(loword) + writeint(hiword)
************************ Returns Integer In Two Characters
function writeint *******************************************************
************************
parameters p_value

private char_size
char_size = 256

private lobyte, hibyte
lobyte = mod(p_value, char_size)
hibyte = int(p_value/char_size)

return chr(lobyte) + chr(hibyte)
************************ Add All Numeric Elements In An Array
function asum      ********************************************************
************************
parameters p_array

private arraytotal, i
arraytotal = 0

i = 1
do while i <= len(p_array)
   if type("p_array[i]") = "N"
      arraytotal = arraytotal + p_array[i]
   endif
   i = i + 1
enddo
return arraytotal
************************ Prompts For Logical [YES/NO] Value
function get_yn    *******************************************************
************************
parameters p_row, p_col, p_prompt, p_default

private yn
yn = p_default

* NOTE: "get" location is p_col + len(p_prompt)
if p_col = 0        && clear screen line
   @ p_row, p_col
else                && clear msg area
   @ p_row, p_col clear to p_row, p_col + len(p_prompt) + 1
endif

@ p_row, p_col say p_prompt get yn picture "Y"
if read_val() = 27  && escape
   yn = .f.
endif

if p_col = 0        && clear screen line
   @ p_row, p_col
else                && clear msg area
   @ p_row, p_col clear to p_row, p_col + len(p_prompt) + 1
endif
return yn
