/* Copyright (c) 1988,89 by George M. Sipe */

/* NOTICE:  This library may be freely distributed for non-commercial
   use only.  Any other use of this library is permitted only under
   the terms of a written and signed agreement.
*/

/* 
**    file:    d_cpystr.c
**    purpose: routine to create a new dbiii file useing the structure of an
**             existing file.
**    ussage:  source = (struct DBF *)malloc(sizeof(struct DBF));
**             dest  = (struct DBF *)malloc(sizeof(struct DBF));
**             strcpy(source->filename, "source.dbf");
**             strcpy(dest->filename, "dest.dbf");
**             d_open(source);
**             d_cpystr(source, dest);
**             d_close(source);
**             d_close(dest);
**             free(source);
**             free(dest);
**    notes:   this code fragment does the same thing as:
**             		USE SOURCE
**             		COPY STRUCTURE TO DEST
**    returns: 0 if successful with structure filled in
**             NO_FILE if unable to find file
**             OUT_OF_MEM if not enough memory
**    author:  Mark Sadler
**    revised: 6/19/87
*/

#include <stdio.h>
#ifndef	unix
#include <malloc.h>
#endif
#include <memory.h>
#include "dbf.h"

int d_cpystr(s, d)
struct DBF *s, *d;
{
	struct FIELD_RECORD *f;
	int i;
	int n;

	/* make sure source file is open */
	if (s->status != not_updated && s->status != updated)
		return (NO_FILE);

	d->status = not_open;		/* in case can not open */

	if ((d->file_ptr = fopen(d->filename, "w+b")) == NULL)
		return (NO_FILE);

	if ((d->fields_ptr = (struct FIELD_RECORD *)
			malloc(s->num_fields * FIELD_REC_LEN)) == NULL)
		return (OUT_OF_MEM);

	memcpy(d->fields_ptr, s->fields_ptr, (s->num_fields * FIELD_REC_LEN));
	memcpy(&d->dbf_version, &s->dbf_version, 12);
	d->records = 0L;
	d->current_record = 0;
	d->num_fields = s->num_fields;
	/* the following line forces the copied dbf structure to be in dbIII+ */
 	/* format.   dbIII+ files can be read without problems with dbIII. */
	d->header_length = HEADER_PROLOG + (d->num_fields * FIELD_REC_LEN) + 1;
	if ((d->record_ptr = (char *) malloc(d->record_length)) == NULL)
		return (OUT_OF_MEM);
	/* initialize pointers to fields in record */
	for (i = 0, n = 1; i < d->num_fields; i++) {
		f = d->fields_ptr + i;
		f->field_data_address = d->record_ptr + n;
		n += f->len;
	}
#ifdef	M_I86
	/* write header */
	fwrite(&d->dbf_version, 1, 12, d->file_ptr);
#else
	/* Change byte order from whatever to i80x86 */
	{
		/* d->records is zero at this point */
		/* unsigned long records = d->records; */
		unsigned short header_length = d->header_length;
		unsigned short record_length = d->record_length;
		unsigned char *bp;

		/* bp = (unsigned char *) &d->records; */
		/* *(bp+3) = (records >> 24) & 0xFF; */
		/* *(bp+2) = (records >> 16) & 0xFF; */
		/* *(bp+1) = (records >> 8) & 0xFF; */
		/* *bp = records & 0xFF; */
		bp = (unsigned char *) &d->header_length;
		*(bp+1) = (header_length >> 8) & 0xFF;
		*bp = header_length & 0xFF;
		bp = (unsigned char *) &d->record_length;
		*(bp+1) = (record_length >> 8) & 0xFF;
		*bp = record_length & 0xFF;

		/* write header */
		fwrite(&d->dbf_version, 1, 12, d->file_ptr);

		/* restore byte order */
		/* d->records = records; */
		d->header_length = header_length;
		d->record_length = record_length;
	}
#endif
	for (i = 1; i <= 20; i++)
		fwrite("\0", 1, 1, d->file_ptr);
	fwrite(d->fields_ptr, FIELD_REC_LEN, d->num_fields, d->file_ptr);
	fwrite("\x0d", 1, 1, d->file_ptr);
	d->status = updated;		/* open successfull */
	return (0);
}
