/* Copyright (c) 1988,89 by George M. Sipe */

/* NOTICE:  This library may be freely distributed for non-commercial
   use only.  Any other use of this library is permitted only under
   the terms of a written and signed agreement.
*/

/* 
**    file:    d_blank.c
**    purpose: routine to fill a record in memory with blanks.
**    usage:   d = (struct DBF *)malloc(sizeof(struct DBF));
**             strcpy(d->filename, "filename.dbf");
**             d_open(d);
**             d_blank(d);
**             d_addrec(d);
**             d_close(d);
**             free(d);
**    notes:   the above code fragment append a blank record to the end of
**             the dbiii file.  see dbf.h for structure of DBF
**    author:  Mark Sadler
**    revised: 6/6/87
*/

#include <stdio.h>
#include <memory.h>
#include "dbf.h"

void d_blank(d)
struct DBF *d;
{
	memset(d->record_ptr, '\x20', d->record_length);
}
