/* Copyright (c) 1988,89 by George M. Sipe */

/* NOTICE:  This library may be freely distributed for non-commercial
   use only.  Any other use of this library is permitted only under
   the terms of a written and signed agreement.
*/

/* 
**    file:    dbf.h
**    purpose: header file defining structures and error codes for dbase
**             access routines.
**    notes:   this file must be included in any programs which use the dbase
**             access routines included in dbf.lib.  do not use -a option with
**             this header file.
**    author:  Mark Sadler
**    revised: 6/18/87
*/

#define	DB2FILE		2
#define	DB3FILE		3
#define	DB3WITHMEMO	0x83
#define	FIELD_REC_LEN	32	/* length of field description record */
#define	HEADER_PROLOG	32	/* length of header without field desc */
				/* and terminator */
#define	MAX_HEADER	4129	/* maximum length of dBase III header  */
#define	MAX_RECORD	4000	/* dBase III record limit */
#define	MAX_FIELDS	128	/* dBase III field limit */
#define	MAX_MEMO_BYTES	512	/* dBase III memo field record size */

#define	MAXPATH		80

/* error codes */
#define	OUT_OF_MEM	8	/* insufficient memory error */
#define	NO_FILE		2	/* file not found error */
#define	BAD_FORMAT	11	/* file not dBASE III file */
#define	RECNO_TOO_BIG	105	/* requested record too big */

typedef unsigned char UCHAR;

struct DBF
{
	/* the following 7 variables are filled with a fread(), */
	/* do not change position in DBF, order, or size */
	UCHAR dbf_version;	/* version character */
	UCHAR update_yr;	/* date of last update - year (-1900) */
	UCHAR update_mo;	/* date of last update - month */
	UCHAR update_day;	/* date of last update - day  */
	unsigned long records; /* number of records in dbf */
	unsigned short header_length; /* length of header structure */
	unsigned short record_length; /* length of a record */

	char filename[MAXPATH];	/* dos filename */
	FILE *file_ptr;		/* c file pointer */
	UCHAR num_fields;	/* number of fields */
	unsigned long current_record; /* current record in memory */
	enum			/* status of file */
	{
		not_open=0,
		not_updated,
		updated
	} status;
	struct FIELD_RECORD *fields_ptr; /* pointer to field array */
	char *record_ptr;	/* pointer to current record struct */
};

struct FIELD_RECORD		/* This structure is filled in memory */
{				/* with a fread.  do not change. */
	char name[11];		/* name of field in asciz */
	char typ;		/* type of field...char,numeric etc. */
	char *field_data_address;/* offset of field in record */
#if defined(M_I86SM) || defined (M_I86MM)
	int space_holder;	/* field_data_address must be 32 bits */
#endif
	UCHAR len;		/* length of field */
	UCHAR dec;		/* decimals in field */
	UCHAR reserved_bytes[14];/* reserved by dbase */
};

#ifndef	unix
extern void d_addrec(struct DBF *d);
extern void d_blank(struct DBF *d);
extern void d_close(struct DBF *d);
extern int d_cpystr(struct DBF *s, struct DBF *d);
extern char d_getfld(struct DBF *d, unsigned int f, char *buff);
extern int d_getrec(struct DBF *d, unsigned long r);
extern int d_open(struct DBF *d);
extern int d_putfld(struct DBF *d, unsigned int f, char *buff);
extern int d_putrec(struct DBF *d, unsigned long r);
#else
extern void d_addrec();
extern void d_blank();
extern void d_close();
extern int d_cpystr();
extern char d_getfld();
extern int d_getrec();
extern int d_open();
extern int d_putfld();
extern int d_putrec();
#endif
