/* Copyright (c) 1988,89 by George M. Sipe */

/* NOTICE:  This library may be freely distributed for non-commercial
   use only.  Any other use of this library is permitted only under
   the terms of a written and signed agreement.
*/

/* 
**    file:    dbcopy.c
**    purpose: program to copy structure and records to another file
**    usage:   dbcopy fromfile tofile
**    notes:   dos copy does this faster, but this program exercizes most
**             of the dbf functions
**    author:  Mark Sadler
**    revised: 6/19/87
*/

#include <stdio.h>
#ifndef	unix
#include <stdlib.h>
#include <malloc.h>
#endif
#include <string.h>
#include "../dbf.h"

void db_error(errornum, filename)
int errornum;
char *filename;
{
	printf("\nError opening file: ");
	switch (errornum) {
		case OUT_OF_MEM: 
			printf("Not enough memory.\n");
			break;
		case NO_FILE: 
			printf("Can not open file %s.\n", filename);
			break;
		case BAD_FORMAT: 
			printf("File %s is not a dBASE III file.\n", filename);
			break;
	}
}

int main(argc, argv)
int argc;
char *argv[];
{
	struct DBF in, out;
	int errornum, fld;
	unsigned long rec;
	char *buff;

	if (argc < 2) {
		printf("Usage DBCOPY infile[.dbf] outfile[.dbf]\n");
		exit(1);
	}

	/* open input file */
	strcpy(in.filename, argv[1]);
	if (!strchr(in.filename, '.'))	/* default to .dbf file */
		strcat(in.filename, ".DBF");
	if ((errornum = d_open(&in)) != 0) {/* open file */
		db_error(errornum, in.filename);
		exit(1);
	}

	/* copy input file structure to outputfile */
	strcpy(out.filename, argv[2]);
	if (!strchr(out.filename, '.'))/* default to .dbf file */
		strcat(out.filename, ".DBF");
	if ((errornum = d_cpystr(&in, &out)) != 0) {/* open file */
		db_error(errornum, out.filename);
		exit(1);
	}

	if ((buff = (char *) malloc(MAX_RECORD)) == NULL) {
		db_error(OUT_OF_MEM, "");
		exit(1);
	}

	for (rec = 1L; rec <= in.records; rec++) {/* records loop */

	/* 
	 **    note: this loop could be replaced by just copying the record with
	 **          using memcopy to copy to the out file record.  faster still
	 **          by changing the out file structure record pointer to point
	 **          to the record in the in file structure.
	 */
		d_getrec(&in, rec);

		for (fld = 1; fld <= in.num_fields; fld++) {/* fields loop */
			d_getfld(&in, fld, buff);
			d_putfld(&out, fld, buff);
		}
		*out.record_ptr = *in.record_ptr;/* copy delete marker */
		d_addrec(&out);
	}
	free(buff);
	d_close(&in);
	d_close(&out);
}
