/* Copyright (c) 1988,89 by George M. Sipe */

/* NOTICE:  This library may be freely distributed for non-commercial
   use only.  Any other use of this library is permitted only under
   the terms of a written and signed agreement.
*/

/*    file:    listdb.c
**    purpose: program to list the records in a dbaseiii file
**    usage:   listdb filename
**    notes:   link with d_open d_getrec d_getfld d_close
**    author:  Mark Sadler
**    revised: 6/18/87
*/

#include <stdio.h>
#ifndef	unix
#include <stdlib.h>
#include <malloc.h>
#endif
#include <memory.h>
#include <string.h>
#include "../dbf.h"

#ifndef	unix
extern	main(int argc, char **argv);
extern	void fdate(char *buff);
#endif

/* routine to format dbase date field -   buff in is in form  YYYYMMDD
**                                        buff out is in form MM/DD/YY
*/
void fdate(buff)
char *buff;
{
	int day;
	int mon;
	int yr;

	if (buff[0] == ' ') {
		buff[0] = '\0';
		strcat(buff, "  /  /  ");
	} else {
		sscanf(buff, "%4d%02d%02d", &yr, &mon, &day);
		sprintf(buff, "%02d/%02d/%d", mon, day, yr - 1900);
	}
}

main(argc, argv)
int argc;
char **argv;
{
	int errornum;
	long rec;
	int fld;
	struct DBF *d;
	static char buff[255];

	if (argc != 2) {
		printf("Usage LISTDB filename[.dbf]\n");
		exit(1);
	}

	/* allocate space for DBF */
	d = (struct DBF *) malloc(sizeof(struct DBF));

	strcpy(d->filename, argv[1]);

	if (!strchr(d->filename, '.'))/* default to .dbf file */
		strcat(d->filename, ".DBF");

	if ((errornum = d_open(d)) != 0) {/* open file */
		printf("Error opening file: ");
		switch (errornum) {
			case OUT_OF_MEM: 
				printf("Not enough memory.\n");
				break;
			case NO_FILE: 
				printf("Can not open file %s.\n", d->filename);
				break;
			case BAD_FORMAT: 
				printf("File %s is not a dBASE III file.\n",
						d->filename);
				break;
		}
		free(d);
		exit(1);
	}

	for (rec = 1; rec <= d->records; rec++) {
		printf("\n%-5u", rec);

		d_getrec(d, (long) rec);
		for (fld = 1; fld <= d->num_fields; fld++) {
			if (d_getfld(d, fld, buff) == 'D')
				fdate(buff);
			printf(" %s", buff);
		}
	}

	d_close(d);
	free(d);
	return(0);
}
