/* Copyright (c) 1988,89 by George M. Sipe */

/* NOTICE:  This library may be freely distributed for non-commercial
   use only.  Any other use of this library is permitted only under
   the terms of a written and signed agreement.
*/

/* 
**    file:    dbstat.c
**    purpose: program to list structure and statistics of dbase files
**    usage:   dbstat filename
**    author:  Mark Sadler
**    revised: 6/18/87
*/

#include <stdio.h>
#ifndef	unix
#include <stdlib.h>
#include <malloc.h>
#endif
#include <string.h>
#include "../dbf.h"

#ifndef	unix
main(int argc, char *argv[]);
#endif

main(argc, argv)
int argc;
char *argv[];
{
	int errornum;
	int i, j;
	struct DBF *d;
	struct FIELD_RECORD *f;

	/* 
	**    if wsetargv(compuserve, bor-100, dl11) is linked in, this
	**    program will accept wild cards in the command line
	*/
	if (argc < 2) {
		printf("Usage DBSTAT filename[.dbf]\n");
		exit(1);
	}

	/* allocate space for DBF */
	d = (struct DBF *) malloc(sizeof(struct DBF));

	for (j = 1; j < argc; j++) {
		strcpy(d->filename, argv[j]);
		if (!strchr(d->filename, '.'))/* default to .dbf file */
			strcat(d->filename, ".DBF");
		if ((errornum = d_open(d)) != 0) {/* open file */
			printf("Error opening file: ");
			switch (errornum) {
				case OUT_OF_MEM: 
					printf("Not enough memory.\n");
					break;
				case NO_FILE: 
					printf("Can not open file %s.\n",
						d->filename);
					break;
				case BAD_FORMAT: 
					printf(
					"File %s is not a dBASE III file.\n",
						d->filename);
					break;
			}
			continue;
		}

		/* report stats */
		printf("\nFilename:          %s\n", d->filename);
		printf("Header length:     %-u\n", d->header_length);
		printf("Number of fields:  %-u\n", d->num_fields);
		if (d->dbf_version == DB3FILE)
			printf("Version:           dBASE III\n");
		else
			printf("Version:           dBASE III with Memo file\n");
		printf("Updated:           %02u/%02u/%2u\n",
				d->update_mo, d->update_day, d->update_yr);
		printf("Number of records: %-u\n", d->records);
		printf("Record length:     %-u\n", d->record_length);

		f = d->fields_ptr;
		printf("\n\n FILE STRUCTURE\n");
		printf("\n  # FIELD NAME TYPE LEN DEC");
		printf("\n--------------------------------\n");
		for (i = 1; i <= d->num_fields; ++i, f++)
			printf("%3u %-12s %c  %3u   %3u\n",
					i, f->name, f->typ, f->len, f->dec);
		printf("\f");
		d_close(d);
	}
	free(d);
	return(0);
}
