/* Copyright (c) 1988,89 by George M. Sipe */

/* NOTICE:  This library may be freely distributed for non-commercial
   use only.  Any other use of this library is permitted only under
   the terms of a written and signed agreement.
*/

/* 
**    file:    d_close.c
**    purpose: routine to close a dbaseiii file after access by the other
**             routines in dbf.lib. updates header and places eof marker
**             at end of file.
**    usage:   d = (struct DBF *)malloc(sizeof(struct DBF));
**             strcpy(d->filename, "filename.dbf");
**             d_open(d);
**             ... access file with other routines ...
**             d_close(d);
**             free(d);
**    notes:   see dbf.h for structure of DBF.  ALWAYS close a file that has
**             been opened, otherwise records may be lost.
**    author:  Mark Sadler
**    revised: 6/18/87
*/

#include <stdio.h>
#ifdef	MSC
#include <dos.h>
#else
#include <time.h>
#endif
#ifndef	unix
#include <malloc.h>
#endif
#include "dbf.h"

void d_close(d)
struct DBF *d;
{
#ifdef	MSC
	union REGS inregs, outregs;
#else
	long time();
	static long clock;
	struct tm *now;
#endif

	if (d->status == updated) {
	/* update date data */
#ifdef	MSC
		inregs.h.ah = 0x2a;
		intdos(&inregs, &outregs);
		d->update_day = outregs.h.dl;
		d->update_mo = outregs.h.dh;
		d->update_yr = (UCHAR)(outregs.x.cx - 1900);
#else
		time(&clock);
		now = localtime(&clock);
		d->update_day = now->tm_mday;
		d->update_mo = now->tm_mon + 1;
		d->update_yr = now->tm_year;
#endif

		/* position at start of file */
		rewind(d->file_ptr);

#ifdef	M_I86
		/* rewrite header */
		fwrite(&d->dbf_version, 1, 12, d->file_ptr);
#else
		/* Change byte order from whatever to i80x86 */
		{
			unsigned long records = d->records;
			unsigned short header_length = d->header_length;
			unsigned short record_length = d->record_length;
			unsigned char *bp;
	
			bp = (unsigned char *) &d->records;
			*(bp+3) = (records >> 24) & 0xFF;
			*(bp+2) = (records >> 16) & 0xFF;
			*(bp+1) = (records >> 8) & 0xFF;
			*bp = records & 0xFF;
			bp = (unsigned char *) &d->header_length;
			*(bp+1) = (header_length >> 8) & 0xFF;
			*bp = header_length & 0xFF;
			bp = (unsigned char *) &d->record_length;
			*(bp+1) = (record_length >> 8) & 0xFF;
			*bp = record_length & 0xFF;

			/* rewrite header */
			fwrite(&d->dbf_version, 1, 12, d->file_ptr);

			/* restore byte order */
			d->records = records;
			d->header_length = header_length;
			d->record_length = record_length;
		}
#endif

		/* position at end of file */
		fseek(d->file_ptr, 0L, 2);
		/* write eof */
		fwrite("\x1a", 1, 1, d->file_ptr);
	}
	/* free fields array and record */
	free(d->fields_ptr);
	free(d->record_ptr);
	fclose(d->file_ptr);
}
