/* EXAMPLE.PRG -  Example of DBEdit() replacement that provides
                  browsing of indexed ranges (subset/detail/child
                  records).  See DBEDIT_R.DOC for details.

=> Compile with /n

   v1.00 (02/22/92) - Original version.

   Copyright (c) 1992, Mike Schinkel
   All Rights Reserved.

*/

PROCEDURE Example()
   LOCAL xRange:= DBEditRange()          // Save the current range

   USE names
   IF !File( "state.ntx" )
      INDEX ON field->state TO state
   ENDIF
   SET INDEX TO state

   CLS
   @ 1,0 TO MaxRow(),MaxCol() DOUBLE
   @ 0,0 SAY "Browse all records"
   DBEDIT( 2,1,MaxRow()-1,MaxCol()-1)

   @ 0,0
   @ 0,0 SAY "Browse only records for state == 'CA'"
   DBEditSetRange( "CA", {|| field->state } )

   DBEDIT( 2,1,MaxRow()-1,MaxCol()-1)

   @ 0,0
   @ 0,0 SAY "Browse records for state from 'FL' to 'GA'"
   DBEditSetRange( {"FL","GA"} )
   DBEDIT( 2,1,MaxRow()-1,MaxCol()-1)

   CLS
   ? "That's all folks..."

   DBEditRange( xRange )               // Restore the previous range
   RETURN


// EOF
