* file: _readdbf.prg
***************************************************************************
*
* READ_DBF Procedure
*
* This is a generic dbf browse, designed to be used from a SET KEY TO
* hot key, but can be called from a menu function.
* The following functions are supported by BROWSE():
*
*    View/Browse, Edit Field, Delete Record, Recall Record
*    Print File (to screen/printer/file), Display/Not Display of
*    deleted records
*
* CALLS: browse (in _browse.prg)
*
***************************************************************************
PROCEDURE Read_DBF
  PRIVATE x, y, z
  x = ""                                         && in case called from a menu, not hot key
  PARAMETERS X, Y, Z

  * --- don't allow recursive calls
  if x="READ_DBF"
    retur
  endif

  * --- save the enviroment when this was called
  PRIVATE the_scrn, the_gets, the_attr, the_keys, thesele
  the_scrn = SSCREEN()                           && save the screen
  the_gets = N_SAVEGETS()                        && save any pending gets
  the_attr = N_SAVEATTR()                        && save screen attributes
  the_keys = N_SAVEKEYS()                        && save any set key to values in effect
  N_ZAPKEYS()                                    && wipe out all set key to values
  thesele = select()                             && save the currently selected area

  clear screen
  setcolor(revC)
  @ 0,0 clear to 2,79
  @ 0,0 to 2,79 
  @ 24,0
  center(1,"DBEDIT 'Browse Data File' Demo")
  center(24,"Select A Data File To Browse or ESC to Abort")
  setcolor(normC)

  filename = pickfile("*.DBF",.f.,.f.,.f.,getC)

  * --- if a filename was included...
  if ! empty(filename)
    Select 0
    IF NET_USE(filename, .F., 5)                 && open it in shared mode
      * --- initialize arrays for fieldnames, pictures and headers
      declare _fields[fcount()+1],_pics[fcount()+1],_heads[fcount()+1]
      AFIELDS(_fields)                           && fill the field name array with field names
      AFIELDS(_heads)                            && fill the header array with the field names
      AFILL(_pics,"@X")                          && all pictures default to @X
      AINS(_fields,1)                            && insert one field at top
      AINS(_heads,1)                             && insert one header at the top
      _fields[1] = "DELETED()"                   && make field one the DELETED() status
      _pics[1]   = "Y"                           && deleted() picture
      _heads[1]  = "DEL"                         && deleted() header
      BROWSE(1,0,23,79,_fields,_pics,_heads)     && call BROWSE function
      USE                                        && close the datafile
    ELSE
      * --- put a nice "file locked" message here.
      boxask(errC,"Unable to lock file for browsing.",3)
    ENDIF
  endif

  * --- restore the enviroment saved before
  N_RESTATTR(the_attr)
  N_RESTGETS(the_gets)
  N_RESTKEYS(the_keys)
  RSCREEN(the_scrn)
  SELECT (thesele)
RETURN
* end of file
