* File: _misc.prg
*********************************************************************
*
* Note that GET_IT is required to activate the following
* functions:
*    N_SAVEGETS()    N_RESTGETS()  save and rest. gets
*    N_SAVEKEYS()    N_RESTKEYS()  save and rest. set key to's
*    N_SAVEATTR()    N_RESTATTR()  save and rest. attributes
*    N_ZAPKEYS()                   wipe out set key to settings
* To allow you to use these routines without GETIT.LIB, I have
* included dummy functions which do nothing and return "".  If
* you have GETIT.LIB (highly recommended!!!!), remove these
* dummy functions and you will have much better routines.  But
* since this is just to demo DBEDIT, it does not matter much.
*
*********************************************************************

*
* Dummy Functions from GETIT.LIB
* (if you have getit.lib, remove these replacement functions!)
*
FUNCTION N_SAVEGETS
RETURN ""

FUNCTION N_SAVEKEYS
RETURN ""

FUNCTION N_SAVEATTR
RETURN ""

FUNCTION N_RESTGETS
  PARAMETERS junk
RETURN ""

FUNCTION N_RESTKEYS
  PARAMETERS junk
RETURN ""

FUNCTION N_RESTATTR
  PARAMETERS junk
RETURN ""

FUNCTION N_ZAPKEYS
RETURN ""


* --- dummy to replace GRUMP.LIB function I really use to draw a box
FUNCTION Shadowbox
  PRIVATE t, l, b, r, type, title
  PARAMETERS t, l, b, r, type, title
  @ t,l clear to b,r
  @ t,l to b,r double
  if pcount() = 6
    CENTER(t,title)
  endif
RETURN ""


* --- Function to save a screen to first available array element
* --- Returns saved element number (to pass to RSCREEN())
FUNCTION SSCREEN
  PRIVATE rvalue
  DO CASE
    CASE empty(screen[1])
      save screen to screen[1]
      rvalue = 1
    CASE empty(screen[2])
      save screen to screen[2]
      rvalue = 2
    CASE empty(screen[3])
      save screen to screen[3]
      rvalue = 3
    CASE empty(screen[4])
      save screen to screen[4]
      rvalue = 4
    OTHERWISE
      rvalue = 0
  ENDCASE
RETURN rvalue

* --- restores screen from passed array element, counterpart to SSCREEN
FUNCTION RSCREEN
  PRIVATE rvalue, cleanit
  PARAMETERS rvalue, cleanit
  cleanit = iif( pcount() != 2, .T., cleanit)
  restore screen from screen[rvalue]
  if cleanit
    screen[rvalue] = space(4000)
  endif
RETURN rvalue


* --- this procedure simple creates memvars needed publicly
FUNCTION MakeVars

  * --- initialize array for holding screens
  PUBLIC screen[4]
  AFILL(screen,space(4000))

  * --- initialize memvars for Colors
  PUBLIC NormC,RevC,GetC,HighC,ErrC,MsgC,HelpC

  * --- initialize memvars for keystrokes (inkey values)
  PUBLIC ENTER_KEY, HOME_KEY, ESC_KEY, PGUP_KEY, PGDN_KEY, END_KEY, ;
  INS_KEY, DEL_KEY, UP_KEY, DOWN_KEY, HELP_KEY, CTRL_HOME, CTRL_END,;
  LOOK_KEY,F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,ALTF2
  enter_key = 13
  home_key  = 1
  esc_key   = 27
  help_key  = 28
  pgup_key  = 18
  pgdn_key  = 3
  end_key   = 6
  ins_key   = 22
  del_key   = 7
  up_key    = 5
  down_key  = 24
  ctrl_home = 29
  ctrl_end  = 23
  look_key  = -1
  F1 = 28
  F2 = -1
  F3 = -2
  F4 = -3
  F5 = -4
  F6 = -5
  F7 = -6
  F8 = -7
  F9 = -8
  F10 = -9
  ALTF2 = -31
RETURN ""

* --- define color setting values to color memvars
FUNCTION InitColor
  if ! iscolor()
    normC = 'W/N,N/W'
    revC  = 'N/W,+W/N'
    highC = '+W/N,+W/N'
    errC  = "+*W/W"
    msgC  = "N/W"
    getC  = "+W/N,N/W,,,+W/N"
    helpc = normC
  else
    normC = "+GR/B,+W/BR,,,+W/B"
    revC  = "N/BG,+W/BR,,,+W/BG"
    getC  = normC
    highC = "+W/B,+W/BG,,,+W/B"
    errC  = "+W/R"
    msgC  = "+W/BR"
    helpC = "+W/G,+W/B,,,W/B"
  endif
  setcolor(normC)
RETURN ""

PROCEDURE Help
RETURN

FUNCTION NET_USE
  ex_use = .F.
  wait   = 3
  PARAMETERS file, ex_use, wait
  PRIVATE forever

  * --- first, see if the file is already open.
  * if it is, simply select it and return.
  FOR X = 1 to 10                                && check all 10 work areas
    if Upper(alias(x)) == upper(file)
      select (x)
      RETUR (.T.)
    endif
  NEXT

  forever = (wait = 0)
  DO WHILE (forever .OR. wait > 0)

    SELECT 0
    IF ex_use                                    && exclusive
      USE &file EXCLUSIVE
    ELSE
      USE &file                                  && shared
    ENDIF

    IF .NOT. NETERR()                            && USE succeeds
      RETUR (.T.)
    ENDIF

    INKEY(1)                                     && wait 1 second
    wait = wait - 1
  ENDDO
RETURN (.F.)                                     && USE fails
* End - NET_USE

FUNCTION ADD_REC
  PARAMETERS wait
  PRIVATE forever

  APPEND BLANK
  IF .NOT. NETERR()
    RETUR (.T.)
  ENDIF

  forever = (wait = 0)
  DO WHILE (forever .OR. wait > 0)

    APPEND BLANK
    IF .NOT. NETERR()
      RETUR .T.
    ENDIF

    INKEY(.5)                                    && wait 1/2 second
    wait = wait - .5

  ENDDO
RETURN (.F.)                                     && not locked
* end of file
