* file: _demoF2.prg
****************************************************************
*
* This module simply creates a sample data input screen, with 
* lots of fields that have "lookup files" associated with them.
* To test this out, press F2 in each field.  Most will respond!
*
****************************************************************
PROCEDURE DemoF2
  PRIVATE the_scrn
  the_scrn = SSCREEN()

  clear screen
  setcolor(revC)
  @ 0,0 clear to 2,79
  @ 0,0 to 2,79 
  center(1,"DBEDIT 'Lookup Codes' Demo")
  @ 24,0
  center(24,"F2 = Lookup Codes     ESC = Quit Lookup Demo")
  setcolor(normC)

  * --- initialize some memvars (these normally come from a DBF!)
  G_fname    = space(15)
  G_lname    = space(15)
  G_bc       = space(1)
  G_refered  = space(30)
  G_icd1     = space(5)
  G_icd2     = space(5)
  G_rvs      = space(8)
  G_attitle  = space(4)
  G_atfirst  = space(15)
  G_atlast   = space(20)
  G_ataddr   = space(30)
  G_atcity   = space(20)
  G_atstat   = space(2)
  G_atzip    = space(10)
  G_atphone  = space(20)
  G_comment  = space(40)

  SET KEY F2 to LOOKITUP

  DO WHILE .t.

    * --- draw a say/get screen, then read
    @ 05,5  say " Firstname:" get G_fname
    @ 06,5  say "  Lastname:" get G_lname
    @ 07,5  say " Bill Code:" get G_bc picture "!"
    @ 08,5  say "   Ref. By:" get G_refered
    @ 09,5  say "ICD Code 1:" get G_icd1
    @ 10,5  say "ICD Code 2:" get G_icd2
    @ 11,5  say "  CPT Code:" get G_rvs
    @ 13,5  say "Atty Title:" get G_attitle
    @ 14,5  say "Atty Fname:" get G_atfirst
    @ 15,5  say "Atty Lname:" get G_atlast
    @ 16,5  say " Atty Addr:" get G_ataddr
    @ 17,5  say " Atty City:" get G_atcity
    @ 17,40 say "State:"      get G_atstat picture "!!"
    @ 17,50 say "Zip Code:"   get G_atzip
    @ 18,5  say " Telephone:" get G_atphone picture "(999) 999-9999 9999"
    @ 20,5  say "  Comments!" get G_comment
    READ

    * --- do it again if ESC was not pressed
    IF lastkey() = ESC_KEY
      exit
    ENDIF

  ENDDO

  SET KEY F2 to
  RSCREEN(the_scrn)

RETURN
* end of file
