* File: _lookup.prg
****************************************************************************
*
* --- LOOKUP FUNCTION
* This procedure takes 5+ parameters, and returns the selected field value.
*
* PARAMETERS
*  dbf        data file to look in
*  idx        the index file to use, if any
*  fields     array of fields to display
*  heads      array of field headers to display
*  retfield   field containing the data to return when selected
*  lookfield  field to "LOCATE ON" if a key is pressed
*  t,l,b,r    Top, Left, Bottom, Right window coordinates
*
* RETURN
*  if ESC pressed, returns ""
*  if ENTER pressed, return data in currently highlighted RETFIELD
*
* To see how to use this function, see the LOOKITUP procedure.
*
* CALLED BY: LOOKITUP (in _lookitu.prg)
*
***************************************************************************
FUNCTION Lookup

  PRIVATE the_scrn, top, lft, bot, rgt,t,l,b,r,selected, in_color
  PARAMETERS dbf,idx,fields,heads,retfield,lookfield,t,l,b,r

  * --- must be at least 1 field (DBF)
  if pcount() < 1
    retur ""
  endif

  * --- open the data file and index if file is not already open
  selected = select()                            && save the currently selected area
  IF select(dbf) = 0                             && is the DBF already in use
    Select 0                                     && no, so open it
    IF NET_USE(dbf, .F., 5)                      && in shared mode.
      if pcount() > 1                            && was an index parameter passed?
        if !empty(idx)
          SET INDEX TO &idx                      && yes, so open it
        endif
      endif
    ELSE
      boxask(errC,"File Locked, Try Again Later.",3)
      retur ""
    ENDIF
    used_it = .T.                                && flag to indicate the file was opened here
  ELSE
    select &dbf                                  && file is already open, so select it
    if empty(idx)                                && if no index passed, make sure none is used
      set order to 0
    endif
    go top                                       && start at the top of the file
    used_it = .F.                                && flag indicates file was already open
  ENDIF

  * --- save the screen
  the_scrn = SSCREEN()

  * --- set up the window parameters
  if pcount() = 10
    top = t
    lft = l
    bot = b
    rgt = r
  else
    * --- if no t, l, b, r passed, use these as defaults
    top = 5
    lft = 10
    bot = 22
    rgt = 69
  endif

  * --- Default lookup field name is the first field if none is passed.
  if type("LOOKFIELD") != "C"
    lookfield = fieldname(1)
  endif

  * --- draw the box
  in_color = setcolor(M->revC)                   && set the window color
  shadowbox(top,lft,bot,rgt,5,"HIGHLIGHT AND PRESS <enter> TO SELECT")

  set key HELP_KEY to                            && deactivate F1 help (udf handles it)
  DBEDIT(top+2,lft+2,bot-1,rgt-2,fields,"Get_UDF_ch",.F.,heads)
  set key HELP_KEY to help                       && reset help key

  * --- if ESC was not pressed, return the value in the currently selected
  *     return field, otherwise return ""
  if lastkey() != ESC_KEY
    ret_val = &retfield
  else
    ret_val = ""
  endif

  * --- if opened the DBF, close it, otherwise, reselect index 1
  * (note, this is rather arbitrary, but it works for me!)
  if used_it
    use
  else
    set order to 1
  endif

  * --- restore the enviroment and return
  select (selected)
  setcolor(in_color)
  RSCREEN(the_scrn)
RETURN ret_val

* --- this is a simple DBEDIT udf for the LOOKUP function
FUNCTION Get_UDF_ch
  PARA mode, indx
  PRIVATE mkey, Cur_rec, rvalue
  DO CASE

      * --- don't do anything for modes 0-3
    CASE mode < 4
      rvalue = 1

      * --- end the DBEDIT on ENTER or ESC (select or abort)
    CASE lastkey() = ENTER_KEY .or. lastkey() = ESC_KEY
      rvalue = 0                                 && 0 means end the DBEDIT

      * F1 key is pressed
    CASE lastkey() = HELP_KEY
      do help with "LOOKUP",0,"LOOKING"
      rvalue = 1                                 && 1 means, continue DBEDIT

      * --- any other alphabetical key, find first match
    OTHERWISE
      cur_rec = recno()
      mkey = upper(chr(lastkey()))
      if (mkey >= ' ' .and. mkey <= 'z')
        go top
        locate for &lookfield = mkey
        if eof()
          ?? chr(7)
          go cur_rec
        endif
      endif
      rvalue = 1
  ENDCASE
RETURN rvalue
* end of file
