* File: _Lookitu.prg
****************************************************************************
*
* LOOKITUP.PRG
*
* This module is called in response to an F2 keypress.  Its
* job is to do the appropriate lookup using DBEDIT, obtain a return value,
* then STUFF into the correct spot.  Activate it with a
*
*    SET KEY F2 TO LOOKITUP
*
* at the beginning of the program.
*
* Calls: LOOKUP to really do the work.  This just sets it up.
*
* Careful study of the function calls here will teach a lot about what can
* really be done inside of a DBEDIT user defined function.  Especially 
* notice how the return field can be manipulated, like the stuffing of
* a CHR(25) (control-Y), etc.
*
****************************************************************************
PROCEDURE LOOKITUP
  PARAMETERS prg, line, memvar

  * --- I declare this at the start and use it in any of the CASE statements
  DECLARE f[1], h[1]                             && F is field expression, H is header
  temp = ""

  DO CASE

      * --- bill code field, look in BCLOOK.DBF for a value, return the code
    CASE memvar = "G_BC"
      f[1] = "descrip + ' ' + bc"
      h[1] = "Code Description    Code"
      temp = lookup("bclook","",f,h,"bc","descrip")

      * --- referring doctor
      *     Note that when a doctor is selected, this will cause the previous
      *     doctor's name to be deleted (Ctrl-Y), and the selected doctor's
      *     name will be entered formatted with "DR. " plus the last name.
      *     This is all controlled in the RETFIELD parameter!
    CASE memvar = "G_REFERED"
      f[1] = "DR_NAME + ' ' + DR_NUMBER + ' ' +DR_LIC"
      h[1] = "Doctor's Name                  No  Licence"
      temp = lookup("doctors","dr_name",f,h,"chr(25)+'DR. '+left(dr_first,1)+'. '+trim(dr_last)+' '+trim(dr_lic)+chr(13)","dr_name")

      * --- diagnosis code, return the diagnosis code
    CASE left(memvar,5) == "G_ICD"
      f[1] = "ICD_DESCRI + ' ' + ICD"
      h[1] = "Description of Code            ICD-9"
      temp = lookup("icdcodes","",f,h,"icd","icd_descri")

      * --- procedure code, return the code
    CASE memvar = "G_RVS"
      f[1] = "RVS_DESCRI+' '+RVS+'  '+iif(!empty(rvs_charge),STR(RVS_CHARGE,10,2),space(10))+'  '+iif(diagnostic,'YES','   ')"
      h[1] = "Description of Code            CPT Code      Charge  Diag"
      temp = lookup("rvscodes","",f,h,"rvs","rvs_descri")

      * --- if in title field, return all attorney data (name, address, etc.)
    CASE memvar = "G_ATTITLE"
      f[1] = "ATT_LAST+' '+Left(ATT_FIRST,10)+' '+left(ATT_CITY,10)+' '+ATT_NOTE"
      h[1] = "LASTNAME             FIRST      CITY       NOTE"
      temp = lookup("attyname","attyname",f,h,"att_title+att_first+att_last+att_addr+att_city+att_state+att_zip+att_phone","att_last",3,5,21,74)

      * --- if in attorney first name field, return only attorney's name
    CASE memvar = "G_ATFIRST"
      f[1] = "ATT_LAST+' '+left(ATT_FIRST,10)+' '+left(ATT_CITY,10)+' '+ATT_NOTE"
      h[1] = "LASTNAME             FIRST      CITY       NOTE"
      temp = lookup("attyname","attyname",f,h,"att_first+att_last","att_last",3,5,21,74)

  ENDCASE

  * --- now, stuff the keyboard with the TEMP value, if there is any
  if ! empty(temp) .and. lastkey() != ESC_KEY
    KEYBOARD temp
  endif

RETURN
* end of file
