* file: _browse.prg
**********************************************************************
* This is the BROWSE function, which demonstrates a call to 
* DBEDIT() with a UDF that does the real work.
*
* PASS: t = top of box  b = bottom of box
*       l = left side   r = right side
*       fields = array of fields to browse
*       pics = array of picture clauses
*       heads = array of headers
*
* RETUR: nothing useful
*
* CALLED BY: read_dbf (in _readdbf.prg)
*
***********************************************************************
FUNCTION BROWSE
  PRIVATE t,l,b,r, the_scrn
  PARAMETERS t,l,b,r,fields,pics,heads

  * --- all parameters are required to be passed...
  if pcount() != 7
    retur .f.
  endif

  * --- check validity of B (bottom) and R (right) settings
  b = iif( b > 23, 23, b)
  r = iif( r > 79, 79, r)

  * --- save the screen and set colors
  the_scrn = SSCREEN()
  clear screen

  * --- draw a help line at the bottom of the screen
  in_color = setcolor(normC)
  @ 24,0
  @ 24,1 say "F1 Help  F4 Print  F8 Add  F9 Delete  F10 Exit  ENTER to Edit  - - Pan Lt/Rt"
  setcolor(revC)

  * --- this is used in the UDF
  public del_stat
  del_stat = .T.

  * --- shadowbox is a GRUMP.LIB function which draws a box on screen
  *     I have replaced it with a simple dummy function with no shadow.
  shadowbox(t,l,b,r,4)

  * --- turn off the F1 help key (its handled from inside DBEDIT())
  set key HELP_KEY to

  *
  * CALL DBEDIT WITH UDF BACTION() TO WORK INSIDE THE WINDOW DRAWN
  *
  DBEDIT(t+1,l+1,b-1,r-1,fields,"baction",pics,heads)

  * --- now clean things up and return
  set key HELP_KEY to help
  RSCREEN(the_scrn)
  setcolor(in_color)
  release del_stat

RETURN .T.

************************************************************************
*
* This is the UDF called by the BROWSE function dbedit()
*
* DBEDIT automatically passes two parameters: MODE and INDX
*    mode is the current mode dbedit() is in.
*    indx is the index into the field list (the array element) that
*       is currently highlighted.
*
************************************************************************
FUNCTION BAction
  PARA mode, indx

  * --- these are used inside the function here
  PRIVATE mkey, Cur_rec, incolor

  * --- Important: save the key that got you here, if any
  key = lastkey()

  * --- clear space on the top line for this info...
  incolor = setcolor(normC)
  @ 00,00 say space(20)
  @ 00,58 say space(21)
  @ 00,01 say "Record No"
  @ 00,58 say iif(readinsert()," <<<Insert Mode>>>  ","<<<Overwrite Mode>>>")
  setcolor(incolor)

  ***************************************************************************
  *
  * This is the heart and soul of the dbedit UDF.  It is a simple DO CASE
  * system that acts according to the mode or the keypress that got you
  * into the UDF.  The return value (see book) is important!
  *
  ***************************************************************************
  DO CASE

    CASE mode = 0                                && Idle, show record number
      incolor = setcolor(normC)
      @ 00,11 say alltrim(str(recno()))
      setcolor(incolor)

      if indx = 1                                && don't all the cursor in the DELETED() field,
        keyboard chr(4)                          && by forcing a <right arrow> if the user tries
      endif
      retur (1)

    CASE mode = 1                                && top of file
      boxask(msgC,"Already At Top of File",3)         
      retur (1)

    CASE mode = 2                                && bottom of file
      boxask(msgC,"You are at the End of the File.","Use F8 To Add A Record.",3)
      retur (1)

    CASE mode = 3                                && DBF is empty so add one record
      if !add_rec(5)
        boxask(errC,"Unable to Add Record",3)
      endif
      retur (1)

      ***********************************************************************
      *
      * Anything that gets past this point is a MODE 4, keyboard exception.
      * You can use another CASE mode = 4, and then start another DO CASE
      * for each of the keystrokes, but it is not necessary...
      *
      ***********************************************************************

      * --- these occur on MODE=4, Keyboard Exception
    CASE key = HELP_KEY
      do help with "BROWSE",0,"BROWSING"
      retur (1)

    CASE key = ENTER_KEY .or. key = -6           && return/F2 to edit
      if indx > 1                                && no editing of the DELETED() function
        if rlock()                               && lock the record
          set cursor on                          && turn the cursor on
          fld_name = fields[indx]                && what field are we on?
          fld_pic  = pics[indx]                  && what is the picture for this field?
          hed_name = upper(heads[indx])          && what's the header here?
          t_screen = SSCREEN()                   && save the screen
          __color = setcolor(normC)              && save the color

          * --- draw a box with a title
          shadowbox(8,1,15,78,5,"[ Field Editing Window ]")

          setcolor(getC)

          ****************************************************************
          *
          * Now, depending upon the field type, do the editing.
          * If its a CHAR field, and is too long for the window,
          * do the GET on the next line..
          *
          * NOTE: This can be expanded to allow editing of all types
          * of fields, including MEMO, by using a DO CASE and working
          * accordingly...                                                
          *
          ****************************************************************
          if type(fld_name) = "C"
            * --- get of a char type field
            if len(&fld_name)+len(hed_name) < 70
              @ 12,4 say "&hed_name"+" "  get &fld_name picture fld_pic
            else
              @ 12,3 say "&hed_name"
              @ 13,3 get &fld_name picture fld_pic
            endif
          else
            * --- get of a LOGICAL or NUM type field
            @ 12,4 say "&hed_name"+" "  get &fld_name picture fld_pic
          endif

          READ

          setcolor(__color)
          RSCREEN(t_screen)
          set cursor off
          unlock
        else
          boxask(errC,"Unable to Lock Record",3)
        endif
      endif
      @ 00,11 say alltrim(str(recno()))
      retur 1

      * --- this toggle the DELETED() status
    CASE key = DEL_KEY .or. key = -8
      if rlock()
        if ! deleted()
          DELETE
        else
          RECALL
        endif
        unlock
      else
        boxask(errC,"Unable to Lock Record",3)
      endif
      retur 1

      * --- this toggle the INSERT/OVERWRITE status
    CASE key = INS_KEY                           && ^V/Ins - toggle insert status
      if readinsert()
        readinsert(.f.)
      else
        readinsert(.t.)
      endif
      incolor = setcolor(normC)
      @ 00,58 say space(21)
      @ 00,58 say iif(readinsert(),"  <<<Insert Mode>>> ","<<<Overwrite Mode>>>")
      setcolor(incolor)
      retur (32)        && this means, ignore the keystroke

      * --- this exits the BROWSE...
    CASE key = ESC_KEY .or. key = -9             && press ESC/F10 to exit
      retur (0)

    CASE key = 287 .or. key = -4                 && alt-S toggles deleted status
      if del_stat                                && That is, should DELETED()
        set deleted off                          && records be shown or not.
        del_stat = .f.                           && NOTE: UNDOCUMENTED ON SCREEN
      else
        set deleted on
        del_stat = .t.
      endif
      retur (2)

    CASE key = 286 .or. key = -7                 && Alt-A/F8 Add Rec
      if boxask(msgC,"Add a Blank Record? ") = "Y"
        if !add_rec(5)
          boxask(errC,"Unable to Add Record",3)
        endif
      endif

    CASE key = 281 .or. key = -3                 && ALT-P print current data file
      set cursor on
      outto = boxask(msgC,"Output to <S>creen, <F>ile or <P>rinter (S)? ")
      if outto = "P"
        psize = boxask(msgC,"Print <N>ormal, <E>lite or <C>ondensed (N)? ")
        IF psize = "E"
          * --- set printer to 12 cpi
        ELSEIF psize = "C"
          * --- set printer to 17 cpi
          set console off
          set print on
          ?? chr(15)
          set console on
          set print off
        ENDIF
      elseif outto = "F"
        pgets = N_SAVEGETS()
        save screen to pscreen
        mfname = space(12)
        @ 24,0
        @ 24,0 say "Enter a valid DOS filename.... " ;
        get mfname picture "@!" valid ! empty(mfname)
        read
        restore screen from pscreen
        N_RESTGETS(pgets)
      endif

      the_rec = recno()                          && remember current position
      go top                                     && go to the top

      ******************************************************************
      *
      * FLIST is a field list memvar (C) that will be built here
      * This is needed for the LIST command, which needs an all
      * CHAR type expression passed.
      *                                                                 
      ******************************************************************
      flist = field(1)                           && what is the name of field 1?
      for x = 2 to fcount()                      && process each field from 2 to the end
        DO CASE                                  && and convert the type to CHAR
          CASE type(field(x)) = "C"
            flist = flist + "+' '+" + field(x)
          CASE type(field(x)) = "D"
            flist = flist + "+' '+DTOC(" + field(x) + ")"
          CASE type(field(x)) = "N"
            flist = flist + "+' '+STR(" + field(x) + ",10,2)"
          CASE type(field(x)) = "L"
            flist = flist + "+' '+IIF(" + field(x) + ",'Yes','No')"
        ENDCASE
      next

      * --- now do the necessary LIST command to display/print the data
      do case
        case outto = "F"
          set console off
          LIST off &flist for !deleted() .and. !eof() while ;
          inkey() != ESC_KEY TO FILE &mfname
          set console on
        case outto = "P"
          set console off
          LIST off &flist for !deleted() .and. !eof() while ;
          inkey() != ESC_KEY TO PRINT
          set console on
        otherwise
          the_screen = SSCREEN()
          scol = setcolor(normC)
          clear screen
          LIST off &flist for !deleted() .and. !eof() while ;
          inkey() != ESC_KEY
          ?
          wait
          setcolor(scol)
          RSCREEN(the_screen)
      endcase
      go the_rec
      set cursor off

      * --- on any other keystroke, to a LOCATE to find the first occurance
      *     of that character.  This can/should be modified for LARGE dbf's.
    OTHERWISE
      cur_rec = recno()
      mkey = upper(chr(lastkey()))
      fld_name = fields[indx]
      if (mkey >= ' ' .and. mkey <= '}')
        go top
        locate for left(&fld_name,1) = mkey
        if eof()
          ?? chr(7)
          boxask(errC," No Match for &mkey.. ",2)
          go cur_rec
        endif
      endif
      retur (1)
  ENDCASE
RETURN (1)

