* talk.prg
* This file demonstrates index progress display without indexing on a UDF.
*
* Specify DBF name and ONE character field to index on.

para dbf,fld

clear
use &dbf
set cursor off
@ 12,28 say "RECORDS TO INDEX: "
NtxTalkOn()
index on &fld to demo
NtxTalkOff()
use
set cursor on
return

*EOF talk

* INSTRUCTIONS: compile normally. Note there is no error checking.
*               LINK as follows:
*               
*               LINK talk,,,dbdtalk clipper /NOE
*    -OR-
*               TLINK talk,,,dbdtalk clipper      (version 1.1)
*    -OR-     
*               PLINK86 fi talk lib dbdtalk,clipper
*
* NOTE that DBDTALK.LIB must procede CLIPPER.LIB on the command line
* You can ignore the following (microsoft link) error message:
*
* CLIPPER.LIB(\clipper\asm\asupport.asm):error L2025: __bcopy:symbol defined
* more than once
* pos: 2069 Record type: 53E4
*
* There was 1 error detected
*
* I do replace one small CLIPPER library module. This is why you will get the
* message. It is harmless.
*
* This version is meant solely to 'wet your appetite' so to speak. It will
* provide an accurate report of indexing as it happens, but is limited to
* indexing on a single CHARACTER field. The data will be displayed at the 
* current cursor location in the current screen color in ascending order.
*
* The production version of this function permits specifying ROW, COL, COLOR
* METHOD (count up or down), as well as provides an accurate count for
* indexing multiple fields of any data type combination.
*
* You may use this as a demo of the function, but may not include it in any 
* commercial application. Full information about dbdINDEX by Data Base Designs
* may be had by calling or writing to:
*
* Gary Gruber
* Data Base Designs
* 79-925 Trinidad Dr.
* Bermuda Dunes, Calif. 92201
* 619-345-6595
*
* dbdINDEX is the SIXTH in a series of utilities for Clipper programmers from
* Data Base Designs. In addition to index progress reports, the complete
* package has many other useful index access routines heretofore unavailable
* in any commercial package!





