// Compile : clipper sodb /n/m/w/a
// Link    : blinker file sodb lib objectdb blink incre off

#include "dbfsix.ch"
#include "objectdb.ch"

function main(nCount)
local oTable, nSeconds

if valtype(nCount)=='C'
   nCount:=val(nCount)
else
   nCount:=1000
endif

INITIALIZE OBJECTDB
odAddUser('DEMOUSER', 'DEMOPASS', 1)

IF db():logon('DEMOUSER', 'DEMOPASS')
   CONNECT DATABASE

   oTable:=context():new(db():table('STOCK', 'STOCK3', .f.))
   oTable:setDirtyRead(.t.)

   do case
   case oTable:numRecs()==0
      nSeconds:=FillWithRandomData(oTable, nCount)
   endcase
   set alternate to sodb.txt
   set alternate on
   ? 'Product   : ObjectDB v'+db():version()
   ? 'Clipper   : ', version()
   ? 'Exclusive : ', 'OFF'
   ? 'Fields    : ', oTable:oTable:numCols()
   ? 'Iterations: ', nCount
   ? 'RDD       : ', dbSetDriver()
   ? 'Dirty Read: ', oTable:setDirtyRead()
   ? 'Memory(0) : ', memory(0)
   if .not. nSeconds==NIL
      ? 'FillData  : ', nSeconds
   endif
   SpeedTest(oTable, nCount)
   close alternate

   DISCONNECT DATABASE
endif
return NIL

function SpeedTest(oTable, nCount)
local n, nBegin, nFCount

nBegin:=seconds()
for n:=1 to nCount
   oTable:Top()
next
? 'GO TOP    : ', seconds()-nBegin

nBegin:=seconds()
for n:=1 to nCount
   oTable:Bottom()
next
? 'GO BOTTOM : ', seconds()-nBegin

oTable:Top()
nBegin:=seconds()
for n:=1 to nCount
   oTable:skip()
next
? 'SKIP      : ', seconds()-nBegin

nBegin:=seconds()
for n:=1 to nCount
   oTable:seek({'1'})
next
? 'SEEK      : ', seconds()-nBegin

oTable:setScope({'7'})
oTable:top()
nBegin:=seconds()
for n:=1 to nCount
   oTable:skip()
next
? 'SCOPE SKIP: ', seconds()-nBegin

return NIL

DATA DEFINITION MODULE
   DEFINE DATABASE SPEED

   DEFINE TABLE STOCK ALIAS STOCK
      COLUMN STOCKID    CHAR ( 10 )
      COLUMN BALANCE    NUM  (  8, 2 )
      COLUMN DESCRIPTIO CHAR ( 40 )

   PRIMARY KEY STOCKID

   DEFINE INDEX STOCK2 ON balance
   DEFINE INDEX STOCK3 ON descriptio

END DATA DEFINITION MODULE

function FillWithRandomData(oTable, nCount)
local n, nField, xData, nBegin, cType, aTypes
nBegin:=seconds()

* valType(oTable:fieldGet(nField)) returns "U" in ObjectDB so the data
* types have been hard coded here
aTypes:=array(oTable:oTable:numCols)
aFill(aTypes, 'C')
aTypes[2]:='N'

for n:=1 to nCount
   oTable:newRec()
   for nField:=1 to oTable:oTable:numCols()
      if nField==1
         oTable:fldPut(1, str(n, 5))
      else
         cType:=aTypes[nField]
         do case
         case cType$'CM'
            xData:=chr(seconds()%255)
         case cType=='N'
            xData:=seconds()%255
         case cType=='L'
            xData:=((seconds()%2)==1)
         case cType=='D'
            xData:=date()+(seconds()%355)
         endcase
         oTable:fldPut(nField, xData)
      endif
   next
   oTable:addRec()
next
return seconds()-nBegin
