// Compile : clipper sdbc /n/m/w/a
// Link    : blinker file sdbc @dbcbcy2 blink incre off

#include "dbclass.ch"
field stockid, balance, description

function main(nCount)
local oTable, nSeconds

* declare RDDs here
* s_RDDAdd(s_RDDSIX())

* ObjectDB 1.02 doesn't run in exclusive mode so this test is in shared mode
set exclusive off

if valtype(nCount)=='C'
   nCount:=val(nCount)
else
   nCount:=1000
endif
s_ESet(P_NTXBAR, .f.)
oTable:=TableDefinition()
if oTable:exist()<=S_NFALSE
   oTable:create()
endif
oTable:use()
do case
case oTable:lastRec()==0
   nSeconds:=FillWithRandomData(oTable, nCount)
   oTable:reindex()
case oTable:indexExist()<=S_NFALSE
   oTable:reindex()
otherwise
   oTable:setIndex()
endcase
set alternate to sdbc.txt
set alternate on
? 'Product   : dbClass v'+s_dbcVersion()
? 'Clipper   : ', version()
? 'Exclusive : ', iif(set(_SET_EXCLUSIVE), 'ON', 'OFF')
? 'Fields    : ', oTable:fCount()
? 'Iterations: ', nCount
? 'RDD       : ', dbSetDriver()
? 'Dirty Read: ', .t.
? 'Memory(0) : ', memory(0)
if .not. nSeconds==NIL
   ? 'FillData  : ', nSeconds
endif
SpeedTest(oTable, nCount)
close alternate
oTable:close()
return NIL

function SpeedTest(oTable, nCount)
local n, nBegin, nFCount

nBegin:=seconds()
for n:=1 to nCount
   oTable:goTop()
next
? 'GO TOP    : ', seconds()-nBegin

nBegin:=seconds()
for n:=1 to nCount
   oTable:goBottom()
next
? 'GO BOTTOM : ', seconds()-nBegin

oTable:goTop()
nBegin:=seconds()
for n:=1 to nCount
   oTable:skip()
next
? 'SKIP      : ', seconds()-nBegin

nBegin:=seconds()
for n:=1 to nCount
   oTable:seek('1')
next
? 'SEEK      : ', seconds()-nBegin

oTable:setScope('7', '7')
oTable:goTop()
nBegin:=seconds()
for n:=1 to nCount
   oTable:skip()
next
? 'SCOPE SKIP: ', seconds()-nBegin

return NIL

function TableDefinition()
local oTable, aStru:={;
{'STOCKID'   , 'C', 10, 0},;
{'BALANCE'   , 'N',  8, 2},;
{'DESCRIPTIO', 'C', 40, 0}}

oTable:=s_dbTable():new('STOCK', 'STOCK')

oTable:structAssign(aStru)
oTable:IndexAdd(oTable:indexClass():;
new('STOCK1', {|| stockId}    , "stockId"    ,,,,'STOCK1'))
oTable:IndexAdd(oTable:indexClass():;
new('STOCK2', {|| balance}    , "balance"    ,,,,'STOCK2'))
oTable:IndexAdd(oTable:indexClass():;
new('STOCK3', {|| description}, "description",,,,'STOCK3'))
return oTable

function FillWithRandomData(oTable, nCount)
local n, nField, xData, nBegin, cType, aTypes
nBegin:=seconds()

* valType(oTable:fieldGet(nField)) returns "U" in ObjectDB so the data
* types have been hard coded here
aTypes:=array(oTable:fCount())
aFill(aTypes, 'C')
aTypes[2]:='N'

for n:=1 to nCount
   oTable:append()
   for nField:=1 to oTable:fCount()
      if nField==1
         oTable:fieldPut(1, str(n, 5))
      else
         cType:=aTypes[nField]
         do case
         case cType$'CM'
            xData:=chr(seconds()%255)
         case cType=='N'
            xData:=seconds()%255
         case cType=='L'
            xData:=((seconds()%2)==1)
         case cType=='D'
            xData:=date()+(seconds()%355)
         endcase
         oTable:fieldPut(nField, xData)
      endif
   next
next
return seconds()-nBegin
